/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.modref;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.modref.DelegatingExtendedHeapModel;
import com.ibm.wala.ipa.modref.ExtendedHeapModel;
import com.ibm.wala.ipa.modref.GenReach;
import com.ibm.wala.ipa.slicer.HeapExclusions;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModRef {
    public static ModRef make() {
        return new ModRef();
    }

    protected ModRef() {
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeMod(CallGraph cg, PointerAnalysis pa, HeapExclusions heapExclude) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        Map<CGNode, Collection<PointerKey>> scan = this.scanForMod(cg, pa, heapExclude);
        return this.transitiveClosure(cg, scan);
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeRef(CallGraph cg, PointerAnalysis pa, HeapExclusions heapExclude) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        Map<CGNode, Collection<PointerKey>> scan = this.scanForRef(cg, pa, heapExclude);
        return this.transitiveClosure(cg, scan);
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeMod(CallGraph cg, PointerAnalysis pa) {
        return this.computeMod(cg, pa, null);
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeRef(CallGraph cg, PointerAnalysis pa) {
        return this.computeRef(cg, pa, null);
    }

    private Map<CGNode, OrdinalSet<PointerKey>> transitiveClosure(CallGraph cg, Map<CGNode, Collection<PointerKey>> scan) {
        try {
            GenReach<CGNode, PointerKey> gr = new GenReach<CGNode, PointerKey>(GraphInverter.invert(cg), scan);
            BitVectorSolver<CGNode> solver = new BitVectorSolver<CGNode>((IKilldallFramework<CGNode, BitVectorVariable>)gr);
            solver.solve(null);
            HashMap<CGNode, OrdinalSet<PointerKey>> result = HashMapFactory.make();
            for (CGNode n : cg) {
                BitVectorVariable bv = (BitVectorVariable)solver.getOut(n);
                result.put(n, new OrdinalSet(bv.getValue(), gr.getLatticeValues()));
            }
            return result;
        }
        catch (CancelException e) {
            throw new CancelRuntimeException(e);
        }
    }

    private Map<CGNode, Collection<PointerKey>> scanForMod(CallGraph cg, PointerAnalysis pa, HeapExclusions heapExclude) {
        HashMap<CGNode, Collection<PointerKey>> result = HashMapFactory.make();
        for (CGNode n : cg) {
            result.put(n, this.scanNodeForMod(n, pa, heapExclude));
        }
        return result;
    }

    private Map<CGNode, Collection<PointerKey>> scanForRef(CallGraph cg, PointerAnalysis pa, HeapExclusions heapExclude) {
        HashMap<CGNode, Collection<PointerKey>> result = HashMapFactory.make();
        for (CGNode n : cg) {
            result.put(n, this.scanNodeForRef(n, pa, heapExclude));
        }
        return result;
    }

    private Collection<PointerKey> scanNodeForMod(CGNode n, PointerAnalysis pa, HeapExclusions heapExclude) {
        Set<PointerKey> result = HashSetFactory.make();
        DelegatingExtendedHeapModel h = new DelegatingExtendedHeapModel(pa.getHeapModel());
        ModVisitor v = this.makeModVisitor(n, result, pa, h);
        IR ir = n.getIR();
        if (ir != null) {
            Iterator<SSAInstruction> it = ir.iterateNormalInstructions();
            while (it.hasNext()) {
                it.next().visit(v);
            }
        }
        if (heapExclude != null) {
            result = heapExclude.filter(result);
        }
        return result;
    }

    private Collection<PointerKey> scanNodeForRef(CGNode n, PointerAnalysis pa, HeapExclusions heapExclude) {
        Set<PointerKey> result = HashSetFactory.make();
        DelegatingExtendedHeapModel h = new DelegatingExtendedHeapModel(pa.getHeapModel());
        RefVisitor v = this.makeRefVisitor(n, result, pa, h);
        IR ir = n.getIR();
        if (ir != null) {
            Iterator<SSAInstruction> it = ir.iterateNormalInstructions();
            while (it.hasNext()) {
                it.next().visit(v);
            }
        }
        if (heapExclude != null) {
            result = heapExclude.filter(result);
        }
        return result;
    }

    protected ModVisitor makeModVisitor(CGNode n, Collection<PointerKey> result, PointerAnalysis pa, ExtendedHeapModel h) {
        return this.makeModVisitor(n, result, pa, h, false);
    }

    protected ModVisitor makeModVisitor(CGNode n, Collection<PointerKey> result, PointerAnalysis pa, ExtendedHeapModel h, boolean ignoreAllocHeapDefs) {
        return new ModVisitor(n, result, h, pa, ignoreAllocHeapDefs);
    }

    public Set<PointerKey> getMod(CGNode n, ExtendedHeapModel h, PointerAnalysis pa, SSAInstruction s, HeapExclusions hexcl) {
        return this.getMod(n, h, pa, s, hexcl, false);
    }

    public Set<PointerKey> getMod(CGNode n, ExtendedHeapModel h, PointerAnalysis pa, SSAInstruction s, HeapExclusions hexcl, boolean ignoreAllocHeapDefs) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        HashSet<PointerKey> result = HashSetFactory.make(2);
        ModVisitor v = this.makeModVisitor(n, result, pa, h, ignoreAllocHeapDefs);
        s.visit(v);
        return hexcl == null ? result : hexcl.filter(result);
    }

    protected RefVisitor makeRefVisitor(CGNode n, Collection<PointerKey> result, PointerAnalysis pa, ExtendedHeapModel h) {
        return new RefVisitor(n, result, pa, h);
    }

    public Set<PointerKey> getRef(CGNode n, ExtendedHeapModel h, PointerAnalysis pa, SSAInstruction s, HeapExclusions hexcl) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        HashSet<PointerKey> result = HashSetFactory.make(2);
        RefVisitor v = this.makeRefVisitor(n, result, pa, h);
        s.visit(v);
        return hexcl == null ? result : hexcl.filter(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ModVisitor
    extends SSAInstruction.Visitor {
        private final CGNode n;
        private final Collection<PointerKey> result;
        private final ExtendedHeapModel h;
        private final PointerAnalysis pa;
        private final boolean ignoreAllocHeapDefs;

        protected ModVisitor(CGNode n, Collection<PointerKey> result, ExtendedHeapModel h, PointerAnalysis pa, boolean ignoreAllocHeapDefs) {
            this.n = n;
            this.result = result;
            this.h = h;
            this.pa = pa;
            this.ignoreAllocHeapDefs = ignoreAllocHeapDefs;
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
            block15: {
                InstanceKey i;
                block13: {
                    PointerKey pk;
                    block14: {
                        if (!instruction.getConcreteType().isArrayType()) break block13;
                        int dim = instruction.getConcreteType().getDimensionality();
                        if (dim <= 1) break block14;
                        InstanceKey ik = this.h.getInstanceKeyForAllocation(this.n, instruction.getNewSite());
                        if (ik != null) {
                            PointerKey pk2 = this.h.getPointerKeyForArrayContents(ik);
                            assert (pk2 != null);
                            this.result.add(pk2);
                            pk2 = this.h.getPointerKeyForArrayLength(ik);
                            assert (pk2 != null);
                            this.result.add(pk2);
                        }
                        int d = 0;
                        while (d < dim - 1) {
                            InstanceKey i2 = this.h.getInstanceKeyForMultiNewArray(this.n, instruction.getNewSite(), d);
                            if (i2 != null) {
                                PointerKey pk3 = this.h.getPointerKeyForArrayContents(i2);
                                assert (pk3 != null);
                                this.result.add(pk3);
                                pk3 = this.h.getPointerKeyForArrayLength(i2);
                                assert (pk3 != null);
                                this.result.add(pk3);
                            }
                            ++d;
                        }
                        break block15;
                    }
                    InstanceKey i3 = this.h.getInstanceKeyForAllocation(this.n, instruction.getNewSite());
                    if (i3 == null) break block15;
                    if (!this.ignoreAllocHeapDefs) {
                        pk = this.h.getPointerKeyForArrayContents(i3);
                        assert (pk != null);
                        this.result.add(pk);
                    }
                    pk = this.h.getPointerKeyForArrayLength(i3);
                    assert (pk != null);
                    this.result.add(pk);
                    break block15;
                }
                if (!this.ignoreAllocHeapDefs && (i = this.h.getInstanceKeyForAllocation(this.n, instruction.getNewSite())) != null) {
                    IClass type = i.getConcreteType();
                    for (IField f : type.getAllInstanceFields()) {
                        PointerKey pk = this.h.getPointerKeyForInstanceField(i, f);
                        assert (pk != null);
                        this.result.add(pk);
                    }
                }
            }
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getArrayRef());
            for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                this.result.add(this.h.getPointerKeyForArrayContents(i));
            }
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
            IField f = this.pa.getClassHierarchy().resolveField(instruction.getDeclaredField());
            if (f != null) {
                if (instruction.isStatic()) {
                    this.result.add(this.h.getPointerKeyForStaticField(f));
                } else {
                    PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getRef());
                    if (ref != null) {
                        for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                            this.result.add(this.h.getPointerKeyForInstanceField(i, f));
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RefVisitor
    extends SSAInstruction.Visitor {
        private final CGNode n;
        private final Collection<PointerKey> result;
        private final PointerAnalysis pa;
        private final ExtendedHeapModel h;

        protected RefVisitor(CGNode n, Collection<PointerKey> result, PointerAnalysis pa, ExtendedHeapModel h) {
            this.n = n;
            this.result = result;
            this.pa = pa;
            this.h = h;
        }

        @Override
        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
            PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getArrayRef());
            for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                this.result.add(this.h.getPointerKeyForArrayLength(i));
            }
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getArrayRef());
            for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                this.result.add(this.h.getPointerKeyForArrayContents(i));
            }
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            IField f = this.pa.getClassHierarchy().resolveField(instruction.getDeclaredField());
            if (f != null) {
                if (instruction.isStatic()) {
                    this.result.add(this.h.getPointerKeyForStaticField(f));
                } else {
                    PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getRef());
                    for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                        this.result.add(this.h.getPointerKeyForInstanceField(i, f));
                    }
                }
            }
        }
    }
}

