/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.ArrayContentsKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKeyWithFilter;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ExceptionReturnValueKey;

public class DefaultPointerKeyFactory
implements PointerKeyFactory {
    public PointerKey getPointerKeyForLocal(CGNode node, int valueNumber) {
        if (valueNumber <= 0) {
            throw new IllegalArgumentException("illegal value number: " + valueNumber + " in " + node);
        }
        return new LocalPointerKey(node, valueNumber);
    }

    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode node, int valueNumber, FilteredPointerKey.TypeFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("null filter");
        }
        assert (valueNumber > 0) : "illegal value number: " + valueNumber + " in " + node;
        return new LocalPointerKeyWithFilter(node, valueNumber, filter);
    }

    public PointerKey getPointerKeyForReturnValue(CGNode node) {
        return new ReturnValueKey(node);
    }

    public PointerKey getPointerKeyForExceptionalReturnValue(CGNode node) {
        return new ExceptionReturnValueKey(node);
    }

    public PointerKey getPointerKeyForStaticField(IField f) {
        if (f == null) {
            throw new IllegalArgumentException("null f");
        }
        return new StaticFieldKey(f);
    }

    public PointerKey getPointerKeyForInstanceField(InstanceKey I, IField field) {
        if (field == null) {
            throw new IllegalArgumentException("field is null");
        }
        return new InstanceFieldKey(I, field);
    }

    public PointerKey getPointerKeyForArrayContents(InstanceKey I) {
        return new ArrayContentsKey(I);
    }
}

