/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.callgraph.propagation.ArrayContentsKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ExceptionReturnValueKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Comparator;

public class PointerKeyComparator
implements Comparator {
    private final IClassHierarchy cha;

    public PointerKeyComparator(IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("null cha");
        }
        this.cha = cha;
    }

    protected int comparePrimitives(TypeReference r1, TypeReference r2) {
        int h2;
        int h1 = r1.hashCode();
        if (h1 != (h2 = r2.hashCode())) {
            return h1 - h2;
        }
        assert (r1 == r2);
        return 0;
    }

    protected int compareConcreteTypes(IClass k1, IClass k2) {
        int n2;
        int n1 = this.cha.getNumber(k1);
        if (n1 != (n2 = this.cha.getNumber(k2))) {
            return n1 - n2;
        }
        int s1 = k1.hashCode();
        int s2 = k2.hashCode();
        assert (k1 == k2 || s1 != s2);
        return s1 - s2;
    }

    protected int compareInstanceKeys(InstanceKey k1, InstanceKey k2) {
        return this.compareConcreteTypes(k1.getConcreteType(), k2.getConcreteType());
    }

    protected int compareFields(IField if1, IField if2) {
        int f2;
        int f1 = if1.hashCode();
        if (f1 != (f2 = if2.hashCode())) {
            return f1 - f2;
        }
        assert (if1 == if2);
        return 0;
    }

    private int compareLocalKey(LocalPointerKey key1, Object key2) {
        if (key2 instanceof LocalPointerKey) {
            int n2;
            int l2;
            int l1 = key1.getValueNumber();
            if (l1 != (l2 = ((LocalPointerKey)key2).getValueNumber())) {
                return l1 - l2;
            }
            int n1 = key1.getNode().getGraphNodeId();
            if (n1 != (n2 = ((LocalPointerKey)key2).getNode().getGraphNodeId())) {
                return n1 - n2;
            }
            assert (key1.equals(key2));
            return 0;
        }
        return -1;
    }

    private int compareReturnValueKey(ReturnValueKey key1, Object key2) {
        if (key2 instanceof ReturnValueKey) {
            int n2;
            int n1 = key1.getNode().getGraphNodeId();
            if (n1 != (n2 = ((ReturnValueKey)key2).getNode().getGraphNodeId())) {
                return n1 - n2;
            }
            assert (key1.equals(key2));
            return 0;
        }
        return -1;
    }

    private int compareExceptionKey(ExceptionReturnValueKey key1, Object key2) {
        if (key2 instanceof ExceptionReturnValueKey) {
            int n2;
            int n1 = key1.getNode().getGraphNodeId();
            if (n1 != (n2 = ((ExceptionReturnValueKey)key2).getNode().getGraphNodeId())) {
                return n1 - n2;
            }
            assert (key1.equals(key2));
            return 0;
        }
        return -1;
    }

    private int compareFieldKey(InstanceFieldKey key1, Object key2) {
        if (key2 instanceof InstanceFieldKey) {
            int r1 = this.compareInstanceKeys(key1.getInstanceKey(), ((InstanceFieldKey)key2).getInstanceKey());
            if (r1 != 0) {
                return r1;
            }
            return this.compareFields(key1.getField(), ((InstanceFieldKey)key2).getField());
        }
        return -1;
    }

    private int compareStaticKey(StaticFieldKey key1, Object key2) {
        if (key2 instanceof StaticFieldKey) {
            int n2;
            int n1 = this.cha.getNumber(key1.getField().getDeclaringClass());
            if (n1 != (n2 = this.cha.getNumber(((StaticFieldKey)key2).getField().getDeclaringClass()))) {
                return n1 - n2;
            }
            return this.compareFields(key1.getField(), ((StaticFieldKey)key2).getField());
        }
        return -1;
    }

    private int compareArrayKey(ArrayContentsKey key1, Object key2) {
        if (key2 instanceof ArrayContentsKey) {
            int d2;
            ArrayClass k1 = (ArrayClass)key1.getInstanceKey().getConcreteType();
            ArrayClass k2 = (ArrayClass)((ArrayContentsKey)key2).getInstanceKey().getConcreteType();
            int d1 = k1.getDimensionality();
            if (d1 != (d2 = k2.getDimensionality())) {
                return d1 - d2;
            }
            if (k1.getInnermostElementClass() == null) {
                if (k2.getInnermostElementClass() == null) {
                    return this.comparePrimitives(k1.getReference().getInnermostElementType(), k2.getReference().getInnermostElementType());
                }
                return -1;
            }
            if (k2.getInnermostElementClass() == null) {
                return 1;
            }
            return this.compareConcreteTypes(k1.getInnermostElementClass(), k2.getInnermostElementClass());
        }
        return -1;
    }

    public int compare(Object key1, Object key2) {
        if (key1 == key2) {
            return 0;
        }
        if (key1 instanceof LocalPointerKey) {
            return this.compareLocalKey((LocalPointerKey)key1, key2);
        }
        if (key2 instanceof LocalPointerKey) {
            return -1 * this.compareLocalKey((LocalPointerKey)key2, key1);
        }
        if (key1 instanceof ReturnValueKey) {
            return this.compareReturnValueKey((ReturnValueKey)key1, key2);
        }
        if (key2 instanceof ReturnValueKey) {
            return -1 * this.compareReturnValueKey((ReturnValueKey)key2, key1);
        }
        if (key1 instanceof ExceptionReturnValueKey) {
            return this.compareExceptionKey((ExceptionReturnValueKey)key1, key2);
        }
        if (key2 instanceof ExceptionReturnValueKey) {
            return -1 * this.compareExceptionKey((ExceptionReturnValueKey)key2, key1);
        }
        if (key1 instanceof InstanceFieldKey) {
            return this.compareFieldKey((InstanceFieldKey)key1, key2);
        }
        if (key2 instanceof InstanceFieldKey) {
            return -1 * this.compareFieldKey((InstanceFieldKey)key2, key1);
        }
        if (key1 instanceof StaticFieldKey) {
            return this.compareStaticKey((StaticFieldKey)key1, key2);
        }
        if (key2 instanceof StaticFieldKey) {
            return -1 * this.compareStaticKey((StaticFieldKey)key2, key1);
        }
        if (key1 instanceof ArrayContentsKey) {
            return this.compareArrayKey((ArrayContentsKey)key1, key2);
        }
        if (key2 instanceof ArrayContentsKey) {
            return -1 * this.compareArrayKey((ArrayContentsKey)key2, key1);
        }
        return this.compareOtherKeys(key1, key2);
    }

    protected int compareOtherKeys(Object key1, Object key2) {
        System.err.println("Cannot compare " + key1 + " and " + key2);
        Assertions.UNREACHABLE();
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof PointerKeyComparator && ((PointerKeyComparator)o).cha.equals(this.cha);
    }

    public int hashCode() {
        return this.cha.hashCode();
    }
}

