/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;

public final class ConcreteTypeKey
implements InstanceKey {
    private final IClass type;

    public ConcreteTypeKey(IClass type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (type.isInterface()) {
            Assertions.UNREACHABLE("unexpected interface: " + type);
        }
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConcreteTypeKey) {
            ConcreteTypeKey other = (ConcreteTypeKey)obj;
            return this.type.equals(other.type);
        }
        return false;
    }

    public int hashCode() {
        return 461 * this.type.hashCode();
    }

    public String toString() {
        return "[" + this.type + "]";
    }

    public IClass getType() {
        return this.type;
    }

    public IClass getConcreteType() {
        return this.type;
    }

    public static InstanceKey[] getInstanceKeysForPEI(SSAInstruction pei, IR ir, IClassHierarchy cha) {
        if (pei == null) {
            throw new IllegalArgumentException("pei is null");
        }
        Collection<TypeReference> types = pei.getExceptionTypes();
        if (types == null) {
            return null;
        }
        InstanceKey[] result = new InstanceKey[types.size()];
        int i = 0;
        for (TypeReference type : types) {
            assert (type != null);
            IClass klass = cha.lookupClass(type);
            result[i++] = new ConcreteTypeKey(klass);
        }
        return result;
    }
}

