/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.DefaultIRFactory;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSACache;
import com.ibm.wala.util.ref.ReferenceCleanser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisCache {
    private final IRFactory<IMethod> irFactory;
    private final SSACache ssaCache;

    public AnalysisCache(IRFactory<IMethod> irFactory) {
        this.irFactory = irFactory;
        this.ssaCache = new SSACache(irFactory);
        ReferenceCleanser.registerCache(this);
    }

    public AnalysisCache() {
        this(new DefaultIRFactory());
    }

    public void invalidate(IMethod method, Context C) {
        this.ssaCache.invalidate(method, C);
    }

    public SSACache getSSACache() {
        return this.ssaCache;
    }

    public IRFactory<IMethod> getIRFactory() {
        return this.irFactory;
    }

    public IR getIR(IMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        return this.ssaCache.findOrCreateIR(method, Everywhere.EVERYWHERE, new AnalysisOptions().getSSAOptions());
    }

    public DefUse getDefUse(IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        return this.ssaCache.findOrCreateDU(ir, Everywhere.EVERYWHERE);
    }
}

