/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.drivers;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.examples.drivers.PDFTypeHierarchy;
import com.ibm.wala.examples.properties.WalaExamplesProperties;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphStats;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.InferGraphRoots;
import com.ibm.wala.util.graph.traverse.DFSAllPathsFinder;
import com.ibm.wala.util.io.CommandLine;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PathBuilder {
    public static boolean isDirectory(String appJar) {
        return new File(appJar).isDirectory();
    }

    public static String findJarFiles(String[] directories) throws WalaException {
        HashSet<String> result = HashSetFactory.make();
        int i = 0;
        while (i < directories.length) {
            for (File f : FileUtil.listFiles(directories[i], ".*\\.jar", true)) {
                result.add(f.getAbsolutePath());
            }
            ++i;
        }
        return PathBuilder.composeString(result);
    }

    private static String composeString(Collection<String> s) {
        StringBuffer result = new StringBuffer();
        Iterator<String> it = s.iterator();
        int i = 0;
        while (i < s.size() - 1) {
            result.append(it.next());
            result.append(File.pathSeparator);
            ++i;
        }
        if (it.hasNext()) {
            result.append(it.next());
        }
        return result.toString();
    }

    public static void main(String[] args) throws WalaException, IllegalArgumentException, CancelException {
        PathBuilder.run(args);
    }

    public static void run(String[] args) throws WalaException, IllegalArgumentException, CancelException {
        Properties p = CommandLine.parse(args);
        PathBuilder.validateCommandLine(p);
        PathBuilder.run(p.getProperty("appJar"), p.getProperty("exclusionFile", CallGraphTestUtil.REGRESSION_EXCLUSIONS));
    }

    public static void run(String appJar, String exclusionFile) throws IllegalArgumentException, CancelException {
        try {
            List listNodes;
            Graph<CGNode> g = PathBuilder.buildPrunedCallGraph(appJar, new FileProvider().getFile(exclusionFile));
            Properties p = null;
            try {
                p = WalaExamplesProperties.loadProperties();
                p.putAll((Map<?, ?>)WalaProperties.loadProperties());
            }
            catch (WalaException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            Iterator<CGNode> it = InferGraphRoots.inferRoots(g).iterator();
            Filter<CGNode> filter = new Filter<CGNode>(){

                @Override
                public boolean accepts(CGNode o) {
                    return true;
                }
            };
            DFSAllPathsFinder<CGNode> dfs = new DFSAllPathsFinder<CGNode>(g, (CGNode)((Object)it), filter);
            int count = 0;
            while ((listNodes = dfs.find()) != null) {
                ArrayList<CGNode> path = new ArrayList<CGNode>();
                try {
                    int i = 0;
                    while (i < listNodes.size()) {
                        CGNode node = (CGNode)listNodes.get(i);
                        IMethod imeth = node.getMethod();
                        if (!(imeth instanceof AbstractRootMethod)) {
                            path.add(node);
                        }
                        ++i;
                    }
                }
                catch (RuntimeException _) {
                    continue;
                }
                CGNode last = (CGNode)listNodes.get(0);
                if (g.getSuccNodeCount(last) > 0) {
                    boolean isBackEdge = false;
                    Iterator<CGNode> itNodes = g.getSuccNodes(last);
                    while (itNodes.hasNext()) {
                        CGNode succ = itNodes.next();
                        if (!path.contains(succ)) continue;
                        isBackEdge = true;
                        break;
                    }
                    if (!isBackEdge) continue;
                }
                if (path.size() <= 1) continue;
                ++count;
                Collections.reverse(path);
                StringBuffer sb = new StringBuffer();
                boolean firstTime = true;
                for (CGNode node : path) {
                    IMethod method = node.getMethod();
                    IClass clazz = method.getDeclaringClass();
                    if (firstTime) {
                        if (!clazz.isPublic() || method.isClinit() || method.isInit()) break;
                        firstTime = false;
                    }
                    String className = clazz.getReference().getName().toString();
                    String methName = method.getSelector().toString();
                    String randoopMethodString = PathBuilder.toRandoopString(className, methName);
                    sb.append(randoopMethodString);
                    sb.append(", ");
                }
                if (firstTime) continue;
                System.out.println(sb);
            }
            System.err.printf("A total of %d call-stacks have been found.", count);
        }
        catch (WalaException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String toRandoopString(String className, String methodName) {
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        sb.append(';');
        sb.append(methodName);
        return sb.toString();
    }

    public static Graph<CGNode> buildPrunedCallGraph(String appJar, File exclusionFile) throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(appJar, exclusionFile != null ? exclusionFile : new File(CallGraphTestUtil.REGRESSION_EXCLUSIONS));
        ClassHierarchy cha = ClassHierarchy.make(scope);
        ClassLoaderReference clr = scope.getApplicationLoader();
        Iterable<Entrypoint> entrypoints = PathBuilder.publicEntrypoints(clr, cha);
        AnalysisOptions options = new AnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        System.err.println(CallGraphStats.getStats(cg));
        Graph<CGNode> g = PathBuilder.pruneForAppLoader(cg);
        return g;
    }

    public static Iterable<Entrypoint> publicEntrypoints(ClassLoaderReference clr, IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        final HashSet result = HashSetFactory.make();
        for (IClass klass : cha) {
            if (!klass.isPublic()) continue;
            for (IMethod m : klass.getAllMethods()) {
                IClass tmp;
                if (m == null || !m.isPublic() || m.isInit() || m.isClinit() || m.isNative() || PathBuilder.isMain(m) || klass != (tmp = m.getDeclaringClass()) || klass.getClassLoader().getReference() != clr) continue;
                result.add(new DefaultEntrypoint(m, cha));
            }
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                return result.iterator();
            }
        };
    }

    private static boolean isMain(IMethod m) {
        return m.isPublic() && m.isStatic() && m.getSignature().endsWith("([Ljava/lang/String;)V");
    }

    public static Graph<CGNode> pruneForAppLoader(CallGraph g) throws WalaException {
        return PDFTypeHierarchy.pruneGraph(g, new ApplicationLoaderFilter());
    }

    public static void validateCommandLine(Properties p) {
        if (p.get("appJar") == null) {
            throw new UnsupportedOperationException("expected command-line to include -appJar");
        }
    }

    private static class ApplicationLoaderFilter
    implements Filter<CGNode> {
        private ApplicationLoaderFilter() {
        }

        @Override
        public boolean accepts(CGNode o) {
            if (o instanceof CGNode) {
                CGNode n = o;
                return n.getMethod().getDeclaringClass().getClassLoader().getReference().equals(ClassLoaderReference.Application);
            }
            if (o instanceof LocalPointerKey) {
                LocalPointerKey l = (LocalPointerKey)((Object)o);
                return this.accepts(l.getNode());
            }
            return false;
        }
    }
}

