/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.drivers;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.examples.drivers.PDFCallGraph;
import com.ibm.wala.examples.properties.WalaExamplesProperties;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.strings.StringStuff;
import com.ibm.wala.viz.PDFViewUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class PDFWalaIR {
    public static final String PDF_FILE = "ir.pdf";

    public static void main(String[] args) throws IOException {
        PDFWalaIR.run(args);
    }

    public static Process run(String[] args) throws IOException {
        PDFWalaIR.validateCommandLine(args);
        return PDFWalaIR.run(args[1], args[3]);
    }

    public static Process run(String appJar, String methodSig) throws IOException {
        try {
            MethodReference mr;
            AnalysisScope scope;
            ClassHierarchy cha;
            IMethod m;
            if (PDFCallGraph.isDirectory(appJar)) {
                appJar = PDFCallGraph.findJarFiles(new String[]{appJar});
            }
            if ((m = (cha = ClassHierarchy.make(scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(appJar, new FileProvider().getFile(CallGraphTestUtil.REGRESSION_EXCLUSIONS)))).resolveMethod(mr = StringStuff.makeMethodReference(methodSig))) == null) {
                Assertions.UNREACHABLE("could not resolve " + mr);
            }
            AnalysisOptions options = new AnalysisOptions();
            options.getSSAOptions().setPiNodePolicy(SSAOptions.getAllBuiltInPiNodes());
            AnalysisCache cache = new AnalysisCache();
            IR ir = cache.getSSACache().findOrCreateIR(m, Everywhere.EVERYWHERE, options.getSSAOptions());
            if (ir == null) {
                Assertions.UNREACHABLE("Null IR for " + m);
            }
            System.err.println(ir.toString());
            Properties wp = null;
            try {
                wp = WalaProperties.loadProperties();
                wp.putAll((Map<?, ?>)WalaExamplesProperties.loadProperties());
            }
            catch (WalaException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            String psFile = String.valueOf(wp.getProperty("output_dir")) + File.separatorChar + PDF_FILE;
            String dotFile = String.valueOf(wp.getProperty("output_dir")) + File.separatorChar + "temp.dt";
            String dotExe = wp.getProperty("dot_exe");
            String gvExe = wp.getProperty("pdfview_exe");
            return PDFViewUtil.ghostviewIR(cha, ir, psFile, dotFile, dotExe, gvExe);
        }
        catch (WalaException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void validateCommandLine(String[] args) {
        if (args.length != 4) {
            throw new UnsupportedOperationException("must have at exactly 4 command-line arguments");
        }
        if (!args[0].equals("-appJar")) {
            throw new UnsupportedOperationException("invalid command-line, args[0] should be -appJar, but is " + args[0]);
        }
        if (!args[2].equals("-sig")) {
            throw new UnsupportedOperationException("invalid command-line, args[2] should be -sig, but is " + args[0]);
        }
    }
}

