/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.drivers;

import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.examples.properties.WalaExamplesProperties;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.MethodEntryStatement;
import com.ibm.wala.ipa.slicer.MethodExitStatement;
import com.ibm.wala.ipa.slicer.SDG;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphIntegrity;
import com.ibm.wala.util.graph.GraphSlicer;
import com.ibm.wala.util.io.CommandLine;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.NodeDecorator;
import com.ibm.wala.viz.PDFViewUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class PDFSDG {
    private static final String PDF_FILE = "sdg.pdf";

    public static void main(String[] args) throws WalaException, IllegalArgumentException, CancelException, IOException {
        PDFSDG.run(args);
    }

    public static Process run(String[] args) throws WalaException, IllegalArgumentException, CancelException, IOException {
        Properties p = CommandLine.parse(args);
        PDFSDG.validateCommandLine(p);
        return PDFSDG.run(p.getProperty("appJar"), p.getProperty("mainClass"), PDFSDG.getDataDependenceOptions(p), PDFSDG.getControlDependenceOptions(p));
    }

    public static Slicer.DataDependenceOptions getDataDependenceOptions(Properties p) {
        String d = p.getProperty("dd", "full");
        Slicer.DataDependenceOptions[] dataDependenceOptionsArray = Slicer.DataDependenceOptions.values();
        int n = dataDependenceOptionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Slicer.DataDependenceOptions result = dataDependenceOptionsArray[n2];
            if (d.equals(result.getName())) {
                return result;
            }
            ++n2;
        }
        Assertions.UNREACHABLE("unknown data datapendence option: " + d);
        return null;
    }

    public static Slicer.ControlDependenceOptions getControlDependenceOptions(Properties p) {
        String d = p.getProperty("cd", "full");
        Slicer.ControlDependenceOptions[] controlDependenceOptionsArray = Slicer.ControlDependenceOptions.values();
        int n = controlDependenceOptionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Slicer.ControlDependenceOptions result = controlDependenceOptionsArray[n2];
            if (d.equals(result.getName())) {
                return result;
            }
            ++n2;
        }
        Assertions.UNREACHABLE("unknown control datapendence option: " + d);
        return null;
    }

    public static Process run(String appJar, String mainClass, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions) throws IllegalArgumentException, CancelException, IOException {
        try {
            AnalysisScope scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(appJar, new FileProvider().getFile(CallGraphTestUtil.REGRESSION_EXCLUSIONS));
            ClassHierarchy cha = ClassHierarchy.make(scope);
            Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, mainClass);
            AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
            SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
            CallGraph cg = builder.makeCallGraph(options, null);
            SDG sdg = new SDG(cg, builder.getPointerAnalysis(), dOptions, cOptions);
            try {
                GraphIntegrity.check(sdg);
            }
            catch (GraphIntegrity.UnsoundGraphException e1) {
                e1.printStackTrace();
                Assertions.UNREACHABLE();
            }
            System.err.println(sdg);
            Properties p = null;
            try {
                p = WalaExamplesProperties.loadProperties();
                p.putAll((Map<?, ?>)WalaProperties.loadProperties());
            }
            catch (WalaException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            String psFile = String.valueOf(p.getProperty("output_dir")) + File.separatorChar + PDF_FILE;
            String dotExe = p.getProperty("dot_exe");
            Graph<Statement> g = PDFSDG.pruneSDG(sdg);
            DotUtil.dotify(g, PDFSDG.makeNodeDecorator(), "temp.dt", psFile, dotExe);
            String gvExe = p.getProperty("pdfview_exe");
            return PDFViewUtil.launchPDFView(psFile, gvExe);
        }
        catch (WalaException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Graph<Statement> pruneSDG(final SDG sdg) {
        Filter<Statement> f = new Filter<Statement>(){

            @Override
            public boolean accepts(Statement o) {
                Statement s = o;
                if (s.getNode().equals(sdg.getCallGraph().getFakeRootNode())) {
                    return false;
                }
                return !(s instanceof MethodExitStatement) && !(s instanceof MethodEntryStatement);
            }
        };
        return GraphSlicer.prune(sdg, f);
    }

    private static NodeDecorator makeNodeDecorator() {
        return new NodeDecorator(){

            @Override
            public String getLabel(Object o) throws WalaException {
                Statement s = (Statement)o;
                switch (s.getKind()) {
                    case HEAP_PARAM_CALLER: 
                    case HEAP_PARAM_CALLEE: 
                    case HEAP_RET_CALLER: 
                    case HEAP_RET_CALLEE: {
                        HeapStatement h = (HeapStatement)s;
                        return (Object)((Object)s.getKind()) + "\\n" + h.getNode() + "\\n" + h.getLocation();
                    }
                }
                return s.toString();
            }
        };
    }

    static void validateCommandLine(Properties p) {
        if (p.get("appJar") == null) {
            throw new UnsupportedOperationException("expected command-line to include -appJar");
        }
        if (p.get("mainClass") == null) {
            throw new UnsupportedOperationException("expected command-line to include -appJar");
        }
    }
}

