/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.drivers;

import com.ibm.wala.cfg.cdg.ControlDependenceGraph;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.examples.drivers.PDFCallGraph;
import com.ibm.wala.examples.properties.WalaExamplesProperties;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.strings.StringStuff;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.PDFViewUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class PDFControlDependenceGraph {
    public static final boolean SANITIZE_CFG = false;
    public static final String PDF_FILE = "cdg.pdf";

    public static void main(String[] args) throws IOException {
        PDFControlDependenceGraph.run(args);
    }

    public static Process run(String[] args) throws IOException {
        PDFControlDependenceGraph.validateCommandLine(args);
        return PDFControlDependenceGraph.run(args[1], args[3]);
    }

    public static Process run(String appJar, String methodSig) throws IOException {
        try {
            MethodReference mr;
            AnalysisScope scope;
            ClassHierarchy cha;
            IMethod m;
            if (PDFCallGraph.isDirectory(appJar)) {
                appJar = PDFCallGraph.findJarFiles(new String[]{appJar});
            }
            if ((m = (cha = ClassHierarchy.make(scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(appJar, new FileProvider().getFile(CallGraphTestUtil.REGRESSION_EXCLUSIONS)))).resolveMethod(mr = StringStuff.makeMethodReference(methodSig))) == null) {
                System.err.println("could not resolve " + mr);
                throw new RuntimeException();
            }
            AnalysisOptions options = new AnalysisOptions();
            options.getSSAOptions().setPiNodePolicy(SSAOptions.getAllBuiltInPiNodes());
            AnalysisCache cache = new AnalysisCache();
            IR ir = cache.getSSACache().findOrCreateIR(m, Everywhere.EVERYWHERE, options.getSSAOptions());
            if (ir == null) {
                Assertions.UNREACHABLE("Null IR for " + m);
            }
            System.err.println(ir.toString());
            ControlDependenceGraph<SSAInstruction, ISSABasicBlock> cdg = new ControlDependenceGraph<SSAInstruction, ISSABasicBlock>(ir.getControlFlowGraph());
            Properties wp = null;
            try {
                wp = WalaProperties.loadProperties();
                wp.putAll((Map<?, ?>)WalaExamplesProperties.loadProperties());
            }
            catch (WalaException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            String psFile = String.valueOf(wp.getProperty("output_dir")) + File.separatorChar + PDF_FILE;
            String dotFile = String.valueOf(wp.getProperty("output_dir")) + File.separatorChar + "temp.dt";
            String dotExe = wp.getProperty("dot_exe");
            String gvExe = wp.getProperty("pdfview_exe");
            DotUtil.dotify(cdg, PDFViewUtil.makeIRDecorator(ir), dotFile, psFile, dotExe);
            return PDFViewUtil.launchPDFView(psFile, gvExe);
        }
        catch (WalaException e) {
            e.printStackTrace();
            return null;
        }
    }

    static void validateCommandLine(String[] args) {
        if (args.length != 4) {
            throw new UnsupportedOperationException("must have at exactly 4 command-line arguments");
        }
        if (!args[0].equals("-appJar")) {
            throw new UnsupportedOperationException("invalid command-line, args[0] should be -appJar, but is " + args[0]);
        }
        if (!args[2].equals("-sig")) {
            throw new UnsupportedOperationException("invalid command-line, args[2] should be -sig, but is " + args[0]);
        }
    }
}

