/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.drivers;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.examples.drivers.PDFTypeHierarchy;
import com.ibm.wala.examples.properties.WalaExamplesProperties;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphStats;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.io.CommandLine;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.io.FileUtil;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.PDFViewUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class PDFCallGraph {
    private static final String PDF_FILE = "cg.pdf";

    public static boolean isDirectory(String appJar) {
        return new File(appJar).isDirectory();
    }

    public static String findJarFiles(String[] directories) throws WalaException {
        HashSet<String> result = HashSetFactory.make();
        int i = 0;
        while (i < directories.length) {
            for (File f : FileUtil.listFiles(directories[i], ".*\\.jar", true)) {
                result.add(f.getAbsolutePath());
            }
            ++i;
        }
        return PDFCallGraph.composeString(result);
    }

    private static String composeString(Collection<String> s) {
        StringBuffer result = new StringBuffer();
        Iterator<String> it = s.iterator();
        int i = 0;
        while (i < s.size() - 1) {
            result.append(it.next());
            result.append(File.pathSeparator);
            ++i;
        }
        if (it.hasNext()) {
            result.append(it.next());
        }
        return result.toString();
    }

    public static void main(String[] args) throws WalaException, IllegalArgumentException, CancelException {
        PDFCallGraph.run(args);
    }

    public static Process run(String[] args) throws WalaException, IllegalArgumentException, CancelException {
        Properties p = CommandLine.parse(args);
        PDFCallGraph.validateCommandLine(p);
        return PDFCallGraph.run(p.getProperty("appJar"), p.getProperty("exclusionFile", CallGraphTestUtil.REGRESSION_EXCLUSIONS));
    }

    public static Process run(String appJar, String exclusionFile) throws IllegalArgumentException, CancelException {
        try {
            Graph<CGNode> g = PDFCallGraph.buildPrunedCallGraph(appJar, new FileProvider().getFile(exclusionFile));
            Properties p = null;
            try {
                p = WalaExamplesProperties.loadProperties();
                p.putAll((Map<?, ?>)WalaProperties.loadProperties());
            }
            catch (WalaException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            String pdfFile = String.valueOf(p.getProperty("output_dir")) + File.separatorChar + PDF_FILE;
            String dotExe = p.getProperty("dot_exe");
            DotUtil.dotify(g, null, "temp.dt", pdfFile, dotExe);
            String gvExe = p.getProperty("pdfview_exe");
            return PDFViewUtil.launchPDFView(pdfFile, gvExe);
        }
        catch (WalaException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Graph<CGNode> buildPrunedCallGraph(String appJar, File exclusionFile) throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(appJar, exclusionFile != null ? exclusionFile : new File(CallGraphTestUtil.REGRESSION_EXCLUSIONS));
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Iterable<Entrypoint> entrypoints = PDFCallGraph.publicEntrypoints(scope.getApplicationLoader(), cha);
        AnalysisOptions options = new AnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        System.err.println(CallGraphStats.getStats(cg));
        return cg;
    }

    public static Iterable<Entrypoint> publicEntrypoints(ClassLoaderReference clr, IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        final HashSet result = HashSetFactory.make();
        for (IClass klass : cha) {
            if (!klass.getClassLoader().getReference().equals(clr)) continue;
            for (IMethod m : klass.getAllMethods()) {
                if (m == null || !m.isPublic() || m.isInit() || m.isClinit() || m.isNative()) continue;
                result.add(new DefaultEntrypoint(m, cha));
            }
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                return result.iterator();
            }
        };
    }

    public static Graph<CGNode> pruneForAppLoader(CallGraph g) throws WalaException {
        return PDFTypeHierarchy.pruneGraph(g, new ApplicationLoaderFilter());
    }

    public static void validateCommandLine(Properties p) {
        if (p.get("appJar") == null) {
            throw new UnsupportedOperationException("expected command-line to include -appJar");
        }
    }

    private static class ApplicationLoaderFilter
    implements Filter<CGNode> {
        private ApplicationLoaderFilter() {
        }

        @Override
        public boolean accepts(CGNode o) {
            if (o instanceof CGNode) {
                CGNode n = o;
                return n.getMethod().getDeclaringClass().getClassLoader().getReference().equals(ClassLoaderReference.Application);
            }
            if (o instanceof LocalPointerKey) {
                LocalPointerKey l = (LocalPointerKey)((Object)o);
                return this.accepts(l.getNode());
            }
            return false;
        }
    }
}

