/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.analysis;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.client.AbstractAnalysisEngine;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.OrdinalSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;

public class SimpleThreadEscapeAnalysis
extends AbstractAnalysisEngine {
    private final Set<JarFile> applicationJarFiles;
    private final String applicationMainClass;

    public SimpleThreadEscapeAnalysis(Set<JarFile> applicationJarFiles, String applicationMainClass) {
        this.applicationJarFiles = applicationJarFiles;
        this.applicationMainClass = applicationMainClass;
    }

    @Override
    protected CallGraphBuilder getCallGraphBuilder(IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache) {
        return Util.makeZeroCFABuilder(options, cache, cha, this.scope);
    }

    private void collectJars(File f, Set<JarFile> result) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            int i = 0;
            while (i < files.length) {
                this.collectJars(files[i], result);
                ++i;
            }
        } else if (f.getAbsolutePath().endsWith(".jar")) {
            result.add(new JarFile(f));
        }
    }

    private JarFile[] getSystemJars() throws IOException {
        String javaHomePath = "garbage";
        HashSet<JarFile> jarFiles = HashSetFactory.make();
        try {
            Properties p = WalaProperties.loadProperties();
            javaHomePath = p.getProperty("java_runtime_dir");
        }
        catch (WalaException p) {
            // empty catch block
        }
        File x = new File(javaHomePath);
        if (!x.exists() || !x.isDirectory()) {
            javaHomePath = System.getProperty("java.home");
            if (!javaHomePath.endsWith(File.separator)) {
                javaHomePath = String.valueOf(javaHomePath) + File.separator;
            }
            javaHomePath = String.valueOf(javaHomePath) + "lib";
        }
        this.collectJars(new File(javaHomePath), jarFiles);
        return jarFiles.toArray(new JarFile[jarFiles.size()]);
    }

    private Set<JarFileModule> getModuleFiles() {
        HashSet<JarFileModule> result = HashSetFactory.make();
        Iterator<JarFile> jars = this.applicationJarFiles.iterator();
        while (jars.hasNext()) {
            result.add(new JarFileModule(jars.next()));
        }
        return result;
    }

    public Set<IClass> gatherThreadEscapingClasses() throws IOException, ClassHierarchyException, IllegalArgumentException, CancelException {
        this.setModuleFiles(this.getModuleFiles());
        this.setJ2SELibraries(this.getSystemJars());
        this.buildAnalysisScope();
        IClassHierarchy cha = this.buildClassHierarchy();
        assert (cha != null) : "failed to create class hierarchy";
        this.setClassHierarchy(cha);
        Iterable<Entrypoint> roots = Util.makeMainEntrypoints(this.getScope(), cha, this.applicationMainClass);
        AnalysisOptions options = this.getDefaultOptions(roots);
        this.buildCallGraph(cha, options, true, null);
        CallGraph cg = this.getCallGraph();
        PointerAnalysis pa = this.getPointerAnalysis();
        HashSet<PointerKey> escapeAnalysisRoots = HashSetFactory.make();
        HeapModel heapModel = pa.getHeapModel();
        for (IClass cls : cha) {
            Collection<IField> staticFields = cls.getDeclaredStaticFields();
            for (IField sf : staticFields) {
                if (!sf.getFieldTypeReference().isReferenceType()) continue;
                escapeAnalysisRoots.add(heapModel.getPointerKeyForStaticField(sf));
            }
        }
        Collection<IClass> threads = cha.computeSubClasses(TypeReference.JavaLangThread);
        for (IClass cls : threads) {
            for (IMethod m : cls.getDeclaredMethods()) {
                if (!m.isInit()) continue;
                Set<CGNode> nodes = cg.getNodes(m.getReference());
                for (CGNode n : nodes) {
                    escapeAnalysisRoots.add(heapModel.getPointerKeyForLocal(n, 1));
                }
            }
        }
        HashSet<InstanceKey> escapingInstanceKeys = HashSetFactory.make();
        for (PointerKey root : escapeAnalysisRoots) {
            OrdinalSet<InstanceKey> objects = pa.getPointsToSet(root);
            for (InstanceKey obj : objects) {
                escapingInstanceKeys.add(obj);
            }
        }
        HashSet newKeys = HashSetFactory.make();
        do {
            newKeys.clear();
            for (InstanceKey key : escapingInstanceKeys) {
                IClass type = key.getConcreteType();
                if (!type.isReferenceType()) continue;
                if (type.isArrayClass()) {
                    if (((ArrayClass)type).getElementClass() == null) continue;
                    PointerKey fk = heapModel.getPointerKeyForArrayContents(key);
                    OrdinalSet<InstanceKey> fobjects = pa.getPointsToSet(fk);
                    for (InstanceKey fobj : fobjects) {
                        if (escapingInstanceKeys.contains(fobj)) continue;
                        newKeys.add(fobj);
                    }
                    continue;
                }
                Collection<IField> fields = type.getAllInstanceFields();
                for (IField f : fields) {
                    if (!f.getFieldTypeReference().isReferenceType()) continue;
                    PointerKey fk = heapModel.getPointerKeyForInstanceField(key, f);
                    OrdinalSet<InstanceKey> fobjects = pa.getPointsToSet(fk);
                    for (InstanceKey fobj : fobjects) {
                        if (escapingInstanceKeys.contains(fobj)) continue;
                        newKeys.add(fobj);
                    }
                }
            }
            escapingInstanceKeys.addAll(newKeys);
        } while (!newKeys.isEmpty());
        HashSet<IClass> escapingTypes = HashSetFactory.make();
        for (InstanceKey key : escapingInstanceKeys) {
            escapingTypes.add(key.getConcreteType());
        }
        return escapingTypes;
    }

    public static void main(String[] args) throws IOException, ClassHierarchyException, IllegalArgumentException, CancelException {
        String mainClassName = args[0];
        HashSet<JarFile> jars = HashSetFactory.make();
        int i = 1;
        while (i < args.length) {
            jars.add(new JarFile(args[i]));
            ++i;
        }
        Set<IClass> escapingTypes = new SimpleThreadEscapeAnalysis(jars, mainClassName).gatherThreadEscapingClasses();
        for (IClass cls : escapingTypes) {
            if (cls.isArrayClass()) continue;
            for (IField f : cls.getAllFields()) {
                if (f.isVolatile() || f.isFinal()) continue;
                System.err.println(f.getReference());
            }
        }
    }
}

