/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.analysis;

import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.config.AnalysisScopeReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public class GetLoadedFields {
    private static final ClassLoader MY_CLASSLOADER = GetLoadedFields.class.getClassLoader();

    public static void main(String[] args) throws IOException, ClassHierarchyException, InvalidClassFileException {
        AnalysisScope scope = AnalysisScopeReader.readJavaScope("primordial.txt", null, MY_CLASSLOADER);
        System.err.print("Build class hierarchy...");
        ClassHierarchy cha = ClassHierarchy.make(scope);
        System.err.println("Done");
        int nMethods = 0;
        int nFields = 0;
        HashMap<IMethod, Collection<FieldReference>> method2Field = HashMapFactory.make();
        for (IClass c : cha) {
            for (IMethod m : c.getDeclaredMethods()) {
                ++nMethods;
                Collection<FieldReference> fields = CodeScanner.getFieldsRead(m);
                nFields += fields.size();
                method2Field.put(m, fields);
            }
        }
        System.out.println(String.valueOf(nMethods) + " methods");
        System.out.println(String.valueOf((float)nFields / (float)nMethods) + " fields read per method");
    }
}

