/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.analysis;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.util.config.AnalysisScopeReader;
import java.io.IOException;

public class CountParameters {
    private static final ClassLoader MY_CLASSLOADER = CountParameters.class.getClassLoader();

    public static void main(String[] args) throws IOException, ClassHierarchyException {
        AnalysisScope scope = AnalysisScopeReader.readJavaScope("primordial.txt", null, MY_CLASSLOADER);
        System.err.print("Build class hierarchy...");
        ClassHierarchy cha = ClassHierarchy.make(scope);
        System.err.println("Done");
        int nClasses = 0;
        int nMethods = 0;
        int nParameters = 0;
        for (IClass c : cha) {
            ++nClasses;
            for (IMethod m : c.getDeclaredMethods()) {
                ++nMethods;
                nParameters += m.getNumberOfParameters();
            }
        }
        System.out.println(String.valueOf(nClasses) + " classes");
        System.out.println(String.valueOf(nMethods) + " methods");
        System.out.println(String.valueOf((float)nParameters / (float)nMethods) + " parameters per method");
    }
}

