/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.analysis;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.perf.Stopwatch;
import com.ibm.wala.util.ref.ReferenceCleanser;
import java.io.IOException;

public class ConstructAllIRs {
    private static final boolean PERIODIC_WIPE_SOFT_CACHES = true;
    private static final int WIPE_SOFT_CACHE_INTERVAL = 2500;
    private static int wipeCount = 0;

    public static void main(String[] args) throws IOException, ClassHierarchyException {
        String scopeFile = args[0];
        Stopwatch s = new Stopwatch();
        s.start();
        AnalysisScope scope = AnalysisScopeReader.readJavaScope(scopeFile, null, ConstructAllIRs.class.getClassLoader());
        System.out.print("building class hierarchy...");
        ClassHierarchy cha = ClassHierarchy.make(scope);
        System.out.println("done");
        ReferenceCleanser.registerClassHierarchy(cha);
        AnalysisCache cache = new AnalysisCache();
        ReferenceCleanser.registerCache(cache);
        AnalysisOptions options = new AnalysisOptions();
        System.out.print("building IRs...");
        for (IClass klass : cha) {
            for (IMethod method : klass.getDeclaredMethods()) {
                ConstructAllIRs.wipeSoftCaches();
                cache.getSSACache().findOrCreateIR(method, Everywhere.EVERYWHERE, options.getSSAOptions());
            }
        }
        System.out.println("done");
        s.stop();
        System.out.println("RUNNING TIME: " + s.getElapsedMillis());
    }

    private static void wipeSoftCaches() {
        if (++wipeCount >= 2500) {
            wipeCount = 0;
            ReferenceCleanser.clearSoftCaches();
        }
    }
}

