/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.escape;

import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.escape.IMethodEscapeAnalysis;
import com.ibm.wala.escape.INodeEscapeAnalysis;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TrivialMethodEscape
implements IMethodEscapeAnalysis,
INodeEscapeAnalysis {
    private final HeapGraph hg;
    private final CallGraph cg;

    public TrivialMethodEscape(CallGraph cg, HeapGraph hg) {
        this.hg = hg;
        this.cg = cg;
    }

    public boolean mayEscape(MethodReference allocMethod, int allocPC, MethodReference m) throws WalaException {
        if (allocMethod == null) {
            throw new IllegalArgumentException("null allocMethod");
        }
        Set<CGNode> nodes = this.cg.getNodes(m);
        if (nodes.size() == 0) {
            throw new WalaException("could not find call graph node for method " + m);
        }
        Set<CGNode> allocN = this.cg.getNodes(allocMethod);
        if (allocN.size() == 0) {
            throw new WalaException("could not find call graph node for allocation method " + allocMethod);
        }
        return this.mayEscape(allocN, allocPC, nodes);
    }

    public boolean mayEscape(CGNode allocNode, int allocPC, CGNode node) throws WalaException {
        return this.mayEscape(Collections.singleton(allocNode), allocPC, Collections.singleton(node));
    }

    private boolean mayEscape(Set allocN, int allocPC, Set nodes) throws WalaException {
        HashSet<InstanceKey> instances = HashSetFactory.make();
        for (CGNode n : allocN) {
            NewSiteReference site = TrivialMethodEscape.findAlloc(n, allocPC);
            InstanceKey ik = this.hg.getHeapModel().getInstanceKeyForAllocation(n, site);
            if (ik == null) {
                throw new WalaException("could not get instance key at site " + site + " in " + n);
            }
            instances.add(ik);
        }
        for (InstanceKey ik : instances) {
            Iterator<InstanceKey> it2 = this.hg.getPredNodes(ik);
            while (it2.hasNext()) {
                ReturnValueKey rk;
                PointerKey p = (PointerKey)((Object)it2.next());
                if (!(p instanceof AbstractLocalPointerKey)) {
                    return true;
                }
                if (!(p instanceof ReturnValueKey) || !nodes.contains((rk = (ReturnValueKey)p).getNode())) continue;
                return true;
            }
        }
        return false;
    }

    static NewSiteReference findAlloc(CGNode n, int allocPC) throws WalaException {
        if (n == null) {
            throw new IllegalArgumentException("null n");
        }
        Iterator<NewSiteReference> it = n.iterateNewSites();
        while (it.hasNext()) {
            NewSiteReference site = it.next();
            if (site.getProgramCounter() != allocPC) continue;
            return site;
        }
        throw new WalaException("Failed to find an allocation at pc " + allocPC + " in node " + n);
    }
}

