/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.flowgraph;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.DemandPointerFlowGraph;
import com.ibm.wala.demandpa.flowgraph.IFlowGraph;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.demandpa.util.MemoryAccess;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.ArrayContentsKey;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.NormalAllocationInNode;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.labeled.SlowSparseNumberedLabeledGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlowGraph
extends SlowSparseNumberedLabeledGraph<Object, IFlowLabel>
implements IFlowGraph {
    private static final IFlowLabel defaultLabel = new IFlowLabel(){

        public IFlowLabel bar() {
            return defaultLabel;
        }

        public boolean isBarred() {
            return false;
        }

        public void visit(IFlowLabel.IFlowLabelVisitor v, Object dst) {
        }
    };
    protected final Map<PointerKey, SSAInvokeInstruction> callDefs = HashMapFactory.make();
    protected final Map<PointerKey, Set<SSAInvokeInstruction>> callParams = HashMapFactory.make();
    protected final Map<PointerKey, CGNode> params = HashMapFactory.make();
    protected final Map<PointerKey, CGNode> returns = HashMapFactory.make();
    protected final MemoryAccessMap mam;
    protected final HeapModel heapModel;
    protected final IClassHierarchy cha;
    protected final CallGraph cg;

    public AbstractFlowGraph(MemoryAccessMap mam, HeapModel heapModel, IClassHierarchy cha, CallGraph cg) {
        super(defaultLabel);
        this.mam = mam;
        this.heapModel = heapModel;
        this.cha = cha;
        this.cg = cg;
    }

    @Override
    public void visitSuccs(Object node, IFlowLabel.IFlowLabelVisitor v) {
        Iterator succLabelIter = this.getSuccLabels(node);
        while (succLabelIter.hasNext()) {
            IFlowLabel label = (IFlowLabel)succLabelIter.next();
            Iterator<Object> succNodeIter = this.getSuccNodes(node, label);
            while (succNodeIter.hasNext()) {
                label.visit(v, succNodeIter.next());
            }
        }
    }

    @Override
    public void visitPreds(Object node, IFlowLabel.IFlowLabelVisitor v) {
        Iterator predLabelIter = this.getPredLabels(node);
        while (predLabelIter.hasNext()) {
            IFlowLabel label = (IFlowLabel)predLabelIter.next();
            Iterator<Object> predNodeIter = this.getPredNodes(node, label);
            while (predNodeIter.hasNext()) {
                label.visit(v, predNodeIter.next());
            }
        }
    }

    protected void addNodesForInvocations(CGNode node, IR ir) {
        Iterator<CallSiteReference> iter = ir.iterateCallSites();
        while (iter.hasNext()) {
            SSAAbstractInvokeInstruction[] calls;
            CallSiteReference site = iter.next();
            SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = calls = ir.getCalls(site);
            int n = calls.length;
            int n2 = 0;
            while (n2 < n) {
                SSAAbstractInvokeInstruction invokeInstr = sSAAbstractInvokeInstructionArray[n2];
                int i = 0;
                while (i < invokeInstr.getNumberOfUses()) {
                    PointerKey use = this.heapModel.getPointerKeyForLocal(node, invokeInstr.getUse(i));
                    this.addNode(use);
                    Set<SSAInvokeInstruction> s = MapUtil.findOrCreateSet(this.callParams, use);
                    s.add((SSAInvokeInstruction)invokeInstr);
                    ++i;
                }
                if (invokeInstr.hasDef()) {
                    PointerKey def = this.heapModel.getPointerKeyForLocal(node, invokeInstr.getDef());
                    this.addNode(def);
                    this.callDefs.put(def, (SSAInvokeInstruction)invokeInstr);
                }
                PointerKey exc = this.heapModel.getPointerKeyForLocal(node, invokeInstr.getException());
                this.addNode(exc);
                this.callDefs.put(exc, (SSAInvokeInstruction)invokeInstr);
                ++n2;
            }
        }
    }

    @Override
    public boolean isParam(LocalPointerKey pk) {
        return this.params.get(pk) != null;
    }

    @Override
    public Iterator<SSAInvokeInstruction> getInstrsPassingParam(LocalPointerKey pk) {
        Set<SSAInvokeInstruction> instrs = this.callParams.get(pk);
        if (instrs == null) {
            return EmptyIterator.instance();
        }
        return instrs.iterator();
    }

    @Override
    public SSAInvokeInstruction getInstrReturningTo(LocalPointerKey pk) {
        return this.callDefs.get(pk);
    }

    @Override
    public Iterator<? extends Object> getWritesToStaticField(StaticFieldKey sfk) throws IllegalArgumentException {
        if (sfk == null) {
            throw new IllegalArgumentException("sfk == null");
        }
        Collection<MemoryAccess> fieldWrites = this.mam.getStaticFieldWrites(sfk.getField());
        for (MemoryAccess a : fieldWrites) {
            this.addSubgraphForNode(a.getNode());
        }
        return this.getSuccNodes(sfk, AssignGlobalLabel.v());
    }

    @Override
    public Iterator<? extends Object> getReadsOfStaticField(StaticFieldKey sfk) throws IllegalArgumentException {
        if (sfk == null) {
            throw new IllegalArgumentException("sfk == null");
        }
        Collection<MemoryAccess> fieldReads = this.mam.getStaticFieldReads(sfk.getField());
        for (MemoryAccess a : fieldReads) {
            this.addSubgraphForNode(a.getNode());
        }
        return this.getPredNodes(sfk, AssignGlobalLabel.v());
    }

    @Override
    public Iterator<PointerKey> getWritesToInstanceField(PointerKey pk, IField f) {
        if (f == ArrayContents.v()) {
            return this.getArrayWrites(pk);
        }
        pk = AbstractFlowGraph.convertPointerKeyToHeapModel(pk, this.mam.getHeapModel());
        Collection<MemoryAccess> writes = this.mam.getFieldWrites(pk, f);
        for (MemoryAccess a : writes) {
            this.addSubgraphForNode(a.getNode());
        }
        ArrayList<PointerKey> written = new ArrayList<PointerKey>();
        for (MemoryAccess a : writes) {
            IR ir = a.getNode().getIR();
            SSAPutInstruction s = (SSAPutInstruction)ir.getInstructions()[a.getInstructionIndex()];
            if (s == null) continue;
            PointerKey r = this.heapModel.getPointerKeyForLocal(a.getNode(), s.getVal());
            written.add(r);
        }
        return written.iterator();
    }

    public static PointerKey convertPointerKeyToHeapModel(PointerKey pk, HeapModel h) {
        if (pk == null) {
            throw new IllegalArgumentException("null pk");
        }
        if (pk instanceof LocalPointerKey) {
            LocalPointerKey lpk = (LocalPointerKey)pk;
            return h.getPointerKeyForLocal(lpk.getNode(), lpk.getValueNumber());
        }
        if (pk instanceof ArrayContentsKey) {
            ArrayContentsKey ack = (ArrayContentsKey)pk;
            InstanceKey ik = ack.getInstanceKey();
            if (ik instanceof NormalAllocationInNode) {
                NormalAllocationInNode nain = (NormalAllocationInNode)ik;
                ik = h.getInstanceKeyForAllocation(nain.getNode(), nain.getSite());
            } else assert (false) : "need to handle " + ik.getClass();
            return h.getPointerKeyForArrayContents(ik);
        }
        if (pk instanceof ReturnValueKey) {
            ReturnValueKey rvk = (ReturnValueKey)pk;
            return h.getPointerKeyForReturnValue(rvk.getNode());
        }
        throw new UnsupportedOperationException("need to handle " + pk.getClass());
    }

    @Override
    public Iterator<PointerKey> getReadsOfInstanceField(PointerKey pk, IField f) {
        if (f == ArrayContents.v()) {
            return this.getArrayReads(pk);
        }
        pk = AbstractFlowGraph.convertPointerKeyToHeapModel(pk, this.mam.getHeapModel());
        Collection<MemoryAccess> reads = this.mam.getFieldReads(pk, f);
        for (MemoryAccess a : reads) {
            this.addSubgraphForNode(a.getNode());
        }
        ArrayList<PointerKey> readInto = new ArrayList<PointerKey>();
        for (MemoryAccess a : reads) {
            IR ir = a.getNode().getIR();
            SSAGetInstruction s = (SSAGetInstruction)ir.getInstructions()[a.getInstructionIndex()];
            if (s == null) continue;
            PointerKey r = this.heapModel.getPointerKeyForLocal(a.getNode(), s.getDef());
            readInto.add(r);
        }
        return readInto.iterator();
    }

    Iterator<PointerKey> getArrayWrites(PointerKey arrayRef) {
        arrayRef = AbstractFlowGraph.convertPointerKeyToHeapModel(arrayRef, this.mam.getHeapModel());
        Collection<MemoryAccess> arrayWrites = this.mam.getArrayWrites(arrayRef);
        for (MemoryAccess a : arrayWrites) {
            this.addSubgraphForNode(a.getNode());
        }
        ArrayList<PointerKey> written = new ArrayList<PointerKey>();
        for (MemoryAccess a : arrayWrites) {
            CGNode node = a.getNode();
            IR ir = node.getIR();
            SSAInstruction instruction = ir.getInstructions()[a.getInstructionIndex()];
            if (instruction == null) continue;
            if (instruction instanceof SSAArrayStoreInstruction) {
                SSAArrayStoreInstruction s = (SSAArrayStoreInstruction)instruction;
                PointerKey r = this.heapModel.getPointerKeyForLocal(node, s.getValue());
                written.add(r);
                continue;
            }
            if (instruction instanceof SSANewInstruction) {
                DemandPointerFlowGraph.NewMultiDimInfo multiDimInfo = DemandPointerFlowGraph.getInfoForNewMultiDim((SSANewInstruction)instruction, this.heapModel, node);
                for (Pair<PointerKey, PointerKey> arrStoreInstr : multiDimInfo.arrStoreInstrs) {
                    written.add((PointerKey)arrStoreInstr.snd);
                }
                continue;
            }
            Assertions.UNREACHABLE();
        }
        return written.iterator();
    }

    protected Iterator<PointerKey> getArrayReads(PointerKey arrayRef) {
        arrayRef = AbstractFlowGraph.convertPointerKeyToHeapModel(arrayRef, this.mam.getHeapModel());
        Collection<MemoryAccess> arrayReads = this.mam.getArrayReads(arrayRef);
        for (MemoryAccess a : arrayReads) {
            this.addSubgraphForNode(a.getNode());
        }
        ArrayList<PointerKey> read = new ArrayList<PointerKey>();
        for (MemoryAccess a : arrayReads) {
            IR ir = a.getNode().getIR();
            SSAArrayLoadInstruction s = (SSAArrayLoadInstruction)ir.getInstructions()[a.getInstructionIndex()];
            if (s == null) continue;
            PointerKey r = this.heapModel.getPointerKeyForLocal(a.getNode(), s.getDef());
            read.add(r);
        }
        return read.iterator();
    }

    protected void addNodePassthruExceptionConstraints(CGNode node, IR ir) {
        List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(ir, ir.getExitBlock());
        PointerKey exception = this.heapModel.getPointerKeyForExceptionalReturnValue(node);
        IClass c = node.getClassHierarchy().lookupClass(TypeReference.JavaLangThrowable);
        this.addExceptionDefConstraints(ir, node, peis, exception, Collections.singleton(c));
    }

    protected void addExceptionDefConstraints(IR ir, CGNode node, List<ProgramCounter> peis, PointerKey exceptionVar, Set<IClass> catchClasses) {
        for (ProgramCounter peiLoc : peis) {
            PointerKey e;
            SSAInstruction s;
            SSAInstruction pei = ir.getPEI(peiLoc);
            if (pei instanceof SSAAbstractInvokeInstruction) {
                s = (SSAAbstractInvokeInstruction)pei;
                e = this.heapModel.getPointerKeyForLocal(node, ((SSAAbstractInvokeInstruction)s).getException());
                this.addNode(exceptionVar);
                this.addNode(e);
                this.addEdge(exceptionVar, e, AssignLabel.noFilter());
            } else if (pei instanceof SSAAbstractThrowInstruction) {
                s = (SSAAbstractThrowInstruction)pei;
                e = this.heapModel.getPointerKeyForLocal(node, ((SSAAbstractThrowInstruction)s).getException());
                this.addNode(exceptionVar);
                this.addNode(e);
                this.addEdge(exceptionVar, e, AssignLabel.noFilter());
            }
            Collection<TypeReference> types = pei.getExceptionTypes();
            if (types == null) continue;
            for (TypeReference type : types) {
                InstanceKey ik;
                if (type == null || (ik = this.heapModel.getInstanceKeyForPEI(node, peiLoc, type)) == null) continue;
                if (!(ik instanceof ConcreteTypeKey)) assert (ik instanceof ConcreteTypeKey) : "uh oh: need to implement getCaughtException constraints for instance " + ik;
                ConcreteTypeKey ck = (ConcreteTypeKey)ik;
                IClass klass = ck.getType();
                if (!PropagationCallGraphBuilder.catches(catchClasses, klass, this.cha)) continue;
                this.addNode(exceptionVar);
                this.addNode(ik);
                this.addEdge(exceptionVar, ik, NewLabel.v());
            }
        }
    }

    protected void addNodeConstantConstraints(CGNode node, IR ir) {
        SymbolTable symbolTable = ir.getSymbolTable();
        int i = 1;
        while (i <= symbolTable.getMaxValueNumber()) {
            Object v;
            if (symbolTable.isConstant(i) && !((v = symbolTable.getConstantValue(i)) instanceof Number)) {
                InstanceKey ik;
                Object S = symbolTable.getConstantValue(i);
                TypeReference type = node.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(S);
                if (type != null && (ik = this.heapModel.getInstanceKeyForConstant(type, S)) != null) {
                    PointerKey pk = this.heapModel.getPointerKeyForLocal(node, i);
                    this.addNode(pk);
                    this.addNode(ik);
                    this.addEdge(pk, ik, NewLabel.v());
                }
            }
            ++i;
        }
    }
}

