/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.driver;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.demandpa.alg.DemandRefinementPointsTo;
import com.ibm.wala.demandpa.alg.IDemandPointerAnalysis;
import com.ibm.wala.demandpa.alg.SimpleDemandPointsTo;
import com.ibm.wala.demandpa.alg.refinepolicy.AlwaysRefineCGPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.AlwaysRefineFieldsPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.SinglePassRefinementPolicy;
import com.ibm.wala.demandpa.alg.statemachine.DummyStateMachine;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.demandpa.util.SimpleMemoryAccessMap;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.CancelException;
import java.io.IOException;
import java.util.Collection;

public class TestAgainstSimpleDriver {
    private static final boolean VERBOSE = false;

    public static void main(String[] args) throws IllegalArgumentException, CancelException, IOException {
        TestAgainstSimpleDriver.runAnalysisForTestCase("Ldemandpa/TestArraySetIter");
        System.err.println("computed all points-to sets successfully");
    }

    private static void runAnalysisForTestCase(String mainClass) throws IllegalArgumentException, CancelException, IOException {
        System.err.println("=======---------------=============");
        System.err.println("ANALYZING " + mainClass + "\n\n");
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = null;
        try {
            cha = ClassHierarchy.make(scope);
        }
        catch (ClassHierarchyException e) {
            e.printStackTrace();
        }
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, mainClass);
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraphBuilder rtaBuilder = Util.makeRTABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = rtaBuilder.makeCallGraph(options, null);
        SimpleMemoryAccessMap fam = new SimpleMemoryAccessMap(cg, rtaBuilder.getPointerAnalysis().getHeapModel(), false);
        IDemandPointerAnalysis dmp = TestAgainstSimpleDriver.makeDemandPointerAnalysis(options, cha, scope, cg, fam);
        SimpleDemandPointsTo simpleDmp = new SimpleDemandPointsTo(cg, dmp.getHeapModel(), fam, cha, options);
        CGNode main = cg.getEntrypointNodes().iterator().next();
        IR ir = main.getIR();
        TypeInference ti = TypeInference.make(ir, false);
        int i = 1;
        while (i <= ir.getSymbolTable().getMaxValueNumber()) {
            TypeAbstraction t = ti.getType(i);
            if (t != null) {
                Collection<InstanceKey> oldP;
                LocalPointerKey v = (LocalPointerKey)dmp.getHeapModel().getPointerKeyForLocal(main, i);
                Collection<InstanceKey> p = dmp.getPointsTo(v);
                if (!TestAgainstSimpleDriver.sameContents(p, oldP = simpleDmp.getPointsTo(v))) {
                    System.err.println("different result for " + v);
                    System.err.println("old " + oldP + "\n\nnew " + p);
                }
                TestAgainstSimpleDriver.printResult(v, p);
            }
            ++i;
        }
    }

    private static <T> boolean sameContents(Collection<T> c1, Collection<T> c2) {
        return c1.containsAll(c2) && c2.containsAll(c1);
    }

    private static void printResult(PointerKey pk, Collection<InstanceKey> result) {
    }

    private static IDemandPointerAnalysis makeDemandPointerAnalysis(AnalysisOptions options, ClassHierarchy cha, AnalysisScope scope, CallGraph cg, MemoryAccessMap fam) {
        SSAPropagationCallGraphBuilder builder = Util.makeVanillaZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        DemandRefinementPointsTo fullDemandPointsTo = DemandRefinementPointsTo.makeWithDefaultFlowGraph(cg, builder, fam, cha, options, new DummyStateMachine.Factory<IFlowLabel>());
        fullDemandPointsTo.setRefinementPolicyFactory(new SinglePassRefinementPolicy.Factory(new AlwaysRefineFieldsPolicy(), new AlwaysRefineCGPolicy()));
        return fullDemandPointsTo;
    }
}

