/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.driver;

import com.ibm.wala.analysis.reflection.InstanceKeyWithNode;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.demandpa.alg.DemandRefinementPointsTo;
import com.ibm.wala.demandpa.alg.IDemandPointerAnalysis;
import com.ibm.wala.demandpa.alg.statemachine.DummyStateMachine;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.util.CallGraphMapUtil;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.demandpa.util.SimpleMemoryAccessMap;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.OrdinalSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public class CompareToZeroOneCFADriver {
    public static void main(String[] args) {
    }

    private static void runUnitTestCase(String mainClass) throws IllegalArgumentException, CancelException, IOException {
        System.err.println("=======---------------=============");
        System.err.println("ANALYZING " + mainClass + "\n\n");
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        Object warnings = new Object();
        ClassHierarchy cha = null;
        try {
            cha = ClassHierarchy.make(scope);
        }
        catch (ClassHierarchyException e) {
            e.printStackTrace();
        }
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, mainClass);
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CompareToZeroOneCFADriver.doTests(scope, cha, options);
        System.err.println("ALL FINE");
    }

    private static void runApplication(String appJar) throws IllegalArgumentException, CancelException, IOException {
        System.err.println("=======---------------=============");
        System.err.println("ANALYZING " + appJar + "\n\n");
        AnalysisScope scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(appJar, new File(CallGraphTestUtil.REGRESSION_EXCLUSIONS));
        Object warnings = new Object();
        ClassHierarchy cha = null;
        try {
            cha = ClassHierarchy.make(scope);
        }
        catch (ClassHierarchyException e) {
            e.printStackTrace();
        }
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha);
        AnalysisOptions options = new AnalysisOptions(scope, entrypoints);
        CompareToZeroOneCFADriver.doTests(scope, cha, options);
        System.err.println("ALL FINE");
    }

    private static void doTests(AnalysisScope scope, ClassHierarchy cha, AnalysisOptions options) throws IllegalArgumentException, CancelException {
        SSAPropagationCallGraphBuilder builder = Util.makeVanillaZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph oldCG = builder.makeCallGraph(options, null);
        PointerAnalysis pa = builder.getPointerAnalysis();
        CallGraphBuilder rtaBuilder = Util.makeRTABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = rtaBuilder.makeCallGraph(options, null);
        SimpleMemoryAccessMap fam = new SimpleMemoryAccessMap(cg, rtaBuilder.getPointerAnalysis().getHeapModel(), false);
        IDemandPointerAnalysis dmp = CompareToZeroOneCFADriver.makeDemandPointerAnalysis(options, cha, scope, cg, fam);
        final class Helper {
            private final /* synthetic */ CallGraph val$cg;
            private final /* synthetic */ CallGraph val$oldCG;
            private final /* synthetic */ IDemandPointerAnalysis val$dmp;
            private final /* synthetic */ PointerAnalysis val$pa;

            Helper(CallGraph callGraph, CallGraph callGraph2, IDemandPointerAnalysis iDemandPointerAnalysis, PointerAnalysis pointerAnalysis) {
                this.val$cg = callGraph;
                this.val$oldCG = callGraph2;
                this.val$dmp = iDemandPointerAnalysis;
                this.val$pa = pointerAnalysis;
            }

            void checkPointersInMethod(CGNode node) {
                if (node.getMethod().getReference().toString().indexOf("clone()Ljava/lang/Object;") != -1) {
                    System.err.println("SKIPPING " + node);
                    return;
                }
                CGNode oldNode = CallGraphMapUtil.mapCGNode(node, this.val$cg, this.val$oldCG);
                if (oldNode == null) {
                    return;
                }
                System.err.println("METHOD " + node);
                IR ir = node.getIR();
                TypeInference ti = TypeInference.make(ir, false);
                int i = 1;
                while (i <= ir.getSymbolTable().getMaxValueNumber()) {
                    TypeAbstraction t = ti.getType(i);
                    if (t != null) {
                        HeapModel heapModel = this.val$dmp.getHeapModel();
                        LocalPointerKey pk = (LocalPointerKey)heapModel.getPointerKeyForLocal(node, i);
                        LocalPointerKey oldPk = (LocalPointerKey)CallGraphMapUtil.mapPointerKey(pk, this.val$cg, this.val$oldCG, heapModel);
                        Collection<InstanceKey> p2set = this.val$dmp.getPointsTo(pk);
                        OrdinalSet<InstanceKey> otherP2Set = this.val$pa.getPointsToSet(oldPk);
                        System.err.println("OLD POINTS-TO " + otherP2Set);
                        for (InstanceKey key : otherP2Set) {
                            InstanceKey newKey;
                            if (CompareToZeroOneCFADriver.knownBug(key) || p2set.contains(newKey = CallGraphMapUtil.mapInstKey(key, this.val$oldCG, this.val$cg, heapModel))) continue;
                            System.err.println("BADNESS");
                            System.err.println("pointer key " + pk);
                            System.err.println("missing " + newKey);
                            Assertions.UNREACHABLE();
                        }
                    }
                    ++i;
                }
            }
        }
        Helper h = new Helper(cg, oldCG, dmp, pa);
        for (CGNode node : cg) {
            h.checkPointersInMethod(node);
        }
    }

    private static boolean knownBug(InstanceKey key) {
        CGNode node;
        MethodReference methodRef;
        return key instanceof InstanceKeyWithNode && (methodRef = (node = ((InstanceKeyWithNode)key).getNode()).getMethod().getReference()).toString().equals("< Primordial, Ljava/lang/Object, clone()Ljava/lang/Object; >");
    }

    private static IDemandPointerAnalysis makeDemandPointerAnalysis(AnalysisOptions options, ClassHierarchy cha, AnalysisScope scope, CallGraph cg, MemoryAccessMap fam) {
        SSAPropagationCallGraphBuilder builder = Util.makeVanillaZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        DemandRefinementPointsTo fullDemandPointsTo = DemandRefinementPointsTo.makeWithDefaultFlowGraph(cg, builder, fam, cha, options, new DummyStateMachine.Factory<IFlowLabel>());
        return fullDemandPointsTo;
    }
}

