/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg.refinepolicy;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.demandpa.alg.refinepolicy.FieldRefinePolicy;
import com.ibm.wala.demandpa.alg.statemachine.StateMachine;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;

public class TunedFieldRefinementPolicy
implements FieldRefinePolicy {
    private static final boolean DEBUG = false;
    private final IClassHierarchy cha;
    private final Collection<IClass> typesToRefine = HashSetFactory.make();
    private IClass firstSkippedClass = null;

    public boolean nextPass() {
        if (this.firstSkippedClass != null) {
            this.typesToRefine.add(this.firstSkippedClass);
            this.firstSkippedClass = null;
            return true;
        }
        return false;
    }

    public boolean shouldRefine(IField field, PointerKey basePtr, PointerKey val, IFlowLabel label, StateMachine.State state) {
        if (field == null) {
            throw new IllegalArgumentException("null field");
        }
        if (field == ArrayContents.v()) {
            return true;
        }
        IClass classToCheck = this.removeInner(field.getDeclaringClass());
        if (this.superOfAnyEncountered(classToCheck)) {
            return true;
        }
        if (this.firstSkippedClass == null) {
            this.firstSkippedClass = classToCheck;
        }
        return false;
    }

    private boolean superOfAnyEncountered(IClass klass) {
        for (IClass toRefine : this.typesToRefine) {
            if (!this.cha.isAssignableFrom(klass, toRefine) && !this.cha.isAssignableFrom(toRefine, klass)) continue;
            return true;
        }
        return false;
    }

    private IClass removeInner(IClass klass) {
        ClassLoaderReference cl = klass.getClassLoader().getReference();
        String klassStr = klass.getName().toString();
        int dollarIndex = klassStr.indexOf(36);
        if (dollarIndex == -1) {
            return klass;
        }
        String topMostName = klassStr.substring(0, dollarIndex);
        IClass topMostClass = this.cha.lookupClass(TypeReference.findOrCreate(cl, topMostName));
        return topMostClass != null ? topMostClass : klass;
    }

    public TunedFieldRefinementPolicy(IClassHierarchy cha) {
        this.cha = cha;
    }
}

