/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg;

import com.ibm.wala.analysis.reflection.InstanceKeyWithNode;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.demandpa.alg.AbstractDemandPointsTo;
import com.ibm.wala.demandpa.alg.BudgetExceededException;
import com.ibm.wala.demandpa.alg.InstanceFieldKeyAndState;
import com.ibm.wala.demandpa.alg.InstanceKeyAndState;
import com.ibm.wala.demandpa.alg.PointerKeyAndState;
import com.ibm.wala.demandpa.alg.ThisFilteringHeapModel;
import com.ibm.wala.demandpa.alg.WithState;
import com.ibm.wala.demandpa.alg.refinepolicy.NeverRefineCGPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.NeverRefineFieldsPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.RefinementPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.RefinementPolicyFactory;
import com.ibm.wala.demandpa.alg.refinepolicy.SinglePassRefinementPolicy;
import com.ibm.wala.demandpa.alg.statemachine.StateMachine;
import com.ibm.wala.demandpa.alg.statemachine.StateMachineFactory;
import com.ibm.wala.demandpa.alg.statemachine.StatesMergedException;
import com.ibm.wala.demandpa.flowgraph.AbstractFlowGraph;
import com.ibm.wala.demandpa.flowgraph.AbstractFlowLabelVisitor;
import com.ibm.wala.demandpa.flowgraph.AssignBarLabel;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalBarLabel;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.DemandPointerFlowGraph;
import com.ibm.wala.demandpa.flowgraph.GetFieldLabel;
import com.ibm.wala.demandpa.flowgraph.IFlowGraph;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.flowgraph.IFlowLabelWithFilter;
import com.ibm.wala.demandpa.flowgraph.MatchBarLabel;
import com.ibm.wala.demandpa.flowgraph.MatchLabel;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.flowgraph.ParamBarLabel;
import com.ibm.wala.demandpa.flowgraph.ParamLabel;
import com.ibm.wala.demandpa.flowgraph.PutFieldLabel;
import com.ibm.wala.demandpa.flowgraph.ReturnBarLabel;
import com.ibm.wala.demandpa.flowgraph.ReturnLabel;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.demandpa.util.MemoryAccess;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.demandpa.util.PointerParamValueNumIterator;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ExceptionReturnValueKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.ArraySet;
import com.ibm.wala.util.collections.ArraySetMultiMap;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.HashSetMultiMap;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.collections.MultiMap;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.collections.Util;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemandRefinementPointsTo
extends AbstractDemandPointsTo {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_TOPLEVEL = false;
    private static final boolean PARANOID = false;
    private static final boolean MEASURE_MEMORY_USAGE = false;
    protected final IFlowGraph g;
    private StateMachineFactory<IFlowLabel> stateMachineFactory;
    private StateMachine<IFlowLabel> stateMachine;
    protected RefinementPolicy refinementPolicy;
    private RefinementPolicyFactory refinementPolicyFactory;
    public long lastQueryMemoryUse;

    public RefinementPolicy getRefinementPolicy() {
        return this.refinementPolicy;
    }

    private DemandRefinementPointsTo(CallGraph cg, ThisFilteringHeapModel model, MemoryAccessMap fam, IClassHierarchy cha, AnalysisOptions options, StateMachineFactory<IFlowLabel> stateMachineFactory, IFlowGraph flowGraph) {
        super(cg, model, fam, cha, options);
        this.stateMachineFactory = stateMachineFactory;
        this.g = flowGraph;
        this.refinementPolicyFactory = new SinglePassRefinementPolicy.Factory(new NeverRefineFieldsPolicy(), new NeverRefineCGPolicy());
        this.sanityCheckCG();
    }

    private void sanityCheckCG() {
    }

    protected void startNewQuery() {
        this.refinementPolicy = this.refinementPolicyFactory.make();
        this.stateMachine = this.stateMachineFactory.make();
    }

    public Pair<PointsToResult, Collection<InstanceKey>> getPointsTo(PointerKey pk, Predicate<InstanceKey> ikeyPred) throws IllegalArgumentException {
        Pair<PointsToResult, Collection<InstanceKeyAndState>> p = this.getPointsToWithStates(pk, ikeyPred);
        Collection p2SetWithStates = (Collection)p.snd;
        Collection finalP2Set = DemandRefinementPointsTo.removeStates(p2SetWithStates);
        return Pair.make((PointsToResult)((Object)p.fst), finalP2Set);
    }

    private Pair<PointsToResult, Collection<InstanceKeyAndState>> getPointsToWithStates(PointerKey pk, Predicate<InstanceKey> ikeyPred) {
        if (!(pk instanceof LocalPointerKey)) {
            throw new IllegalArgumentException("only locals for now");
        }
        LocalPointerKey queriedPk = (LocalPointerKey)pk;
        this.startNewQuery();
        Pair<PointsToResult, Collection<InstanceKeyAndState>> p = this.outerRefinementLoop(new PointerKeyAndState(queriedPk, this.stateMachine.getStartState()), ikeyPred);
        return p;
    }

    private static <T> Collection<T> removeStates(Collection<? extends WithState<T>> p2SetWithStates) {
        Iterator2Set finalP2Set = Iterator2Collection.toSet(new MapIterator(p2SetWithStates.iterator(), new Function<WithState<T>, T>(){

            @Override
            public T apply(WithState<T> object) {
                return object.getWrapped();
            }
        }));
        return finalP2Set;
    }

    public static DemandRefinementPointsTo makeWithDefaultFlowGraph(CallGraph cg, HeapModel model, MemoryAccessMap mam, IClassHierarchy cha, AnalysisOptions options, StateMachineFactory<IFlowLabel> stateMachineFactory) {
        ThisFilteringHeapModel thisFilteringHeapModel = new ThisFilteringHeapModel(model, cha);
        return new DemandRefinementPointsTo(cg, thisFilteringHeapModel, mam, cha, options, stateMachineFactory, new DemandPointerFlowGraph(cg, (HeapModel)thisFilteringHeapModel, mam, cha));
    }

    private Pair<PointsToResult, Collection<InstanceKeyAndState>> outerRefinementLoop(PointerKeyAndState queried, Predicate<InstanceKey> ikeyPred) {
        Collection<InstanceKeyAndState> lastP2Set = null;
        boolean succeeded = false;
        int numPasses = this.refinementPolicy.getNumPasses();
        int passNum = 0;
        while (passNum < numPasses) {
            this.setNumNodesTraversed(0);
            this.setTraversalBudget(this.refinementPolicy.getBudgetForPass(passNum));
            Collection<InstanceKeyAndState> curP2Set = null;
            PointsToComputer computer = null;
            boolean completedPassInBudget = false;
            try {
                while (true) {
                    try {
                        computer = new PointsToComputer(queried);
                        computer.compute();
                        curP2Set = computer.getComputedP2Set(queried);
                        completedPassInBudget = true;
                    }
                    catch (StatesMergedException statesMergedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (BudgetExceededException budgetExceededException) {
                // empty catch block
            }
            if (curP2Set != null) {
                if (lastP2Set == null) {
                    lastP2Set = curP2Set;
                } else if (lastP2Set.size() > curP2Set.size()) {
                    assert (DemandRefinementPointsTo.removeStates(lastP2Set).containsAll(DemandRefinementPointsTo.removeStates(curP2Set)));
                    lastP2Set = curP2Set;
                } else assert (DemandRefinementPointsTo.removeStates(curP2Set).containsAll(DemandRefinementPointsTo.removeStates(lastP2Set)));
                if (curP2Set.isEmpty() || this.passesPred(curP2Set, ikeyPred)) {
                    succeeded = true;
                    break;
                }
            }
            if (!this.refinementPolicy.nextPass()) break;
            ++passNum;
        }
        PointsToResult result = null;
        result = succeeded ? PointsToResult.SUCCESS : (passNum == numPasses ? PointsToResult.BUDGETEXCEEDED : (lastP2Set != null ? PointsToResult.NOMOREREFINE : PointsToResult.BUDGETEXCEEDED));
        return Pair.make(result, lastP2Set);
    }

    public PointsToResult pointsToPassesPred(PointerKey pk, Predicate<InstanceKey> ikeyPred, PointerAnalysis pa) throws IllegalArgumentException {
        if (!(pk instanceof LocalPointerKey)) {
            throw new IllegalArgumentException("only locals for now");
        }
        LocalPointerKey queriedPk = (LocalPointerKey)pk;
        boolean succeeded = false;
        this.startNewQuery();
        int numPasses = this.refinementPolicy.getNumPasses();
        int passNum = 0;
        boolean completedSomePass = false;
        while (passNum < numPasses) {
            this.setNumNodesTraversed(0);
            this.setTraversalBudget(this.refinementPolicy.getBudgetForPass(passNum));
            boolean completedPassInBudget = false;
            boolean passed = false;
            long initialMemory = 0L;
            try {
                while (true) {
                    try {
                        PointsToComputer computer = new PointsToComputer(queriedPk);
                        passed = this.doTopLevelTraversal(queriedPk, ikeyPred, computer, pa);
                        completedPassInBudget = true;
                        completedSomePass = true;
                    }
                    catch (StatesMergedException statesMergedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (BudgetExceededException budgetExceededException) {
                // empty catch block
            }
            if (completedPassInBudget && passed) {
                succeeded = true;
                break;
            }
            if (!this.refinementPolicy.nextPass()) break;
            ++passNum;
        }
        PointsToResult result = null;
        result = succeeded ? PointsToResult.SUCCESS : (passNum == numPasses ? PointsToResult.BUDGETEXCEEDED : (completedSomePass ? PointsToResult.NOMOREREFINE : PointsToResult.BUDGETEXCEEDED));
        return result;
    }

    private boolean passesPred(Collection<InstanceKeyAndState> curP2Set, final Predicate<InstanceKey> ikeyPred) {
        return Util.forAll(curP2Set, new Predicate<InstanceKeyAndState>(){

            @Override
            public boolean test(InstanceKeyAndState t) {
                return ikeyPred.test(t.getInstanceKey());
            }
        });
    }

    @Override
    public Collection<InstanceKey> getPointsTo(PointerKey pk) {
        return (Collection)this.getPointsTo((PointerKey)pk, Predicate.<InstanceKey>falsePred()).snd;
    }

    public Collection<InstanceKeyAndState> getPointsToWithStates(PointerKey pk) {
        return (Collection)this.getPointsToWithStates((PointerKey)pk, Predicate.<InstanceKey>falsePred()).snd;
    }

    public Pair<PointsToResult, Collection<PointerKey>> getFlowsTo(InstanceKey ik) {
        this.startNewQuery();
        return this.getFlowsToInternal(new InstanceKeyAndState(ik, this.stateMachine.getStartState()));
    }

    public Pair<PointsToResult, Collection<PointerKey>> getFlowsTo(InstanceKeyAndState ikAndState) {
        this.startNewQuery();
        return this.getFlowsToInternal(ikAndState);
    }

    private Pair<PointsToResult, Collection<PointerKey>> getFlowsToInternal(InstanceKeyAndState ikAndState) {
        InstanceKey ik = ikAndState.getInstanceKey();
        if (!(ik instanceof InstanceKeyWithNode)) assert (false) : "TODO: handle " + ik.getClass();
        Collection<PointerKeyAndState> lastFlowsToSet = null;
        boolean succeeded = false;
        int numPasses = this.refinementPolicy.getNumPasses();
        int passNum = 0;
        while (passNum < numPasses) {
            this.setNumNodesTraversed(0);
            this.setTraversalBudget(this.refinementPolicy.getBudgetForPass(passNum));
            Collection<PointerKeyAndState> curFlowsToSet = null;
            FlowsToComputer computer = null;
            try {
                while (true) {
                    try {
                        computer = new FlowsToComputer(ikAndState);
                        computer.compute();
                        curFlowsToSet = computer.getComputedFlowsToSet();
                    }
                    catch (StatesMergedException statesMergedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (BudgetExceededException budgetExceededException) {
                // empty catch block
            }
            if (curFlowsToSet != null) {
                if (lastFlowsToSet == null) {
                    lastFlowsToSet = curFlowsToSet;
                } else if (lastFlowsToSet.size() > curFlowsToSet.size()) {
                    assert (DemandRefinementPointsTo.removeStates(lastFlowsToSet).containsAll(DemandRefinementPointsTo.removeStates(curFlowsToSet)));
                    lastFlowsToSet = curFlowsToSet;
                }
                if (curFlowsToSet.isEmpty()) {
                    succeeded = true;
                    break;
                }
            }
            if (!this.refinementPolicy.nextPass()) break;
            ++passNum;
        }
        PointsToResult result = null;
        result = succeeded ? PointsToResult.SUCCESS : (passNum == numPasses ? PointsToResult.BUDGETEXCEEDED : (lastFlowsToSet != null ? PointsToResult.NOMOREREFINE : PointsToResult.BUDGETEXCEEDED));
        return Pair.make(result, lastFlowsToSet == null ? null : DemandRefinementPointsTo.removeStates(lastFlowsToSet));
    }

    private SSAAbstractInvokeInstruction[] getCallInstrs(CGNode node, CallSiteReference site) {
        return node.getIR().getCalls(site);
    }

    private boolean hasNullIR(CGNode node) {
        boolean ret = node.getMethod().isNative();
        assert (node.getIR() != null || ret);
        return ret;
    }

    private Object doTransition(StateMachine.State curState, IFlowLabel label, Function<StateMachine.State, Object> func) {
        StateMachine.State nextState = this.stateMachine.transition(curState, label);
        Object ret = null;
        if (nextState != StateMachine.ERROR) {
            ret = func.apply(nextState);
        }
        return ret;
    }

    public StateMachineFactory<IFlowLabel> getStateMachineFactory() {
        return this.stateMachineFactory;
    }

    public void setStateMachineFactory(StateMachineFactory<IFlowLabel> stateMachineFactory) {
        this.stateMachineFactory = stateMachineFactory;
    }

    public RefinementPolicyFactory getRefinementPolicyFactory() {
        return this.refinementPolicyFactory;
    }

    public void setRefinementPolicyFactory(RefinementPolicyFactory refinementPolicyFactory) {
        this.refinementPolicyFactory = refinementPolicyFactory;
    }

    private boolean doTopLevelTraversal(PointerKey pk, Predicate<InstanceKey> pred, PointsToComputer ptoComputer, PointerAnalysis pa) {
        HashSet visited = HashSetFactory.make();
        LinkedList worklist = new LinkedList();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Helper {
            private final MultiMap<CallerSiteContext, IMethod> callToOTFTargets = ArraySetMultiMap.make();
            private final /* synthetic */ Set val$visited;
            private final /* synthetic */ LinkedList val$worklist;
            private final /* synthetic */ PointsToComputer val$ptoComputer;

            Helper(Set set, LinkedList linkedList, PointsToComputer pointsToComputer) {
                this.val$visited = set;
                this.val$worklist = linkedList;
                this.val$ptoComputer = pointsToComputer;
            }

            void propagate(PointerKeyAndState pkAndState) {
                if (this.val$visited.add(pkAndState)) {
                    if (!$assertionsDisabled && !this.graphContainsNode(pkAndState.getPointerKey())) {
                        throw new AssertionError();
                    }
                    this.val$worklist.addLast(pkAndState);
                }
            }

            private boolean graphContainsNode(PointerKey pointerKey) {
                if (pointerKey instanceof LocalPointerKey) {
                    LocalPointerKey lpk = (LocalPointerKey)pointerKey;
                    return DemandRefinementPointsTo.this.g.hasSubgraphForNode(lpk.getNode());
                }
                return true;
            }

            private Collection<IMethod> getOTFTargets(CallerSiteContext callSiteAndCGNode, SSAAbstractInvokeInstruction[] callInstrs, StateMachine.State callerState) {
                CallSiteReference call = callSiteAndCGNode.getCallSite();
                CGNode caller = callSiteAndCGNode.getCaller();
                HashSet<IMethod> result = HashSetFactory.make();
                SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = callInstrs;
                int n = callInstrs.length;
                int n2 = 0;
                while (n2 < n) {
                    SSAAbstractInvokeInstruction callInstr = sSAAbstractInvokeInstructionArray[n2];
                    PointerKey thisArg = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(0));
                    PointerKeyAndState thisArgAndState = new PointerKeyAndState(thisArg, callerState);
                    OrdinalSet<InstanceKeyAndState> thisPToSet = this.getPToSetFromComputer(this.val$ptoComputer, thisArgAndState);
                    for (InstanceKeyAndState ikAndState : thisPToSet) {
                        InstanceKey ik = ikAndState.getInstanceKey();
                        IMethod targetMethod = DemandRefinementPointsTo.this.options.getMethodTargetSelector().getCalleeTarget(caller, call, ik.getConcreteType());
                        if (targetMethod == null) continue;
                        result.add(targetMethod);
                    }
                    ++n2;
                }
                return result;
            }

            public void handleTopLevelForwInterproc(PointerKeyAndState curPkAndState) {
                block9: {
                    SSAInvokeInstruction callInstr;
                    PointerKey curPk = curPkAndState.getPointerKey();
                    final StateMachine.State curState = curPkAndState.getState();
                    if (!(curPk instanceof LocalPointerKey)) break block9;
                    final LocalPointerKey localPk = (LocalPointerKey)curPk;
                    if (DemandRefinementPointsTo.this.g.isParam(localPk)) {
                        final CGNode callee = localPk.getNode();
                        final int paramPos = localPk.getValueNumber() - 1;
                        for (final CallerSiteContext callSiteAndCGNode : DemandRefinementPointsTo.this.g.getPotentialCallers(localPk)) {
                            final CGNode caller = callSiteAndCGNode.getCaller();
                            final CallSiteReference call = callSiteAndCGNode.getCallSite();
                            if (DemandRefinementPointsTo.this.hasNullIR(caller)) continue;
                            final ParamLabel paramLabel = ParamLabel.make(callSiteAndCGNode);
                            DemandRefinementPointsTo.this.doTransition(curPkAndState.getState(), paramLabel, new Function<StateMachine.State, Object>(){

                                private void propagateToCallee() {
                                    ((Helper)this).DemandRefinementPointsTo.this.g.addSubgraphForNode(caller);
                                    SSAAbstractInvokeInstruction[] callInstrs = DemandRefinementPointsTo.this.getCallInstrs(caller, call);
                                    int i = 0;
                                    while (i < callInstrs.length) {
                                        SSAAbstractInvokeInstruction callInstr = callInstrs[i];
                                        final PointerKey actualPk = ((Helper)this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(paramPos));
                                        if (!$assertionsDisabled && !((Helper)this).DemandRefinementPointsTo.this.g.containsNode(actualPk)) {
                                            throw new AssertionError();
                                        }
                                        if (!$assertionsDisabled && !((Helper)this).DemandRefinementPointsTo.this.g.containsNode(localPk)) {
                                            throw new AssertionError();
                                        }
                                        DemandRefinementPointsTo.this.doTransition(curState, paramLabel, new Function<StateMachine.State, Object>(){

                                            @Override
                                            public Object apply(StateMachine.State nextState) {
                                                this.propagate(new PointerKeyAndState(actualPk, nextState));
                                                return null;
                                            }
                                        });
                                        ++i;
                                    }
                                }

                                @Override
                                public Object apply(StateMachine.State callerState) {
                                    SSAAbstractInvokeInstruction[] callInstrs = DemandRefinementPointsTo.this.getCallInstrs(caller, call);
                                    SSAAbstractInvokeInstruction callInstr = callInstrs[0];
                                    PointerKey actualPk = ((Helper)this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(paramPos));
                                    Set<CGNode> possibleTargets = ((Helper)this).DemandRefinementPointsTo.this.g.getPossibleTargets(caller, call, (LocalPointerKey)actualPk);
                                    if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(callSiteAndCGNode, possibleTargets)) {
                                        this.propagateToCallee();
                                    } else {
                                        Collection otfTargets = this.getOTFTargets(callSiteAndCGNode, callInstrs, callerState);
                                        if (otfTargets.contains(callee.getMethod())) {
                                            this.propagateToCallee();
                                        }
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                    if ((callInstr = DemandRefinementPointsTo.this.g.getInstrReturningTo(localPk)) != null) {
                        Set<CGNode> possibleCallees;
                        CGNode caller = localPk.getNode();
                        boolean isExceptional = localPk.getValueNumber() == callInstr.getException();
                        CallSiteReference callSiteRef = callInstr.getCallSite();
                        CallerSiteContext callSiteAndCGNode = new CallerSiteContext(caller, callSiteRef);
                        if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(callSiteAndCGNode, possibleCallees = DemandRefinementPointsTo.this.g.getPossibleTargets(caller, callSiteRef, localPk))) {
                            for (CGNode callee : possibleCallees) {
                                PointerKey retVal;
                                if (DemandRefinementPointsTo.this.hasNullIR(callee)) continue;
                                DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                                PointerKey pointerKey = retVal = isExceptional ? DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(callee) : DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(callee);
                                if (!$assertionsDisabled && !DemandRefinementPointsTo.this.g.containsNode(retVal)) {
                                    throw new AssertionError();
                                }
                                DemandRefinementPointsTo.this.doTransition(curState, ReturnLabel.make(callSiteAndCGNode), new Function<StateMachine.State, Object>(){

                                    @Override
                                    public Object apply(StateMachine.State nextState) {
                                        this.propagate(new PointerKeyAndState(retVal, nextState));
                                        return null;
                                    }
                                });
                            }
                        } else {
                            Collection<IMethod> otfTargets = this.getOTFTargets(callSiteAndCGNode, DemandRefinementPointsTo.this.getCallInstrs(caller, callSiteAndCGNode.getCallSite()), curPkAndState.getState());
                            for (CGNode callee : possibleCallees) {
                                PointerKey retVal;
                                if (!otfTargets.contains(callee.getMethod()) || DemandRefinementPointsTo.this.hasNullIR(callee)) continue;
                                DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                                PointerKey pointerKey = retVal = isExceptional ? DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(callee) : DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(callee);
                                if (!$assertionsDisabled && !DemandRefinementPointsTo.this.g.containsNode(retVal)) {
                                    throw new AssertionError();
                                }
                                DemandRefinementPointsTo.this.doTransition(curState, ReturnLabel.make(callSiteAndCGNode), new Function<StateMachine.State, Object>(){

                                    @Override
                                    public Object apply(StateMachine.State nextState) {
                                        this.propagate(new PointerKeyAndState(retVal, nextState));
                                        return null;
                                    }
                                });
                            }
                        }
                    }
                }
            }

            private OrdinalSet<InstanceKeyAndState> getPToSetFromComputer(PointsToComputer ptoComputer, PointerKeyAndState pointerKeyAndState) {
                if (pointerKeyAndState.getPointerKey() instanceof LocalPointerKey) {
                    LocalPointerKey lpk = (LocalPointerKey)pointerKeyAndState.getPointerKey();
                    DemandRefinementPointsTo.this.g.addSubgraphForNode(lpk.getNode());
                }
                ptoComputer.addToInitWorklist(pointerKeyAndState);
                ptoComputer.worklistLoop();
                MutableIntSet intP2Set = ptoComputer.pkToP2Set.get(pointerKeyAndState);
                if (intP2Set == null) {
                    return OrdinalSet.empty();
                }
                return ptoComputer.makeOrdinalSet(intP2Set);
            }

            private void computeFlowsTo(PointsToComputer ptoComputer, OrdinalSet<InstanceKeyAndState> basePToSet) {
                for (InstanceKeyAndState ikAndState : basePToSet) {
                    ptoComputer.addPredsOfIKeyAndStateToTrackedPointsTo(ikAndState);
                }
                if (!$assertionsDisabled && !ptoComputer.initWorklist.isEmpty()) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !ptoComputer.pointsToWorklist.isEmpty()) {
                    throw new AssertionError();
                }
                ptoComputer.worklistLoop();
            }

            private Collection<StateMachine.State> getFlowedToStates(PointsToComputer ptoComputer, OrdinalSet<InstanceKeyAndState> basePToSet, PointerKey putfieldBase) {
                HashSet<StateMachine.State> result = HashSetFactory.make();
                Set trackedStates = ptoComputer.trackedQueried.get(putfieldBase);
                for (StateMachine.State trackedState : trackedStates) {
                    PointerKeyAndState pkAndState = new PointerKeyAndState(putfieldBase, trackedState);
                    if (!ptoComputer.makeOrdinalSet(ptoComputer.pkToTrackedSet.get(pkAndState)).containsAny(basePToSet)) continue;
                    result.add(trackedState);
                }
                return result;
            }
        }
        Helper h = new Helper(visited, worklist, ptoComputer);
        PointerKeyAndState initPkAndState = new PointerKeyAndState(pk, this.stateMachine.getStartState());
        if (pk instanceof LocalPointerKey) {
            this.g.addSubgraphForNode(((LocalPointerKey)pk).getNode());
        }
        h.propagate(initPkAndState);
        while (!worklist.isEmpty()) {
            this.incrementNumNodesTraversed();
            PointerKeyAndState curPkAndState = (PointerKeyAndState)worklist.removeFirst();
            PointerKey curPk = curPkAndState.getPointerKey();
            StateMachine.State curState = curPkAndState.getState();
            if (this.predHoldsForPk(curPk, pred, pa)) continue;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class MyFlowLabelVisitor
            extends AbstractFlowLabelVisitor {
                boolean foundBadInstanceKey;
                private final /* synthetic */ PointerKey val$curPk;
                private final /* synthetic */ StateMachine.State val$curState;
                private final /* synthetic */ Helper val$h;
                private final /* synthetic */ PointsToComputer val$ptoComputer;
                private final /* synthetic */ Predicate val$pred;

                MyFlowLabelVisitor(PointerKey pointerKey, StateMachine.State state, Helper helper, PointsToComputer pointsToComputer, Predicate predicate) {
                    this.val$curPk = pointerKey;
                    this.val$curState = state;
                    this.val$h = helper;
                    this.val$ptoComputer = pointsToComputer;
                    this.val$pred = predicate;
                }

                @Override
                public void visitNew(NewLabel label, Object dst) {
                    final InstanceKey ik = (InstanceKey)dst;
                    DemandRefinementPointsTo.this.doTransition(this.val$curState, label, new Function<StateMachine.State, Object>(){

                        @Override
                        public Object apply(StateMachine.State newState) {
                            if (!val$pred.test(ik)) {
                                foundBadInstanceKey = true;
                            }
                            return null;
                        }
                    });
                }

                @Override
                public void visitGetField(GetFieldLabel label, Object dst) {
                    PointerKey loadBase;
                    IField field = label.getField();
                    if (DemandRefinementPointsTo.this.refineFieldAccesses(field, loadBase = (PointerKey)dst, this.val$curPk, label, this.val$curState)) {
                        OrdinalSet basePToSet = this.val$h.getPToSetFromComputer(this.val$ptoComputer, new PointerKeyAndState(loadBase, this.val$curState));
                        this.val$h.computeFlowsTo(this.val$ptoComputer, basePToSet);
                        for (MemoryAccess fieldWrite : this.getWrites(field, loadBase)) {
                            Collection<Pair<PointerKey, PointerKey>> baseAndStoredPairs = this.getBaseAndStored(fieldWrite, field);
                            if (baseAndStoredPairs == null) continue;
                            for (Pair<PointerKey, PointerKey> p : baseAndStoredPairs) {
                                PointerKey base = (PointerKey)p.fst;
                                PointerKey stored = (PointerKey)p.snd;
                                Collection reachedFlowStates = this.val$h.getFlowedToStates(this.val$ptoComputer, basePToSet, base);
                                for (StateMachine.State nextState : reachedFlowStates) {
                                    this.val$h.propagate(new PointerKeyAndState(stored, nextState));
                                }
                            }
                        }
                    } else {
                        Iterator<PointerKey> writesToInstanceField = DemandRefinementPointsTo.this.g.getWritesToInstanceField(loadBase, field);
                        while (writesToInstanceField.hasNext()) {
                            final PointerKey writtenPk = writesToInstanceField.next();
                            DemandRefinementPointsTo.this.doTransition(this.val$curState, MatchLabel.v(), new Function<StateMachine.State, Object>(){
                                {
                                }

                                @Override
                                public Object apply(StateMachine.State nextState) {
                                    val$h.propagate(new PointerKeyAndState(writtenPk, nextState));
                                    return null;
                                }
                            });
                        }
                    }
                }

                private Collection<Pair<PointerKey, PointerKey>> getBaseAndStored(MemoryAccess fieldWrite, IField field) {
                    CGNode node = fieldWrite.getNode();
                    if (!DemandRefinementPointsTo.this.g.hasSubgraphForNode(node)) {
                        return null;
                    }
                    IR ir = node.getIR();
                    PointerKey base = null;
                    PointerKey stored = null;
                    if (field == ArrayContents.v()) {
                        SSAInstruction instruction = ir.getInstructions()[fieldWrite.getInstructionIndex()];
                        if (instruction == null) {
                            return null;
                        }
                        if (instruction instanceof SSANewInstruction) {
                            return DemandPointerFlowGraph.getInfoForNewMultiDim((SSANewInstruction)((SSANewInstruction)instruction), (HeapModel)DemandRefinementPointsTo.this.heapModel, (CGNode)fieldWrite.getNode()).arrStoreInstrs;
                        }
                        SSAArrayStoreInstruction s = (SSAArrayStoreInstruction)instruction;
                        base = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(fieldWrite.getNode(), s.getArrayRef());
                        stored = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(fieldWrite.getNode(), s.getValue());
                    } else {
                        SSAPutInstruction s = (SSAPutInstruction)ir.getInstructions()[fieldWrite.getInstructionIndex()];
                        if (s == null) {
                            return null;
                        }
                        base = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(fieldWrite.getNode(), s.getRef());
                        stored = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(fieldWrite.getNode(), s.getVal());
                    }
                    return Collections.singleton(Pair.make(base, stored));
                }

                private Collection<MemoryAccess> getWrites(IField field, PointerKey loadBase) {
                    PointerKey convertedBase = DemandRefinementPointsTo.this.convertToHeapModel(loadBase, DemandRefinementPointsTo.this.mam.getHeapModel());
                    if (field == ArrayContents.v()) {
                        return DemandRefinementPointsTo.this.mam.getArrayWrites(loadBase);
                    }
                    return DemandRefinementPointsTo.this.mam.getFieldWrites(convertedBase, field);
                }

                @Override
                public void visitAssignGlobal(AssignGlobalLabel label, Object dst) {
                    Iterator<? extends Object> writesToStaticField = DemandRefinementPointsTo.this.g.getWritesToStaticField((StaticFieldKey)dst);
                    while (writesToStaticField.hasNext()) {
                        final PointerKey writtenPk = (PointerKey)writesToStaticField.next();
                        DemandRefinementPointsTo.this.doTransition(this.val$curState, label, new Function<StateMachine.State, Object>(){
                            {
                            }

                            @Override
                            public Object apply(StateMachine.State nextState) {
                                val$h.propagate(new PointerKeyAndState(writtenPk, nextState));
                                return null;
                            }
                        });
                    }
                }

                @Override
                public void visitAssign(AssignLabel label, Object dst) {
                    final PointerKey succPk = (PointerKey)dst;
                    DemandRefinementPointsTo.this.doTransition(this.val$curState, label, new Function<StateMachine.State, Object>(){
                        {
                        }

                        @Override
                        public Object apply(StateMachine.State nextState) {
                            val$h.propagate(new PointerKeyAndState(succPk, nextState));
                            return null;
                        }
                    });
                }
            }
            MyFlowLabelVisitor v = new MyFlowLabelVisitor(curPk, curState, h, ptoComputer, pred);
            this.g.visitSuccs(curPk, v);
            if (v.foundBadInstanceKey) {
                return false;
            }
            h.handleTopLevelForwInterproc(curPkAndState);
        }
        return true;
    }

    private boolean predHoldsForPk(PointerKey curPk, Predicate<InstanceKey> pred, PointerAnalysis pa) {
        PointerKey curPkForPAHeapModel = this.convertToHeapModel(curPk, pa.getHeapModel());
        OrdinalSet<InstanceKey> pointsToSet = pa.getPointsToSet(curPkForPAHeapModel);
        for (InstanceKey ik : pointsToSet) {
            if (pred.test(ik)) continue;
            return false;
        }
        return true;
    }

    private PointerKey convertToHeapModel(PointerKey curPk, HeapModel heapModel) {
        return AbstractFlowGraph.convertPointerKeyToHeapModel(curPk, heapModel);
    }

    private boolean refineFieldAccesses(IField field, PointerKey basePtr, PointerKey val, IFlowLabel label, StateMachine.State state) {
        boolean shouldRefine = this.refinementPolicy.getFieldRefinePolicy().shouldRefine(field, basePtr, val, label, state);
        return shouldRefine;
    }

    private boolean noOnTheFlyNeeded(CallerSiteContext call, Set<CGNode> possibleTargets) {
        if (!this.refinementPolicy.getCallGraphRefinePolicy().shouldRefine(call)) {
            return true;
        }
        HashSet<IMethod> methodTargets = new HashSet<IMethod>();
        for (CGNode node : possibleTargets) {
            methodTargets.add(node.getMethod());
        }
        return methodTargets.size() <= 1;
    }

    private static abstract class CopyHandler {
        private CopyHandler() {
        }

        abstract void handle(PointerKeyAndState var1, PointerKey var2, IFlowLabel var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FlowsToComputer
    extends PointsToComputer {
        private final InstanceKeyAndState queriedIkAndState;
        private final int queriedIkAndStateNum;
        private final Collection<PointerKeyAndState> theFlowsToSet;

        public FlowsToComputer(InstanceKeyAndState ikAndState) {
            this.theFlowsToSet = HashSetFactory.make();
            this.queriedIkAndState = ikAndState;
            this.queriedIkAndStateNum = this.ikAndStates.add(this.queriedIkAndState);
        }

        @Override
        protected void compute() {
            InstanceKey ik = this.queriedIkAndState.getInstanceKey();
            DemandRefinementPointsTo.this.g.addSubgraphForNode(((InstanceKeyWithNode)ik).getNode());
            for (InstanceKey pred : Iterator2Iterable.make(DemandRefinementPointsTo.this.g.getPredNodes(ik, NewLabel.v()))) {
                PointerKey predPk = (PointerKey)((Object)pred);
                PointerKeyAndState predPkAndState = new PointerKeyAndState(predPk, this.queriedIkAndState.getState());
                this.theFlowsToSet.add(predPkAndState);
                this.findOrCreate(this.pkToTrackedSet, predPkAndState).add(this.queriedIkAndStateNum);
                this.addToTrackedPToWorklist(predPkAndState);
            }
            this.worklistLoop();
        }

        public Collection<PointerKeyAndState> getComputedFlowsToSet() {
            return this.theFlowsToSet;
        }

        @Override
        protected boolean handleTrackedPred(MutableIntSet curTrackedSet, PointerKeyAndState predPkAndState, IFlowLabel label) {
            boolean result = super.handleTrackedPred(curTrackedSet, predPkAndState, label);
            if (result && this.find(this.pkToTrackedSet, predPkAndState).contains(this.queriedIkAndStateNum)) {
                this.theFlowsToSet.add(predPkAndState);
            }
            return result;
        }
    }

    private static final class LoadEdge {
        final PointerKeyAndState base;
        final IField field;
        final PointerKeyAndState val;

        public String toString() {
            return this.val + " := " + this.base + ", field " + this.field;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.val.hashCode();
            result = 31 * result + this.field.hashCode();
            result = 31 * result + this.base.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LoadEdge other = (LoadEdge)obj;
            if (!this.val.equals(other.val)) {
                return false;
            }
            if (!this.field.equals(other.field)) {
                return false;
            }
            return this.base.equals(other.base);
        }

        public LoadEdge(PointerKeyAndState base, IField field, PointerKeyAndState val) {
            this.base = base;
            this.field = field;
            this.val = val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PointsToComputer {
        protected final PointerKeyAndState queriedPkAndState;
        private final MultiMap<PointerKey, StateMachine.State> pointsToQueried = HashSetMultiMap.make();
        private final MultiMap<PointerKey, StateMachine.State> trackedQueried = HashSetMultiMap.make();
        private final Collection<PointerKeyAndState> initWorklist = new LinkedHashSet<PointerKeyAndState>();
        private final Collection<PointerKeyAndState> pointsToWorklist = new LinkedHashSet<PointerKeyAndState>();
        private final Collection<PointerKeyAndState> trackedPointsToWorklist = new LinkedHashSet<PointerKeyAndState>();
        private final MultiMap<PointerKeyAndState, CallerSiteContext> pkToOTFCalls = HashSetMultiMap.make();
        private final MultiMap<CallerSiteContext, IMethod> callToOTFTargets = ArraySetMultiMap.make();
        private final MultiMap<InstanceKeyAndState, IField> forwInstKeyToFields = HashSetMultiMap.make();
        private final MultiMap<InstanceKeyAndState, IField> backInstKeyToFields = HashSetMultiMap.make();
        protected final Map<PointerKeyAndState, MutableIntSet> pkToP2Set = HashMapFactory.make();
        protected final Map<PointerKeyAndState, MutableIntSet> pkToTrackedSet = HashMapFactory.make();
        private final Map<InstanceFieldKeyAndState, MutableIntSet> instFieldKeyToP2Set = HashMapFactory.make();
        private final Map<InstanceFieldKeyAndState, MutableIntSet> instFieldKeyToTrackedSet = HashMapFactory.make();
        protected final OrdinalSetMapping<InstanceKeyAndState> ikAndStates = MutableMapping.make();
        private final MutableIntSetFactory intSetFactory = new MutableSparseIntSetFactory();
        private final HashSet<StoreEdge> encounteredStores = HashSetFactory.make();
        private final HashSet<LoadEdge> encounteredLoads = HashSetFactory.make();
        private final MutableIntSet emptySet = this.intSetFactory.make();

        protected PointsToComputer() {
            this.queriedPkAndState = null;
        }

        protected PointsToComputer(PointerKey pk) {
            this.queriedPkAndState = new PointerKeyAndState(pk, DemandRefinementPointsTo.this.stateMachine.getStartState());
        }

        protected PointsToComputer(PointerKeyAndState pkAndState) {
            this.queriedPkAndState = pkAndState;
        }

        private OrdinalSet<InstanceKeyAndState> makeOrdinalSet(IntSet intSet) {
            return new OrdinalSet<InstanceKeyAndState>((IntSet)this.intSetFactory.makeCopy(intSet), this.ikAndStates);
        }

        public Collection<InstanceKeyAndState> getComputedP2Set(PointerKeyAndState queried) {
            return Iterator2Collection.toSet(this.makeOrdinalSet(this.find(this.pkToP2Set, queried)).iterator());
        }

        protected boolean addAllToP2Set(Map<PointerKeyAndState, MutableIntSet> p2setMap, PointerKeyAndState pkAndState, IntSet vals, IFlowLabel label) {
            FilteredPointerKey.TypeFilter typeFilter;
            PointerKey pk = pkAndState.getPointerKey();
            if (pk instanceof FilteredPointerKey) {
                typeFilter = ((FilteredPointerKey)pk).getTypeFilter();
                vals = this.updateValsForFilter(vals, typeFilter);
            }
            if (label instanceof IFlowLabelWithFilter && (typeFilter = ((IFlowLabelWithFilter)label).getFilter()) != null) {
                vals = this.updateValsForFilter(vals, typeFilter);
            }
            boolean added = this.findOrCreate(p2setMap, pkAndState).addAll(vals);
            return added;
        }

        private IntSet updateValsForFilter(IntSet vals, final FilteredPointerKey.TypeFilter typeFilter) {
            if (typeFilter instanceof FilteredPointerKey.SingleClassFilter) {
                final IClass concreteType = ((FilteredPointerKey.SingleClassFilter)typeFilter).getConcreteType();
                Object tmp = this.intSetFactory.make();
                vals.foreach(new IntSetAction((MutableIntSet)tmp){
                    private final /* synthetic */ MutableIntSet val$tmp;
                    {
                        this.val$tmp = mutableIntSet;
                    }

                    public void act(int x) {
                        InstanceKeyAndState ikAndState = PointsToComputer.this.ikAndStates.getMappedObject(x);
                        if (((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.cha.isAssignableFrom(concreteType, ikAndState.getInstanceKey().getConcreteType())) {
                            this.val$tmp.add(x);
                        }
                    }
                });
                vals = tmp;
            } else if (typeFilter instanceof FilteredPointerKey.MultipleClassesFilter) {
                Object tmp = this.intSetFactory.make();
                vals.foreach(new IntSetAction((MutableIntSet)tmp){
                    private final /* synthetic */ MutableIntSet val$tmp;
                    {
                        this.val$tmp = mutableIntSet;
                    }

                    public void act(int x) {
                        InstanceKeyAndState ikAndState = PointsToComputer.this.ikAndStates.getMappedObject(x);
                        IClass[] iClassArray = ((FilteredPointerKey.MultipleClassesFilter)typeFilter).getConcreteTypes();
                        int n = iClassArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IClass t = iClassArray[n2];
                            if (((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.cha.isAssignableFrom(t, ikAndState.getInstanceKey().getConcreteType())) {
                                this.val$tmp.add(x);
                            }
                            ++n2;
                        }
                    }
                });
                vals = tmp;
            } else if (typeFilter instanceof FilteredPointerKey.SingleInstanceFilter) {
                final InstanceKey theOnlyInstanceKey = ((FilteredPointerKey.SingleInstanceFilter)typeFilter).getInstance();
                Object tmp = this.intSetFactory.make();
                vals.foreach(new IntSetAction((MutableIntSet)tmp){
                    private final /* synthetic */ MutableIntSet val$tmp;
                    {
                        this.val$tmp = mutableIntSet;
                    }

                    public void act(int x) {
                        InstanceKeyAndState ikAndState = PointsToComputer.this.ikAndStates.getMappedObject(x);
                        if (ikAndState.getInstanceKey().equals(theOnlyInstanceKey)) {
                            this.val$tmp.add(x);
                        }
                    }
                });
                vals = tmp;
            } else {
                Assertions.UNREACHABLE();
            }
            return vals;
        }

        protected void compute() {
            CGNode node = ((LocalPointerKey)this.queriedPkAndState.getPointerKey()).getNode();
            if (DemandRefinementPointsTo.this.hasNullIR(node)) {
                return;
            }
            DemandRefinementPointsTo.this.g.addSubgraphForNode(node);
            this.addToInitWorklist(this.queriedPkAndState);
            this.worklistLoop();
        }

        protected void worklistLoop() {
            while (true) {
                if (!(this.initWorklist.isEmpty() && this.pointsToWorklist.isEmpty() && this.trackedPointsToWorklist.isEmpty())) {
                    this.handleInitWorklist();
                    this.handlePointsToWorklist();
                    this.handleTrackedPointsToWorklist();
                    continue;
                }
                this.makePassOverFieldStmts();
                if (this.initWorklist.isEmpty() && this.pointsToWorklist.isEmpty() && this.trackedPointsToWorklist.isEmpty()) break;
            }
        }

        void handleCopy(final PointerKeyAndState curPkAndState, final PointerKey succPk, final IFlowLabel label) {
            assert (!label.isBarred());
            StateMachine.State curState = curPkAndState.getState();
            DemandRefinementPointsTo.this.doTransition(curState, label, new Function<StateMachine.State, Object>(){

                @Override
                public Object apply(StateMachine.State nextState) {
                    PointerKeyAndState succPkAndState = new PointerKeyAndState(succPk, nextState);
                    PointsToComputer.this.handleCopy(curPkAndState, succPkAndState, label);
                    return null;
                }
            });
        }

        void handleCopy(PointerKeyAndState curPkAndState, PointerKeyAndState succPkAndState, IFlowLabel label) {
            if (!this.addToInitWorklist(succPkAndState) && this.addAllToP2Set(this.pkToP2Set, curPkAndState, this.find(this.pkToP2Set, succPkAndState), label)) {
                this.addToPToWorklist(curPkAndState);
            }
        }

        void handleAllCopies(PointerKeyAndState curPk, Iterator<? extends Object> succNodes, IFlowLabel label) {
            while (succNodes.hasNext()) {
                this.handleCopy(curPk, (PointerKey)succNodes.next(), label);
            }
        }

        protected Collection<PointerKeyAndState> matchingPToQueried(PointerKeyAndState curPkAndState, PointerKey predPk, IFlowLabel label) {
            ArraySet<PointerKeyAndState> ret = ArraySet.make();
            assert (label.isBarred());
            IFlowLabel unbarredLabel = label.bar();
            StateMachine.State curState = curPkAndState.getState();
            Set<StateMachine.State> predPkStates = this.pointsToQueried.get(predPk);
            for (StateMachine.State predState : predPkStates) {
                StateMachine.State transState = DemandRefinementPointsTo.this.stateMachine.transition(predState, unbarredLabel);
                if (!transState.equals(curState)) continue;
                ret.add(new PointerKeyAndState(predPk, predState));
            }
            return ret;
        }

        Collection<PointerKeyAndState> matchingTrackedQueried(PointerKeyAndState curPkAndState, PointerKey succPk, IFlowLabel label) {
            ArraySet<PointerKeyAndState> ret = ArraySet.make();
            assert (label.isBarred());
            StateMachine.State curState = curPkAndState.getState();
            Set<StateMachine.State> succPkStates = this.trackedQueried.get(succPk);
            for (StateMachine.State succState : succPkStates) {
                StateMachine.State transState = DemandRefinementPointsTo.this.stateMachine.transition(succState, label);
                if (!transState.equals(curState)) continue;
                ret.add(new PointerKeyAndState(succPk, succState));
            }
            return ret;
        }

        protected void handleBackCopy(PointerKeyAndState curPkAndState, PointerKey predPk, IFlowLabel label) {
            for (PointerKeyAndState predPkAndState : this.matchingPToQueried(curPkAndState, predPk, label)) {
                if (!this.addAllToP2Set(this.pkToP2Set, predPkAndState, this.find(this.pkToP2Set, curPkAndState), label)) continue;
                this.addToPToWorklist(predPkAndState);
            }
        }

        void handleAllBackCopies(PointerKeyAndState curPkAndState, Iterator<? extends Object> predNodes, IFlowLabel label) {
            while (predNodes.hasNext()) {
                this.handleBackCopy(curPkAndState, (PointerKey)predNodes.next(), label);
            }
        }

        void addToPToWorklist(PointerKeyAndState pkAndState) {
            this.pointsToWorklist.add(pkAndState);
            Set<CallerSiteContext> otfCalls = this.pkToOTFCalls.get(pkAndState);
            for (CallerSiteContext callSiteAndCGNode : otfCalls) {
                this.propTargets(pkAndState, callSiteAndCGNode);
            }
        }

        boolean addToInitWorklist(PointerKeyAndState pkAndState) {
            if (this.pointsToQueried.put(pkAndState.getPointerKey(), pkAndState.getState())) {
                CGNode node;
                if (pkAndState.getPointerKey() instanceof AbstractLocalPointerKey && !DemandRefinementPointsTo.this.g.hasSubgraphForNode(node = ((AbstractLocalPointerKey)pkAndState.getPointerKey()).getNode())) assert (false) : "missing constraints for " + node;
                this.initWorklist.add(pkAndState);
                return true;
            }
            return false;
        }

        protected void addToTrackedPToWorklist(PointerKeyAndState pkAndState) {
            CGNode node;
            if (pkAndState.getPointerKey() instanceof AbstractLocalPointerKey && !DemandRefinementPointsTo.this.g.hasSubgraphForNode(node = ((AbstractLocalPointerKey)pkAndState.getPointerKey()).getNode())) assert (false) : "missing constraints for " + node;
            this.trackedQueried.put(pkAndState.getPointerKey(), pkAndState.getState());
            this.trackedPointsToWorklist.add(pkAndState);
        }

        void propTargets(PointerKeyAndState receiverAndState, CallerSiteContext callSiteAndCGNode) {
            final CGNode caller = callSiteAndCGNode.getCaller();
            CallSiteReference call = callSiteAndCGNode.getCallSite();
            final StateMachine.State receiverState = receiverAndState.getState();
            OrdinalSet<InstanceKeyAndState> p2set = this.makeOrdinalSet(this.find(this.pkToP2Set, receiverAndState));
            for (InstanceKeyAndState ikAndState : p2set) {
                InstanceKey ik = ikAndState.getInstanceKey();
                IMethod targetMethod = DemandRefinementPointsTo.this.options.getMethodTargetSelector().getCalleeTarget(caller, call, ik.getConcreteType());
                if (targetMethod == null || this.callToOTFTargets.get(callSiteAndCGNode).contains(targetMethod)) continue;
                this.callToOTFTargets.put(callSiteAndCGNode, targetMethod);
                Set<CGNode> targetCGNodes = DemandRefinementPointsTo.this.cg.getNodes(targetMethod.getReference());
                for (final CGNode targetForCall : targetCGNodes) {
                    SSAAbstractInvokeInstruction[] calls;
                    if (DemandRefinementPointsTo.this.hasNullIR(targetForCall)) continue;
                    DemandRefinementPointsTo.this.g.addSubgraphForNode(targetForCall);
                    SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = calls = DemandRefinementPointsTo.this.getCallInstrs(caller, call);
                    int n = calls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final SSAAbstractInvokeInstruction invokeInstr = sSAAbstractInvokeInstructionArray[n2];
                        final ReturnLabel returnLabel = ReturnLabel.make(new CallerSiteContext(caller, call));
                        if (invokeInstr.hasDef()) {
                            final PointerKeyAndState defAndState = new PointerKeyAndState(DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, invokeInstr.getDef()), receiverState);
                            final PointerKey ret = DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(targetForCall);
                            DemandRefinementPointsTo.this.doTransition(receiverState, returnLabel, new Function<StateMachine.State, Object>(){

                                @Override
                                public Object apply(StateMachine.State retState) {
                                    PointsToComputer.this.repropCallArg(defAndState, new PointerKeyAndState(ret, retState), returnLabel.bar());
                                    return null;
                                }
                            });
                        }
                        final PointerKeyAndState exc = new PointerKeyAndState(DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, invokeInstr.getException()), receiverState);
                        final PointerKey excRet = DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(targetForCall);
                        DemandRefinementPointsTo.this.doTransition(receiverState, returnLabel, new Function<StateMachine.State, Object>(){

                            @Override
                            public Object apply(StateMachine.State excRetState) {
                                PointsToComputer.this.repropCallArg(exc, new PointerKeyAndState(excRet, excRetState), returnLabel.bar());
                                return null;
                            }
                        });
                        PointerParamValueNumIterator iter = new PointerParamValueNumIterator(targetForCall);
                        while (iter.hasNext()) {
                            final int formalNum = (Integer)iter.next();
                            final int actualNum = formalNum - 1;
                            final ParamBarLabel paramBarLabel = ParamBarLabel.make(new CallerSiteContext(caller, call));
                            DemandRefinementPointsTo.this.doTransition(receiverState, paramBarLabel, new Function<StateMachine.State, Object>(){

                                @Override
                                public Object apply(StateMachine.State formalState) {
                                    PointsToComputer.this.repropCallArg(new PointerKeyAndState(((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(targetForCall, formalNum), formalState), new PointerKeyAndState(((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, invokeInstr.getUse(actualNum)), receiverState), paramBarLabel);
                                    return null;
                                }
                            });
                        }
                        ++n2;
                    }
                }
            }
        }

        private void repropCallArg(PointerKeyAndState src, PointerKeyAndState dst, IFlowLabel dstToSrcLabel) {
            for (PointerKeyAndState srcToHandle : this.matchingPToQueried(dst, src.getPointerKey(), dstToSrcLabel)) {
                this.handleCopy(srcToHandle, dst, dstToSrcLabel.bar());
            }
            for (PointerKeyAndState dstToHandle : this.matchingTrackedQueried(src, dst.getPointerKey(), dstToSrcLabel)) {
                MutableIntSet trackedSet = this.find(this.pkToTrackedSet, dstToHandle);
                if (trackedSet.isEmpty() || !this.findOrCreate(this.pkToTrackedSet, src).addAll(trackedSet)) continue;
                this.addToTrackedPToWorklist(src);
            }
        }

        void handleInitWorklist() {
            while (!this.initWorklist.isEmpty()) {
                DemandRefinementPointsTo.this.incrementNumNodesTraversed();
                final PointerKeyAndState curPkAndState = this.initWorklist.iterator().next();
                this.initWorklist.remove(curPkAndState);
                final PointerKey curPk = curPkAndState.getPointerKey();
                final StateMachine.State curState = curPkAndState.getState();
                if (curPk instanceof LocalPointerKey) assert (DemandRefinementPointsTo.this.g.hasSubgraphForNode(((LocalPointerKey)curPk).getNode()));
                AbstractFlowLabelVisitor v = new AbstractFlowLabelVisitor(){

                    public void visitNew(NewLabel label, Object dst) {
                        final InstanceKey ik = (InstanceKey)dst;
                        DemandRefinementPointsTo.this.doTransition(curState, label, new Function<StateMachine.State, Object>(){

                            @Override
                            public Object apply(StateMachine.State newState) {
                                InstanceKeyAndState ikAndState = new InstanceKeyAndState(ik, newState);
                                int n = (this).PointsToComputer.this.ikAndStates.add(ikAndState);
                                PointsToComputer.this.findOrCreate((this).PointsToComputer.this.pkToP2Set, curPkAndState).add(n);
                                PointsToComputer.this.addToPToWorklist(curPkAndState);
                                return null;
                            }
                        });
                    }

                    public void visitGetField(GetFieldLabel label, Object dst) {
                        IField field = label.getField();
                        PointerKey loadBase = (PointerKey)dst;
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(field, loadBase, curPk, label, curState)) {
                            PointerKeyAndState loadBaseAndState = new PointerKeyAndState(loadBase, curState);
                            PointsToComputer.this.addEncounteredLoad(new LoadEdge(loadBaseAndState, field, curPkAndState));
                            if (!PointsToComputer.this.addToInitWorklist(loadBaseAndState)) {
                                for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, loadBaseAndState))) {
                                    PointsToComputer.this.trackInstanceField(ikAndState, field, PointsToComputer.this.forwInstKeyToFields);
                                }
                            }
                        } else {
                            PointsToComputer.this.handleAllCopies(curPkAndState, ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getWritesToInstanceField(loadBase, field), MatchLabel.v());
                        }
                    }

                    public void visitAssignGlobal(AssignGlobalLabel label, Object dst) {
                        PointsToComputer.this.handleAllCopies(curPkAndState, ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getWritesToStaticField((StaticFieldKey)dst), AssignGlobalLabel.v());
                    }

                    public void visitAssign(AssignLabel label, Object dst) {
                        PointsToComputer.this.handleCopy(curPkAndState, (PointerKey)dst, (IFlowLabel)AssignLabel.noFilter());
                    }
                };
                DemandRefinementPointsTo.this.g.visitSuccs(curPk, v);
                this.handleForwInterproc(curPkAndState, new CopyHandler(){

                    void handle(PointerKeyAndState src, PointerKey dst, IFlowLabel label) {
                        PointsToComputer.this.handleCopy(src, dst, label);
                    }
                });
            }
        }

        private void handleForwInterproc(final PointerKeyAndState curPkAndState, final CopyHandler handler) {
            PointerKey curPk = curPkAndState.getPointerKey();
            if (curPk instanceof LocalPointerKey) {
                SSAInvokeInstruction callInstr;
                final LocalPointerKey localPk = (LocalPointerKey)curPk;
                if (DemandRefinementPointsTo.this.g.isParam(localPk)) {
                    final CGNode callee = localPk.getNode();
                    final int paramPos = localPk.getValueNumber() - 1;
                    for (final CallerSiteContext callSiteAndCGNode : DemandRefinementPointsTo.this.g.getPotentialCallers(localPk)) {
                        final CGNode caller = callSiteAndCGNode.getCaller();
                        final CallSiteReference call = callSiteAndCGNode.getCallSite();
                        if (DemandRefinementPointsTo.this.hasNullIR(caller)) continue;
                        final ParamLabel paramLabel = ParamLabel.make(callSiteAndCGNode);
                        DemandRefinementPointsTo.this.doTransition(curPkAndState.getState(), paramLabel, new Function<StateMachine.State, Object>(){

                            private void propagateToCallee() {
                                ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.addSubgraphForNode(caller);
                                SSAAbstractInvokeInstruction[] callInstrs = DemandRefinementPointsTo.this.getCallInstrs(caller, call);
                                int i = 0;
                                while (i < callInstrs.length) {
                                    SSAAbstractInvokeInstruction callInstr = callInstrs[i];
                                    PointerKey actualPk = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(paramPos));
                                    if (!$assertionsDisabled && !((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.containsNode(actualPk)) {
                                        throw new AssertionError();
                                    }
                                    if (!$assertionsDisabled && !((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.containsNode(localPk)) {
                                        throw new AssertionError();
                                    }
                                    handler.handle(curPkAndState, actualPk, paramLabel);
                                    ++i;
                                }
                            }

                            @Override
                            public Object apply(StateMachine.State callerState) {
                                SSAAbstractInvokeInstruction[] callInstrs = DemandRefinementPointsTo.this.getCallInstrs(caller, call);
                                SSAAbstractInvokeInstruction callInstr = callInstrs[0];
                                PointerKey actualPk = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(paramPos));
                                Set<CGNode> possibleTargets = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getPossibleTargets(caller, call, (LocalPointerKey)actualPk);
                                if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(callSiteAndCGNode, possibleTargets)) {
                                    this.propagateToCallee();
                                } else if (PointsToComputer.this.callToOTFTargets.get(callSiteAndCGNode).contains(callee.getMethod())) {
                                    this.propagateToCallee();
                                } else {
                                    PointsToComputer.this.queryCallTargets(callSiteAndCGNode, callInstrs, callerState);
                                }
                                return null;
                            }
                        });
                    }
                }
                if ((callInstr = DemandRefinementPointsTo.this.g.getInstrReturningTo(localPk)) != null) {
                    Set<CGNode> possibleCallees;
                    CGNode caller = localPk.getNode();
                    boolean isExceptional = localPk.getValueNumber() == callInstr.getException();
                    CallSiteReference callSiteRef = callInstr.getCallSite();
                    CallerSiteContext callSiteAndCGNode = new CallerSiteContext(caller, callSiteRef);
                    if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(callSiteAndCGNode, possibleCallees = DemandRefinementPointsTo.this.g.getPossibleTargets(caller, callSiteRef, localPk))) {
                        for (CGNode callee : possibleCallees) {
                            PointerKey retVal;
                            if (DemandRefinementPointsTo.this.hasNullIR(callee)) continue;
                            DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                            PointerKey pointerKey = retVal = isExceptional ? DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(callee) : DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(callee);
                            assert (DemandRefinementPointsTo.this.g.containsNode(retVal));
                            handler.handle(curPkAndState, retVal, ReturnLabel.make(callSiteAndCGNode));
                        }
                    } else if (this.callToOTFTargets.containsKey(callSiteAndCGNode)) {
                        Set<IMethod> targetMethods = this.callToOTFTargets.get(callSiteAndCGNode);
                        for (CGNode callee : possibleCallees) {
                            PointerKey retVal;
                            if (!targetMethods.contains(callee.getMethod()) || DemandRefinementPointsTo.this.hasNullIR(callee)) continue;
                            DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                            PointerKey pointerKey = retVal = isExceptional ? DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(callee) : DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(callee);
                            assert (DemandRefinementPointsTo.this.g.containsNode(retVal));
                            handler.handle(curPkAndState, retVal, ReturnLabel.make(callSiteAndCGNode));
                        }
                    } else {
                        this.queryCallTargets(callSiteAndCGNode, DemandRefinementPointsTo.this.getCallInstrs(caller, callSiteAndCGNode.getCallSite()), curPkAndState.getState());
                    }
                }
            }
        }

        private void trackInstanceField(InstanceKeyAndState ikAndState, IField field, MultiMap<InstanceKeyAndState, IField> ikToFields) {
            ikToFields.put(ikAndState, field);
            this.addPredsOfIKeyAndStateToTrackedPointsTo(ikAndState);
        }

        private void addPredsOfIKeyAndStateToTrackedPointsTo(InstanceKeyAndState ikAndState) throws UnimplementedError {
            Iterator<InstanceKey> iter = DemandRefinementPointsTo.this.g.getPredNodes(ikAndState.getInstanceKey(), NewLabel.v());
            while (iter.hasNext()) {
                PointerKey ikPred = (PointerKey)((Object)iter.next());
                PointerKeyAndState ikPredAndState = new PointerKeyAndState(ikPred, ikAndState.getState());
                int mappedIndex = this.ikAndStates.getMappedIndex(ikAndState);
                assert (mappedIndex != -1);
                if (!this.findOrCreate(this.pkToTrackedSet, ikPredAndState).add(mappedIndex)) continue;
                this.addToTrackedPToWorklist(ikPredAndState);
            }
        }

        private void queryCallTargets(CallerSiteContext callSiteAndCGNode, SSAAbstractInvokeInstruction[] callInstrs, StateMachine.State callerState) {
            CGNode caller = callSiteAndCGNode.getCaller();
            SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = callInstrs;
            int n = callInstrs.length;
            int n2 = 0;
            while (n2 < n) {
                SSAAbstractInvokeInstruction callInstr = sSAAbstractInvokeInstructionArray[n2];
                PointerKey thisArg = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(0));
                PointerKeyAndState thisArgAndState = new PointerKeyAndState(thisArg, callerState);
                if (this.pkToOTFCalls.put(thisArgAndState, callSiteAndCGNode)) {
                    CGNode node = ((LocalPointerKey)thisArg).getNode();
                    if (DemandRefinementPointsTo.this.hasNullIR(node)) {
                        return;
                    }
                    DemandRefinementPointsTo.this.g.addSubgraphForNode(node);
                    if (!this.addToInitWorklist(thisArgAndState)) {
                        this.propTargets(thisArgAndState, callSiteAndCGNode);
                    }
                } else {
                    this.propTargets(thisArgAndState, callSiteAndCGNode);
                }
                ++n2;
            }
        }

        void handlePointsToWorklist() {
            while (!this.pointsToWorklist.isEmpty()) {
                DemandRefinementPointsTo.this.incrementNumNodesTraversed();
                final PointerKeyAndState curPkAndState = this.pointsToWorklist.iterator().next();
                this.pointsToWorklist.remove(curPkAndState);
                final PointerKey curPk = curPkAndState.getPointerKey();
                final StateMachine.State curState = curPkAndState.getState();
                AbstractFlowLabelVisitor predVisitor = new AbstractFlowLabelVisitor(){

                    public void visitPutField(PutFieldLabel label, Object dst) {
                        IField field = label.getField();
                        PointerKey storeBase = (PointerKey)dst;
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(field, storeBase, curPk, label, curState)) {
                            PointerKeyAndState storeBaseAndState = new PointerKeyAndState(storeBase, curState);
                            PointsToComputer.this.encounteredStores.add(new StoreEdge(storeBaseAndState, field, curPkAndState));
                            for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToTrackedSet, storeBaseAndState))) {
                                if (!PointsToComputer.this.forwInstKeyToFields.get(ikAndState).contains(field)) continue;
                                InstanceFieldKeyAndState ifKeyAndState = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToP2Set, ifKeyAndState).addAll(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, curPkAndState));
                            }
                        } else {
                            PointsToComputer.this.handleAllBackCopies(curPkAndState, ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getReadsOfInstanceField(storeBase, field), MatchBarLabel.v());
                        }
                    }

                    public void visitGetField(GetFieldLabel label, Object dst) {
                        IField field = label.getField();
                        PointerKey dstPtrKey = (PointerKey)dst;
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(field, curPk, dstPtrKey, label, curState)) {
                            PointerKeyAndState loadDefAndState = new PointerKeyAndState(dstPtrKey, curState);
                            PointsToComputer.this.addEncounteredLoad(new LoadEdge(curPkAndState, field, loadDefAndState));
                            if (PointsToComputer.this.pointsToQueried.get(dstPtrKey).contains(curState)) {
                                for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, curPkAndState))) {
                                    PointsToComputer.this.trackInstanceField(ikAndState, field, PointsToComputer.this.forwInstKeyToFields);
                                }
                            }
                        }
                    }

                    public void visitAssignGlobal(AssignGlobalLabel label, Object dst) {
                        PointsToComputer.this.handleAllBackCopies(curPkAndState, ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getReadsOfStaticField((StaticFieldKey)dst), label.bar());
                    }

                    public void visitAssign(AssignLabel label, Object dst) {
                        PointsToComputer.this.handleBackCopy(curPkAndState, (PointerKey)dst, label.bar());
                    }
                };
                DemandRefinementPointsTo.this.g.visitPreds(curPk, predVisitor);
                AbstractFlowLabelVisitor succVisitor = new AbstractFlowLabelVisitor(){

                    public void visitPutField(PutFieldLabel label, Object dst) {
                        IField field = label.getField();
                        PointerKey dstPtrKey = (PointerKey)dst;
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(field, curPk, dstPtrKey, label.bar(), curState)) {
                            PointerKeyAndState storeDst = new PointerKeyAndState(dstPtrKey, curState);
                            PointsToComputer.this.encounteredStores.add(new StoreEdge(curPkAndState, field, storeDst));
                            MutableIntSet trackedSet = PointsToComputer.this.find(PointsToComputer.this.pkToTrackedSet, storeDst);
                            if (!trackedSet.isEmpty()) {
                                for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, curPkAndState))) {
                                    InstanceFieldKeyAndState ifk = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                    PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToTrackedSet, ifk).addAll(trackedSet);
                                    PointsToComputer.this.trackInstanceField(ikAndState, field, PointsToComputer.this.backInstKeyToFields);
                                }
                            }
                        }
                    }
                };
                DemandRefinementPointsTo.this.g.visitSuccs(curPk, succVisitor);
                this.handleBackInterproc(curPkAndState, new CopyHandler(){

                    void handle(PointerKeyAndState src, PointerKey dst, IFlowLabel label) {
                        PointsToComputer.this.handleBackCopy(src, dst, label);
                    }
                }, false);
            }
        }

        private void handleBackInterproc(final PointerKeyAndState curPkAndState, final CopyHandler handler, boolean addGraphs) {
            PointerKey curPk = curPkAndState.getPointerKey();
            StateMachine.State curState = curPkAndState.getState();
            if (curPk instanceof ReturnValueKey) {
                final ReturnValueKey returnKey = (ReturnValueKey)curPk;
                final CGNode callee = returnKey.getNode();
                final boolean isExceptional = returnKey instanceof ExceptionReturnValueKey;
                for (final CallerSiteContext callSiteAndCGNode : DemandRefinementPointsTo.this.g.getPotentialCallers(returnKey)) {
                    final CGNode caller = callSiteAndCGNode.getCaller();
                    if (DemandRefinementPointsTo.this.hasNullIR(caller)) continue;
                    final CallSiteReference call = callSiteAndCGNode.getCallSite();
                    if (this.calleeSubGraphMissingAndShouldNotBeAdded(addGraphs, callee, curPkAndState)) continue;
                    final ReturnBarLabel returnBarLabel = ReturnBarLabel.make(callSiteAndCGNode);
                    DemandRefinementPointsTo.this.doTransition(curState, returnBarLabel, new Function<StateMachine.State, Object>(){

                        private void propagateToCaller() {
                            ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.addSubgraphForNode(caller);
                            SSAAbstractInvokeInstruction[] callInstrs = DemandRefinementPointsTo.this.getCallInstrs(caller, call);
                            int i = 0;
                            while (i < callInstrs.length) {
                                SSAAbstractInvokeInstruction callInstr = callInstrs[i];
                                PointerKey returnAtCallerKey = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, isExceptional ? callInstr.getException() : callInstr.getDef());
                                if (!$assertionsDisabled && !((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.containsNode(returnAtCallerKey)) {
                                    throw new AssertionError();
                                }
                                if (!$assertionsDisabled && !((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.containsNode(returnKey)) {
                                    throw new AssertionError();
                                }
                                handler.handle(curPkAndState, returnAtCallerKey, returnBarLabel);
                                ++i;
                            }
                        }

                        @Override
                        public Object apply(StateMachine.State callerState) {
                            SSAAbstractInvokeInstruction[] callInstrs = DemandRefinementPointsTo.this.getCallInstrs(caller, call);
                            SSAAbstractInvokeInstruction callInstr = callInstrs[0];
                            PointerKey returnAtCallerKey = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, isExceptional ? callInstr.getException() : callInstr.getDef());
                            Set<CGNode> possibleTargets = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getPossibleTargets(caller, call, (LocalPointerKey)returnAtCallerKey);
                            if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(callSiteAndCGNode, possibleTargets)) {
                                this.propagateToCaller();
                            } else if (PointsToComputer.this.callToOTFTargets.get(callSiteAndCGNode).contains(callee.getMethod())) {
                                this.propagateToCaller();
                            } else {
                                PointsToComputer.this.queryCallTargets(callSiteAndCGNode, callInstrs, callerState);
                            }
                            return null;
                        }
                    });
                }
            }
            if (curPk instanceof LocalPointerKey) {
                LocalPointerKey localPk = (LocalPointerKey)curPk;
                CGNode caller = localPk.getNode();
                Iterator<SSAInvokeInstruction> iter = DemandRefinementPointsTo.this.g.getInstrsPassingParam(localPk);
                while (iter.hasNext()) {
                    SSAInvokeInstruction callInstr = iter.next();
                    int i = 0;
                    while (i < callInstr.getNumberOfUses()) {
                        if (localPk.getValueNumber() == callInstr.getUse(i)) {
                            Set<CGNode> possibleCallees;
                            CallSiteReference callSiteRef = callInstr.getCallSite();
                            CallerSiteContext callSiteAndCGNode = new CallerSiteContext(caller, callSiteRef);
                            if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(callSiteAndCGNode, possibleCallees = DemandRefinementPointsTo.this.g.getPossibleTargets(caller, callSiteRef, localPk))) {
                                for (CGNode callee : possibleCallees) {
                                    if (this.calleeSubGraphMissingAndShouldNotBeAdded(addGraphs, callee, curPkAndState) || DemandRefinementPointsTo.this.hasNullIR(callee)) continue;
                                    DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                                    PointerKey paramVal = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(callee, i + 1);
                                    assert (DemandRefinementPointsTo.this.g.containsNode(paramVal));
                                    handler.handle(curPkAndState, paramVal, ParamBarLabel.make(callSiteAndCGNode));
                                }
                            } else if (this.callToOTFTargets.containsKey(callSiteAndCGNode)) {
                                Set<IMethod> targetMethods = this.callToOTFTargets.get(callSiteAndCGNode);
                                for (CGNode callee : possibleCallees) {
                                    if (!targetMethods.contains(callee.getMethod()) || DemandRefinementPointsTo.this.hasNullIR(callee)) continue;
                                    DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                                    PointerKey paramVal = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(callee, i + 1);
                                    assert (DemandRefinementPointsTo.this.g.containsNode(paramVal));
                                    handler.handle(curPkAndState, paramVal, ParamBarLabel.make(callSiteAndCGNode));
                                }
                            } else {
                                this.queryCallTargets(callSiteAndCGNode, DemandRefinementPointsTo.this.getCallInstrs(caller, callSiteAndCGNode.getCallSite()), curState);
                            }
                        }
                        ++i;
                    }
                }
            }
        }

        protected boolean calleeSubGraphMissingAndShouldNotBeAdded(boolean addGraphs, CGNode callee, PointerKeyAndState pkAndState) {
            return !addGraphs && !DemandRefinementPointsTo.this.g.hasSubgraphForNode(callee);
        }

        public void handleTrackedPointsToWorklist() {
            while (!this.trackedPointsToWorklist.isEmpty()) {
                DemandRefinementPointsTo.this.incrementNumNodesTraversed();
                final PointerKeyAndState curPkAndState = this.trackedPointsToWorklist.iterator().next();
                this.trackedPointsToWorklist.remove(curPkAndState);
                final PointerKey curPk = curPkAndState.getPointerKey();
                final StateMachine.State curState = curPkAndState.getState();
                final MutableIntSet trackedSet = this.find(this.pkToTrackedSet, curPkAndState);
                AbstractFlowLabelVisitor succVisitor = new AbstractFlowLabelVisitor(){

                    public void visitPutField(PutFieldLabel label, Object dst) {
                        IField field = label.getField();
                        PointerKey dstPtrKey = (PointerKey)dst;
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(field, curPk, dstPtrKey, label, curState)) {
                            for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet(trackedSet)) {
                                boolean needField = PointsToComputer.this.forwInstKeyToFields.get(ikAndState).contains(field);
                                PointerKeyAndState storeDst = new PointerKeyAndState(dstPtrKey, curState);
                                PointsToComputer.this.encounteredStores.add(new StoreEdge(curPkAndState, field, storeDst));
                                if (!needField || PointsToComputer.this.addToInitWorklist(storeDst)) continue;
                                InstanceFieldKeyAndState ifk = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToP2Set, ifk).addAll(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, storeDst));
                            }
                        }
                    }
                };
                DemandRefinementPointsTo.this.g.visitSuccs(curPk, succVisitor);
                AbstractFlowLabelVisitor predVisitor = new AbstractFlowLabelVisitor(){

                    public void visitAssignGlobal(AssignGlobalLabel label, Object dst) {
                        Iterator<? extends Object> readIter = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getReadsOfStaticField((StaticFieldKey)dst);
                        while (readIter.hasNext()) {
                            final PointerKey predPk = (PointerKey)readIter.next();
                            DemandRefinementPointsTo.this.doTransition(curState, AssignGlobalBarLabel.v(), new Function<StateMachine.State, Object>(){

                                @Override
                                public Object apply(StateMachine.State predPkState) {
                                    PointerKeyAndState predPkAndState = new PointerKeyAndState(predPk, predPkState);
                                    PointsToComputer.this.handleTrackedPred(trackedSet, predPkAndState, AssignGlobalBarLabel.v());
                                    return null;
                                }
                            });
                        }
                    }

                    public void visitPutField(PutFieldLabel label, Object dst) {
                        block3: {
                            PointerKey storeBase;
                            IField field;
                            block2: {
                                field = label.getField();
                                storeBase = (PointerKey)dst;
                                if (!DemandRefinementPointsTo.this.refineFieldAccesses(field, storeBase, curPk, label.bar(), curState)) break block2;
                                PointerKeyAndState storeBaseAndState = new PointerKeyAndState(storeBase, curState);
                                PointsToComputer.this.encounteredStores.add(new StoreEdge(storeBaseAndState, field, curPkAndState));
                                if (PointsToComputer.this.addToInitWorklist(storeBaseAndState)) break block3;
                                for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, storeBaseAndState))) {
                                    InstanceFieldKeyAndState ifk = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                    PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToTrackedSet, ifk).addAll(trackedSet);
                                    PointsToComputer.this.trackInstanceField(ikAndState, field, PointsToComputer.this.backInstKeyToFields);
                                }
                                break block3;
                            }
                            Iterator<PointerKey> readIter = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getReadsOfInstanceField(storeBase, field);
                            while (readIter.hasNext()) {
                                final PointerKey predPk = readIter.next();
                                DemandRefinementPointsTo.this.doTransition(curState, MatchBarLabel.v(), new Function<StateMachine.State, Object>(){

                                    @Override
                                    public Object apply(StateMachine.State predPkState) {
                                        PointerKeyAndState predPkAndState = new PointerKeyAndState(predPk, predPkState);
                                        PointsToComputer.this.handleTrackedPred(trackedSet, predPkAndState, MatchBarLabel.v());
                                        return null;
                                    }
                                });
                            }
                        }
                    }

                    public void visitGetField(GetFieldLabel label, Object dst) {
                        IField field = label.getField();
                        PointerKey dstPtrKey = (PointerKey)dst;
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(field, curPk, dstPtrKey, label.bar(), curState)) {
                            for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet(trackedSet)) {
                                boolean needField = PointsToComputer.this.backInstKeyToFields.get(ikAndState).contains(field);
                                PointerKeyAndState loadedVal = new PointerKeyAndState(dstPtrKey, curState);
                                PointsToComputer.this.addEncounteredLoad(new LoadEdge(curPkAndState, field, loadedVal));
                                if (!needField) continue;
                                InstanceFieldKeyAndState ifk = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                PointsToComputer.this.handleTrackedPred(PointsToComputer.this.find(PointsToComputer.this.instFieldKeyToTrackedSet, ifk), loadedVal, AssignBarLabel.noFilter());
                            }
                        }
                    }

                    public void visitAssign(final AssignLabel label, Object dst) {
                        final PointerKey predPk = (PointerKey)dst;
                        DemandRefinementPointsTo.this.doTransition(curState, label.bar(), new Function<StateMachine.State, Object>(){

                            @Override
                            public Object apply(StateMachine.State predPkState) {
                                PointerKeyAndState predPkAndState = new PointerKeyAndState(predPk, predPkState);
                                PointsToComputer.this.handleTrackedPred(trackedSet, predPkAndState, label.bar());
                                return null;
                            }
                        });
                    }
                };
                DemandRefinementPointsTo.this.g.visitPreds(curPk, predVisitor);
                this.handleBackInterproc(curPkAndState, new CopyHandler(){

                    void handle(PointerKeyAndState src, final PointerKey dst, final IFlowLabel label) {
                        if (!$assertionsDisabled && src != curPkAndState) {
                            throw new AssertionError();
                        }
                        DemandRefinementPointsTo.this.doTransition(curState, label, new Function<StateMachine.State, Object>(){

                            @Override
                            public Object apply(StateMachine.State dstState) {
                                PointerKeyAndState dstAndState = new PointerKeyAndState(dst, dstState);
                                PointsToComputer.this.handleTrackedPred(trackedSet, dstAndState, label);
                                return null;
                            }
                        });
                    }
                }, true);
            }
        }

        private void addEncounteredLoad(LoadEdge loadEdge) {
            this.encounteredLoads.add(loadEdge);
        }

        public void makePassOverFieldStmts() {
            IField field;
            for (StoreEdge storeEdge : this.encounteredStores) {
                PointerKeyAndState storedValAndState = storeEdge.val;
                field = storeEdge.field;
                PointerKeyAndState baseAndState = storeEdge.base;
                MutableIntSet trackedSet = this.find(this.pkToTrackedSet, baseAndState);
                for (InstanceKeyAndState ikAndState : this.makeOrdinalSet(trackedSet)) {
                    if (!this.forwInstKeyToFields.get(ikAndState).contains(field) || this.addToInitWorklist(storedValAndState)) continue;
                    InstanceFieldKeyAndState ifk = this.getInstFieldKey(ikAndState, field);
                    this.findOrCreate(this.instFieldKeyToP2Set, ifk).addAll(this.find(this.pkToP2Set, storedValAndState));
                }
            }
            for (LoadEdge loadEdge : this.encounteredLoads) {
                PointerKeyAndState loadedValAndState = loadEdge.val;
                field = loadEdge.field;
                PointerKey basePointerKey = loadEdge.base.getPointerKey();
                StateMachine.State loadDstState = loadedValAndState.getState();
                PointerKeyAndState baseAndStateToHandle = new PointerKeyAndState(basePointerKey, loadDstState);
                boolean basePointerOkay = this.pointsToQueried.get(basePointerKey).contains(loadDstState) || !this.pointsToQueried.get(loadedValAndState.getPointerKey()).contains(loadDstState) || this.initWorklist.contains(loadedValAndState);
                MutableIntSet curP2Set = this.find(this.pkToP2Set, baseAndStateToHandle);
                for (InstanceKeyAndState ikAndState : this.makeOrdinalSet(curP2Set)) {
                    InstanceFieldKeyAndState ifk = this.getInstFieldKey(ikAndState, field);
                    if (!this.pointsToQueried.get(loadedValAndState.getPointerKey()).contains(loadedValAndState.getState()) || !this.addAllToP2Set(this.pkToP2Set, loadedValAndState, this.find(this.instFieldKeyToP2Set, ifk), AssignLabel.noFilter())) continue;
                    this.addToPToWorklist(loadedValAndState);
                }
                PointerKeyAndState baseAndState = loadEdge.base;
                for (InstanceKeyAndState ikAndState : this.makeOrdinalSet(this.find(this.pkToTrackedSet, baseAndState))) {
                    if (!this.backInstKeyToFields.get(ikAndState).contains(field)) continue;
                    InstanceFieldKeyAndState ifk = this.getInstFieldKey(ikAndState, field);
                    if (!this.findOrCreate(this.pkToTrackedSet, loadedValAndState).addAll(this.find(this.instFieldKeyToTrackedSet, ifk))) continue;
                    this.addToTrackedPToWorklist(loadedValAndState);
                }
            }
        }

        private InstanceFieldKeyAndState getInstFieldKey(InstanceKeyAndState ikAndState, IField field) {
            return new InstanceFieldKeyAndState(new InstanceFieldKey(ikAndState.getInstanceKey(), field), ikAndState.getState());
        }

        protected <K> MutableIntSet findOrCreate(Map<K, MutableIntSet> M, K key) {
            MutableIntSet result = M.get(key);
            if (result == null) {
                result = this.intSetFactory.make();
                M.put(key, result);
            }
            return result;
        }

        protected <K> MutableIntSet find(Map<K, MutableIntSet> M, K key) {
            MutableIntSet result = M.get(key);
            if (result == null) {
                result = this.emptySet;
            }
            return result;
        }

        protected boolean handleTrackedPred(MutableIntSet curTrackedSet, PointerKeyAndState predPkAndState, IFlowLabel label) {
            if (this.addAllToP2Set(this.pkToTrackedSet, predPkAndState, curTrackedSet, label)) {
                this.addToTrackedPToWorklist(predPkAndState);
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PointsToResult {
        SUCCESS,
        NOMOREREFINE,
        BUDGETEXCEEDED;

    }

    private static final class StoreEdge {
        final PointerKeyAndState base;
        final IField field;
        final PointerKeyAndState val;

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.val.hashCode();
            result = 31 * result + this.field.hashCode();
            result = 31 * result + this.base.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StoreEdge other = (StoreEdge)obj;
            if (!this.val.equals(other.val)) {
                return false;
            }
            if (!this.field.equals(other.field)) {
                return false;
            }
            return this.base.equals(other.base);
        }

        public StoreEdge(PointerKeyAndState base, IField field, PointerKeyAndState val) {
            this.base = base;
            this.field = field;
            this.val = val;
        }
    }
}

