/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.dataflow.IFDS.CallFlowEdges;
import com.ibm.wala.dataflow.IFDS.IBinaryReturnFlowFunction;
import com.ibm.wala.dataflow.IFDS.IFlowFunction;
import com.ibm.wala.dataflow.IFDS.IFlowFunctionMap;
import com.ibm.wala.dataflow.IFDS.IMergeFunction;
import com.ibm.wala.dataflow.IFDS.IReversibleFlowFunction;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.ITabulationWorklist;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.dataflow.IFDS.LocalPathEdges;
import com.ibm.wala.dataflow.IFDS.LocalSummaryEdges;
import com.ibm.wala.dataflow.IFDS.PathEdge;
import com.ibm.wala.dataflow.IFDS.TabulationCancelException;
import com.ibm.wala.dataflow.IFDS.TabulationProblem;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Heap;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.ToStringComparator;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import com.ibm.wala.util.ref.ReferenceCleanser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabulationSolver<T, P, F> {
    protected static final int DEBUG_LEVEL = 0;
    protected static final boolean verbose = "true".equals(System.getProperty("com.ibm.wala.fixedpoint.impl.verbose"));
    static final int VERBOSE_INTERVAL = 1000;
    static final boolean VERBOSE_TRACE_MEMORY = false;
    private static int verboseCounter = 0;
    protected static final boolean PERIODIC_WIPE_SOFT_CACHES = true;
    private static final int WIPE_SOFT_CACHE_INTERVAL = 1000000;
    private static int wipeCount = 1000000;
    protected final ISupergraph<T, P> supergraph;
    protected final IFlowFunctionMap<T> flowFunctionMap;
    private final TabulationProblem<T, P, F> problem;
    private final Map<T, LocalPathEdges> pathEdges = HashMapFactory.make();
    private final Map<T, CallFlowEdges> callFlowEdges = HashMapFactory.make();
    protected final Map<P, LocalSummaryEdges> summaryEdges = HashMapFactory.make();
    private final Map<P, Set<PathEdge<T>>> seeds = HashMapFactory.make();
    private final Set<PathEdge<T>> allSeeds = HashSetFactory.make();
    private ITabulationWorklist<T> worklist;
    protected final MonitorUtil.IProgressMonitor progressMonitor;
    private PathEdge<T> curPathEdge;
    private PathEdge<T> curSummaryEdge;

    protected TabulationSolver(TabulationProblem<T, P, F> p, MonitorUtil.IProgressMonitor monitor) {
        if (p == null) {
            throw new IllegalArgumentException("p is null");
        }
        this.supergraph = p.getSupergraph();
        this.flowFunctionMap = p.getFunctionMap();
        this.problem = p;
        this.progressMonitor = monitor;
    }

    protected ITabulationWorklist<T> makeWorklist() {
        return new Worklist();
    }

    public static <T, P, F> TabulationSolver<T, P, F> make(TabulationProblem<T, P, F> p) {
        return new TabulationSolver<T, P, F>(p, null);
    }

    public TabulationResult<T, P, F> solve() throws CancelException {
        try {
            this.initialize();
            this.forwardTabulateSLRPs();
            Result r = new Result();
            return r;
        }
        catch (CancelException e) {
            Result r = new Result();
            throw new TabulationCancelException(e, r);
        }
        catch (CancelRuntimeException e) {
            Result r = new Result();
            throw new TabulationCancelException(e, r);
        }
    }

    protected void initialize() {
        for (PathEdge<T> seed : this.problem.initialSeeds()) {
            this.addSeed(seed);
        }
    }

    public void addSeed(PathEdge<T> seed) {
        Set<PathEdge<T>> s = MapUtil.findOrCreateSet(this.seeds, this.supergraph.getProcOf(seed.entry));
        s.add(seed);
        this.allSeeds.add(seed);
        this.propagate(seed.entry, seed.d1, seed.target, seed.d2);
    }

    private void forwardTabulateSLRPs() throws CancelException {
        assert (this.curPathEdge == null) : "curPathEdge should not be non-null here";
        if (this.worklist == null) {
            this.worklist = this.makeWorklist();
        }
        while (this.worklist.size() > 0) {
            MonitorUtil.throwExceptionIfCanceled(this.progressMonitor);
            if (verbose) {
                this.performVerboseAction();
            }
            this.tendToSoftCaches();
            PathEdge<T> edge = this.popFromWorkList();
            this.curPathEdge = edge;
            int j = this.merge(edge.entry, edge.d1, edge.target, edge.d2);
            if (j == -1) continue;
            if (j != edge.d2) {
                this.propagate(edge.entry, edge.d1, edge.target, j);
                continue;
            }
            if (this.supergraph.isCall(edge.target)) {
                this.processCall(edge);
                continue;
            }
            if (this.supergraph.isExit(edge.target)) {
                this.processExit(edge);
                continue;
            }
            this.processNormal(edge);
        }
        this.curPathEdge = null;
    }

    protected void tendToSoftCaches() {
        if (++wipeCount > 1000000) {
            wipeCount = 0;
            ReferenceCleanser.clearSoftCaches();
        }
    }

    protected final void performVerboseAction() {
        if (++verboseCounter % 1000 == 0) {
            System.err.println("Tabulation Solver " + verboseCounter);
            System.err.println("  " + this.peekFromWorkList());
        }
    }

    private void processNormal(final PathEdge<T> edge) {
        Iterator it = this.supergraph.getSuccNodes(edge.target);
        while (it.hasNext()) {
            final Object m = it.next();
            IUnaryFlowFunction f = this.flowFunctionMap.getNormalFlowFunction(edge.target, m);
            IntSet D3 = this.computeFlow(edge.d2, f);
            if (D3 == null) continue;
            D3.foreach(new IntSetAction(){

                public void act(int d3) {
                    TabulationSolver.this.propagate(edge.entry, edge.d1, m, d3);
                }
            });
        }
    }

    protected void processExit(PathEdge<T> edge) {
        int x;
        int s_p_n;
        LocalSummaryEdges summaries = this.findOrCreateLocalSummaryEdges(this.supergraph.getProcOf(edge.target));
        if (!summaries.contains(s_p_n = this.supergraph.getLocalBlockNumber(edge.entry), x = this.supergraph.getLocalBlockNumber(edge.target), edge.d1, edge.d2)) {
            summaries.insertSummaryEdge(s_p_n, x, edge.d1, edge.d2);
        }
        assert (this.curSummaryEdge == null) : "curSummaryEdge should be null here";
        this.curSummaryEdge = edge;
        CallFlowEdges callFlow = this.findOrCreateCallFlowEdges(edge.entry);
        IntSet callFlowSourceNodes = callFlow.getCallFlowSourceNodes(edge.d1);
        if (callFlowSourceNodes != null) {
            IntIterator it = callFlowSourceNodes.intIterator();
            while (it.hasNext()) {
                int globalC = it.next();
                IntSet D4 = callFlow.getCallFlowSources(globalC, edge.d1);
                this.propagateToReturnSites(edge, this.supergraph.getNode(globalC), D4);
            }
        }
        this.curSummaryEdge = null;
    }

    private void propagateToReturnSites(PathEdge<T> edge, final T c, IntSet D4) {
        P proc = this.supergraph.getProcOf(c);
        final Object[] entries = this.supergraph.getEntriesForProcedure(proc);
        Iterator<T> retSites = this.supergraph.getReturnSites(c, this.supergraph.getProcOf(edge.target));
        while (retSites.hasNext()) {
            final T retSite = retSites.next();
            if (!this.supergraph.hasEdge(edge.target, retSite)) continue;
            IFlowFunction retf = this.flowFunctionMap.getReturnFlowFunction(c, edge.target, retSite);
            if (retf instanceof IBinaryReturnFlowFunction) {
                this.propagateToReturnSiteWithBinaryFlowFunction(edge, c, D4, entries, retSite, retf);
                continue;
            }
            final IntSet D5 = this.computeFlow(edge.d2, (IUnaryFlowFunction)retf);
            IntSetAction action = new IntSetAction(){

                public void act(int d4) {
                    TabulationSolver.this.propToReturnSite(c, entries, retSite, d4, D5);
                }
            };
            D4.foreach(action);
        }
    }

    private void propagateToReturnSiteWithBinaryFlowFunction(final PathEdge edge, final T c, IntSet D4, final T[] entries, final T retSite, final IFlowFunction retf) {
        D4.foreach(new IntSetAction(){

            public void act(int d4) {
                IntSet D5 = TabulationSolver.this.computeBinaryFlow(d4, edge.d2, (IBinaryReturnFlowFunction)retf);
                TabulationSolver.this.propToReturnSite(c, entries, retSite, d4, D5);
            }
        });
    }

    private void propToReturnSite(final T c, final T[] entries, final T retSite, final int d4, IntSet D5) {
        if (D5 != null) {
            D5.foreach(new IntSetAction(){

                public void act(final int d5) {
                    int i = 0;
                    while (i < entries.length) {
                        final Object s_p = entries[i];
                        IntSet D3 = TabulationSolver.this.getInversePathEdges(s_p, c, d4);
                        if (D3 != null) {
                            D3.foreach(new IntSetAction(){

                                public void act(int d3) {
                                    TabulationSolver.this.curPathEdge = PathEdge.createPathEdge(s_p, d3, c, d4);
                                    TabulationSolver.this.propagate(s_p, d3, retSite, d5);
                                }
                            });
                        }
                        ++i;
                    }
                }
            });
        }
    }

    protected IntSet getInversePathEdges(T s_p, T n, int d2) {
        int number = this.supergraph.getLocalBlockNumber(n);
        LocalPathEdges lp = this.pathEdges.get(s_p);
        if (lp == null) {
            return null;
        }
        return lp.getInverse(number, d2);
    }

    protected void processCall(final PathEdge<T> edge) {
        IUnaryFlowFunction f;
        int c = this.supergraph.getNumber(edge.target);
        HashSet<T> allReturnSites = HashSetFactory.make();
        Iterator<T> it = this.supergraph.getReturnSites(edge.target, null);
        while (it.hasNext()) {
            allReturnSites.add(it.next());
        }
        boolean hasCallee = false;
        Iterator<T> it2 = this.supergraph.getCalledNodes(edge.target);
        while (it2.hasNext()) {
            hasCallee = true;
            T callee = it2.next();
            this.processParticularCallee(edge, c, allReturnSites, callee);
        }
        Iterator<T> it3 = this.supergraph.getNormalSuccessors(edge.target);
        while (it3.hasNext()) {
            final T m = it3.next();
            f = this.flowFunctionMap.getNormalFlowFunction(edge.target, m);
            IntSet D3 = this.computeFlow(edge.d2, f);
            if (D3 == null) continue;
            D3.foreach(new IntSetAction(){

                public void act(int d3) {
                    TabulationSolver.this.propagate(edge.entry, edge.d1, m, d3);
                }
            });
        }
        for (final Object returnSite : allReturnSites) {
            f = null;
            f = hasCallee ? this.flowFunctionMap.getCallToReturnFlowFunction(edge.target, returnSite) : this.flowFunctionMap.getCallNoneToReturnFlowFunction(edge.target, returnSite);
            IntSet reached = this.computeFlow(edge.d2, f);
            if (reached == null) continue;
            reached.foreach(new IntSetAction(){

                public void act(int x) {
                    if (!$assertionsDisabled && x < 0) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && edge.d1 < 0) {
                        throw new AssertionError();
                    }
                    TabulationSolver.this.propagate(edge.entry, edge.d1, returnSite, x);
                }
            });
        }
    }

    protected void processParticularCallee(final PathEdge<T> edge, final int callNodeNum, Collection<T> allReturnSites, final T calleeEntry) {
        MutableSparseIntSet reached = MutableSparseIntSet.makeEmpty();
        final Iterator2Set returnSitesForCallee = Iterator2Collection.toSet(this.supergraph.getReturnSites(edge.target, this.supergraph.getProcOf(calleeEntry)));
        allReturnSites.addAll(returnSitesForCallee);
        for (Object returnSite : returnSitesForCallee) {
            IUnaryFlowFunction f = this.flowFunctionMap.getCallFlowFunction(edge.target, calleeEntry, returnSite);
            IntSet r = this.computeFlow(edge.d2, f);
            if (r == null) continue;
            reached.addAll(r);
        }
        IUnaryFlowFunction f = this.flowFunctionMap.getCallFlowFunction(edge.target, calleeEntry, null);
        IntSet r = this.computeFlow(edge.d2, f);
        if (r != null) {
            reached.addAll(r);
        }
        if (reached != null) {
            final LocalSummaryEdges summaries = this.summaryEdges.get(this.supergraph.getProcOf(calleeEntry));
            final CallFlowEdges callFlow = this.findOrCreateCallFlowEdges(calleeEntry);
            final int s_p_num = this.supergraph.getLocalBlockNumber(calleeEntry);
            reached.foreach(new IntSetAction(){

                public void act(final int d1) {
                    boolean gotReuse = !TabulationSolver.this.propagate(calleeEntry, d1, calleeEntry, d1);
                    TabulationSolver.this.recordCall(edge.target, calleeEntry, d1, gotReuse);
                    callFlow.addCallEdge(callNodeNum, edge.d2, d1);
                    if (summaries != null) {
                        Object p = TabulationSolver.this.supergraph.getProcOf(calleeEntry);
                        T[] exits = TabulationSolver.this.supergraph.getExitsForProcedure(p);
                        int e = 0;
                        while (e < exits.length) {
                            final Object exit = exits[e];
                            int x_num = TabulationSolver.this.supergraph.getLocalBlockNumber(exit);
                            IntSet reachedBySummary = summaries.getSummaryEdges(s_p_num, x_num, d1);
                            if (reachedBySummary != null) {
                                for (final Object returnSite : returnSitesForCallee) {
                                    if (!TabulationSolver.this.supergraph.hasEdge(exit, returnSite)) continue;
                                    final IFlowFunction retf = TabulationSolver.this.flowFunctionMap.getReturnFlowFunction(edge.target, exit, returnSite);
                                    reachedBySummary.foreach(new IntSetAction(){

                                        public void act(int d2) {
                                            if (!$assertionsDisabled && TabulationSolver.this.curSummaryEdge != null) {
                                                throw new AssertionError((Object)"curSummaryEdge should be null here");
                                            }
                                            TabulationSolver.this.curSummaryEdge = PathEdge.createPathEdge(calleeEntry, d1, exit, d2);
                                            if (retf instanceof IBinaryReturnFlowFunction) {
                                                IntSet D5 = TabulationSolver.this.computeBinaryFlow(edge.d2, d2, (IBinaryReturnFlowFunction)retf);
                                                if (D5 != null) {
                                                    D5.foreach(new IntSetAction(){

                                                        public void act(int d5) {
                                                            TabulationSolver.this.propagate(edge.entry, edge.d1, returnSite, d5);
                                                        }
                                                    });
                                                }
                                            } else {
                                                IntSet D5 = TabulationSolver.this.computeFlow(d2, (IUnaryFlowFunction)retf);
                                                if (D5 != null) {
                                                    D5.foreach(new IntSetAction(){

                                                        public void act(int d5) {
                                                            TabulationSolver.this.propagate(edge.entry, edge.d1, returnSite, d5);
                                                        }
                                                    });
                                                }
                                            }
                                            TabulationSolver.this.curSummaryEdge = null;
                                        }
                                    });
                                }
                            }
                            ++e;
                        }
                    }
                }
            });
        }
    }

    protected void recordCall(T callNode, T callee, int d1, boolean gotReuse) {
    }

    protected IntSet computeBinaryFlow(int call_d, int exit_d, IBinaryReturnFlowFunction f) {
        SparseIntSet result = f.getTargets(call_d, exit_d);
        return result;
    }

    protected IntSet computeFlow(int d1, IUnaryFlowFunction f) {
        IntSet result = f.getTargets(d1);
        if (result == null) {
            return null;
        }
        return result;
    }

    protected IntSet computeInverseFlow(int d2, IReversibleFlowFunction f) {
        return f.getSources(d2);
    }

    protected PathEdge<T> popFromWorkList() {
        assert (this.worklist != null);
        return this.worklist.take();
    }

    private PathEdge peekFromWorkList() {
        assert (this.worklist != null);
        PathEdge<T> result = this.worklist.take();
        this.worklist.insert(result);
        return result;
    }

    protected boolean propagate(T s_p, int i, T n, int j) {
        int number = this.supergraph.getLocalBlockNumber(n);
        if (number < 0) {
            System.err.println("BOOM " + n);
            this.supergraph.getLocalBlockNumber(n);
        }
        assert (number >= 0);
        LocalPathEdges pLocal = this.findOrCreateLocalPathEdges(s_p);
        assert (j >= 0);
        if (!pLocal.contains(i, number, j)) {
            pLocal.addPathEdge(i, number, j);
            this.addToWorkList(s_p, i, n, j);
            return true;
        }
        return false;
    }

    public LocalPathEdges getLocalPathEdges(T s_p) {
        return this.pathEdges.get(s_p);
    }

    private int merge(T s_p, int i, T n, int j) {
        assert (j >= 0);
        IMergeFunction alpha = this.problem.getMergeFunction();
        if (alpha != null) {
            LocalPathEdges lp = this.pathEdges.get(s_p);
            IntSet preExistFacts = lp.getReachable(this.supergraph.getLocalBlockNumber(n), i);
            if (preExistFacts == null) {
                return j;
            }
            int size = preExistFacts.size();
            if (size == 0 || size == 1 && preExistFacts.contains(j)) {
                return j;
            }
            int result = alpha.merge(preExistFacts, j);
            return result;
        }
        return j;
    }

    protected void addToWorkList(T s_p, int i, T n, int j) {
        if (this.worklist == null) {
            this.worklist = this.makeWorklist();
        }
        this.worklist.insert(PathEdge.createPathEdge(s_p, i, n, j));
    }

    protected LocalPathEdges findOrCreateLocalPathEdges(T s_p) {
        LocalPathEdges result = this.pathEdges.get(s_p);
        if (result == null) {
            result = this.makeLocalPathEdges();
            this.pathEdges.put(s_p, result);
        }
        return result;
    }

    private LocalPathEdges makeLocalPathEdges() {
        return this.problem.getMergeFunction() == null ? new LocalPathEdges(false) : new LocalPathEdges(true);
    }

    protected LocalSummaryEdges findOrCreateLocalSummaryEdges(P proc) {
        LocalSummaryEdges result = this.summaryEdges.get(proc);
        if (result == null) {
            result = new LocalSummaryEdges();
            this.summaryEdges.put(proc, result);
        }
        return result;
    }

    protected CallFlowEdges findOrCreateCallFlowEdges(T s_p) {
        CallFlowEdges result = this.callFlowEdges.get(s_p);
        if (result == null) {
            result = new CallFlowEdges();
            this.callFlowEdges.put(s_p, result);
        }
        return result;
    }

    public IntSet getResult(T node) {
        P proc = this.supergraph.getProcOf(node);
        int n = this.supergraph.getLocalBlockNumber(node);
        T[] entries = this.supergraph.getEntriesForProcedure(proc);
        MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
        HashSet<Object> allEntries = HashSetFactory.make(Arrays.asList(entries));
        Set<PathEdge<T>> pSeeds = this.seeds.get(proc);
        if (pSeeds != null) {
            for (PathEdge<Object> pathEdge : pSeeds) {
                allEntries.add(pathEdge.entry);
            }
        }
        for (Object object : allEntries) {
            LocalPathEdges lp = this.pathEdges.get(object);
            if (lp == null) continue;
            result.addAll(lp.getReachable(n));
        }
        return result;
    }

    public ISupergraph<T, P> getSupergraph() {
        return this.supergraph;
    }

    public IntSet getSummarySources(T n2, int d2, T n1) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("not currently supported.  be careful");
    }

    public TabulationProblem<T, P, F> getProblem() {
        return this.problem;
    }

    public Collection<PathEdge<T>> getSeeds() {
        return Collections.unmodifiableCollection(this.allSeeds);
    }

    public MonitorUtil.IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    protected PathEdge<T> getCurPathEdge() {
        return this.curPathEdge;
    }

    protected PathEdge<T> getCurSummaryEdge() {
        return this.curSummaryEdge;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Result
    implements TabulationResult<T, P, F> {
        @Override
        public IntSet getResult(T node) {
            return TabulationSolver.this.getResult(node);
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            TreeMap map = new TreeMap(ToStringComparator.instance());
            Comparator<Object> c = new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (!(o1 instanceof IBasicBlock)) {
                        return -1;
                    }
                    IBasicBlock bb1 = (IBasicBlock)o1;
                    IBasicBlock bb2 = (IBasicBlock)o2;
                    return bb1.getNumber() - bb2.getNumber();
                }
            };
            for (Object t : TabulationSolver.this.supergraph) {
                Object proc = TabulationSolver.this.supergraph.getProcOf(t);
                TreeSet<Object> s = (TreeSet<Object>)map.get(proc);
                if (s == null) {
                    s = new TreeSet<Object>(c);
                    map.put(proc, s);
                }
                s.add(t);
            }
            for (Map.Entry entry : map.entrySet()) {
                Set s = (Set)entry.getValue();
                for (Object o : s) {
                    result.append(o + " : " + this.getResult(o) + "\n");
                }
            }
            return result.toString();
        }

        @Override
        public TabulationProblem<T, P, F> getProblem() {
            return TabulationSolver.this.problem;
        }

        @Override
        public Collection<T> getSupergraphNodesReached() {
            HashSet result = HashSetFactory.make();
            for (Map.Entry e : TabulationSolver.this.pathEdges.entrySet()) {
                Object key = e.getKey();
                Object proc = TabulationSolver.this.supergraph.getProcOf(key);
                IntSet reached = ((LocalPathEdges)e.getValue()).getReachedNodeNumbers();
                IntIterator ii = reached.intIterator();
                while (ii.hasNext()) {
                    result.add(TabulationSolver.this.supergraph.getLocalBlock(proc, ii.next()));
                }
            }
            return result;
        }

        @Override
        public IntSet getSummaryTargets(T n1, int d1, T n2) {
            LocalSummaryEdges summaries = TabulationSolver.this.summaryEdges.get(TabulationSolver.this.supergraph.getProcOf(n1));
            if (summaries == null) {
                return null;
            }
            int num1 = TabulationSolver.this.supergraph.getLocalBlockNumber(n1);
            int num2 = TabulationSolver.this.supergraph.getLocalBlockNumber(n2);
            return summaries.getSummaryEdges(num1, num2, d1);
        }

        @Override
        public Collection<PathEdge<T>> getSeeds() {
            return TabulationSolver.this.getSeeds();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Worklist
    extends Heap<PathEdge<T>>
    implements ITabulationWorklist<T> {
        Worklist() {
            super(100);
        }

        @Override
        protected boolean compareElements(PathEdge<T> p1, PathEdge<T> p2) {
            return TabulationSolver.this.problem.getDomain().hasPriorityOver(p1, p2);
        }
    }
}

