/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.dataflow.IFDS.IFlowFunction;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.dataflow.IFDS.PartiallyBalancedTabulationProblem;
import com.ibm.wala.dataflow.IFDS.PathEdge;
import com.ibm.wala.dataflow.IFDS.TabulationSolver;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartiallyBalancedTabulationSolver<T, P, F>
extends TabulationSolver<T, P, F> {
    private final Collection<Pair<T, Integer>> unbalancedSeeds = HashSetFactory.make();

    public static <T, P, F> PartiallyBalancedTabulationSolver<T, P, F> createPartiallyBalancedTabulationSolver(PartiallyBalancedTabulationProblem<T, P, F> p, MonitorUtil.IProgressMonitor monitor) {
        return new PartiallyBalancedTabulationSolver<T, P, F>(p, monitor);
    }

    protected PartiallyBalancedTabulationSolver(PartiallyBalancedTabulationProblem<T, P, F> p, MonitorUtil.IProgressMonitor monitor) {
        super(p, monitor);
    }

    @Override
    protected boolean propagate(T s_p, int i, T n, int j) {
        boolean result = super.propagate(s_p, i, n, j);
        if (result && this.wasUsedAsUnbalancedSeed(s_p, i) && this.supergraph.isExit(n)) {
            Iterator<T> it2 = this.supergraph.getSuccNodes(n);
            while (it2.hasNext()) {
                T retSite = it2.next();
                PartiallyBalancedTabulationProblem problem = (PartiallyBalancedTabulationProblem)this.getProblem();
                IFlowFunction f = problem.getFunctionMap().getUnbalancedReturnFlowFunction(n, retSite);
                if (f instanceof IUnaryFlowFunction) {
                    IUnaryFlowFunction uf = (IUnaryFlowFunction)f;
                    IntSet facts = uf.getTargets(j);
                    if (facts == null) continue;
                    IntIterator it4 = facts.intIterator();
                    while (it4.hasNext()) {
                        int d3 = it4.next();
                        T fakeEntry = problem.getFakeEntry(retSite);
                        PathEdge<T> seed = PathEdge.createPathEdge(fakeEntry, d3, retSite, d3);
                        this.addSeed(seed);
                    }
                    continue;
                }
                Assertions.UNREACHABLE("Partially balanced logic not supported for binary return flow functions");
            }
        }
        return result;
    }

    @Override
    public void addSeed(PathEdge<T> seed) {
        if (this.getSeeds().contains(seed)) {
            return;
        }
        this.unbalancedSeeds.add(Pair.make(seed.entry, seed.d1));
        super.addSeed(seed);
    }

    private boolean wasUsedAsUnbalancedSeed(T s_p, int i) {
        return this.unbalancedSeeds.contains(Pair.make(s_p, i));
    }
}

