/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.util;

import com.ibm.wala.util.warnings.Warnings;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.JUnitCore;

public abstract class WalaTestCase {
    private static final boolean ANALYZE_LEAKS = false;

    public static boolean useShortProfile() {
        String profile = System.getProperty("com.ibm.wala.junit.profile", "long");
        return profile.equals("short");
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        Warnings.clear();
    }

    protected static void justThisTest(Class<?> testClass) {
        JUnitCore.runClasses((Class[])new Class[]{testClass});
    }

    protected static void assertBound(String tag, double quantity, double bound) {
        String msg = String.valueOf(tag) + ", quantity: " + quantity + ", bound:" + bound;
        System.err.println(msg);
        Assert.assertTrue((String)msg, (quantity <= bound ? 1 : 0) != 0);
    }

    protected static void assertBound(String tag, int quantity, int bound) {
        String msg = String.valueOf(tag) + ", quantity: " + quantity + ", bound:" + bound;
        System.err.println(msg);
        Assert.assertTrue((String)msg, (quantity <= bound ? 1 : 0) != 0);
    }
}

