/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.typeInference;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.ClassLoaderFactoryImpl;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import com.ibm.wala.util.strings.UTF8Convert;
import com.ibm.wala.util.warnings.Warnings;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TypeInferenceTest
extends WalaTestCase {
    private static final ClassLoader MY_CLASSLOADER = TypeInferenceTest.class.getClassLoader();
    private static AnalysisScope scope;
    private static ClassHierarchy cha;
    private static AnalysisOptions options;
    private static AnalysisCache cache;

    public static void main(String[] args) {
        TypeInferenceTest.justThisTest(TypeInferenceTest.class);
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        scope = AnalysisScopeReader.readJavaScope("wala.testdata.txt", new FileProvider().getFile("J2SEClassHierarchyExclusions.txt"), MY_CLASSLOADER);
        options = new AnalysisOptions(scope, null);
        cache = new AnalysisCache();
        ClassLoaderFactoryImpl factory = new ClassLoaderFactoryImpl(scope.getExclusions());
        try {
            cha = ClassHierarchy.make(scope, factory);
        }
        catch (ClassHierarchyException e) {
            throw new Exception();
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        Warnings.clear();
        scope = null;
        cha = null;
        options = null;
        cache = null;
    }

    @Test
    public void test1() {
        MethodReference method = scope.findMethod(AnalysisScope.APPLICATION, "LtypeInference/TI", Atom.findOrCreateUnicodeAtom("foo"), new ImmutableByteArray(UTF8Convert.toUTF8("()V")));
        Assert.assertNotNull((String)"method not found", (Object)method);
        IMethod imethod = cha.resolveMethod(method);
        Assert.assertNotNull((String)"imethod not found", (Object)imethod);
        IR ir = cache.getIRFactory().makeIR(imethod, Everywhere.EVERYWHERE, options.getSSAOptions());
        System.out.println(ir);
        TypeInference ti = TypeInference.make(ir, false);
        int i = 1;
        while (i <= ir.getSymbolTable().getMaxValueNumber()) {
            System.err.println(String.valueOf(i) + " " + ti.getType(i));
            ++i;
        }
    }

    @Test
    public void test2() {
        MethodReference method = scope.findMethod(AnalysisScope.APPLICATION, "LtypeInference/TI", Atom.findOrCreateUnicodeAtom("bar"), new ImmutableByteArray(UTF8Convert.toUTF8("(I)V")));
        Assert.assertNotNull((String)"method not found", (Object)method);
        IMethod imethod = cha.resolveMethod(method);
        Assert.assertNotNull((String)"imethod not found", (Object)imethod);
        IR ir = cache.getIRFactory().makeIR(imethod, Everywhere.EVERYWHERE, options.getSSAOptions());
        System.out.println(ir);
        TypeInference ti = TypeInference.make(ir, true);
        Assert.assertNotNull((String)"null type abstraction for parameter", (Object)ti.getType(2));
    }

    @Test
    public void test3() {
        MethodReference method = scope.findMethod(AnalysisScope.APPLICATION, "LtypeInference/TI", Atom.findOrCreateUnicodeAtom("inferInt"), new ImmutableByteArray(UTF8Convert.toUTF8("()V")));
        Assert.assertNotNull((String)"method not found", (Object)method);
        IMethod imethod = cha.resolveMethod(method);
        Assert.assertNotNull((String)"imethod not found", (Object)imethod);
        IR ir = cache.getIRFactory().makeIR(imethod, Everywhere.EVERYWHERE, options.getSSAOptions());
        System.out.println(ir);
        TypeInference ti = TypeInference.make(ir, true);
        TypeAbstraction type = ti.getType(7);
        Assert.assertNotNull((String)"null type abstraction", (Object)type);
        Assert.assertTrue((String)"inferred wrong type", (boolean)type.toString().equals("int"));
    }

    @Test
    public void test4() {
        MethodReference method = scope.findMethod(AnalysisScope.APPLICATION, "LtypeInference/TI", Atom.findOrCreateUnicodeAtom("useCast"), new ImmutableByteArray(UTF8Convert.toUTF8("(Ljava/lang/Object;)V")));
        Assert.assertNotNull((String)"method not found", (Object)method);
        IMethod imethod = cha.resolveMethod(method);
        Assert.assertNotNull((String)"imethod not found", (Object)imethod);
        IR ir = cache.getIRFactory().makeIR(imethod, Everywhere.EVERYWHERE, options.getSSAOptions());
        System.out.println(ir);
        TypeInference ti = TypeInference.make(ir, false);
        TypeAbstraction type = ti.getType(4);
        Assert.assertNotNull((String)"null type abstraction", (Object)type);
        Assert.assertTrue((String)("inferred wrong type " + type), (type instanceof ConeType && ((ConeType)type).getTypeReference().getName().toString().equals("Ljava/lang/String") ? 1 : 0) != 0);
    }
}

