/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.slicer;

import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.examples.drivers.PDFSlice;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.PartialCallGraph;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.slicer.MethodEntryStatement;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.SDG;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ipa.slicer.thin.ThinSlicer;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.GraphIntegrity;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.strings.Atom;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class SlicerTest {
    private static AnalysisScope cachedScope;
    private static IClassHierarchy cachedCHA;

    private static AnalysisScope findOrCreateAnalysisScope() throws IOException {
        if (cachedScope == null) {
            cachedScope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", "Java60RegressionExclusions.txt");
        }
        return cachedScope;
    }

    private static IClassHierarchy findOrCreateCHA(AnalysisScope scope) throws ClassHierarchyException {
        if (cachedCHA == null) {
            cachedCHA = ClassHierarchy.make(scope);
        }
        return cachedCHA;
    }

    @AfterClass
    public static void afterClass() {
        cachedCHA = null;
        cachedScope = null;
    }

    @Test
    public void testSlice1() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        Collection<Statement> computeBackwardSlice;
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/Slice1");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findCallTo(main, "println");
        System.err.println("Statement: " + s);
        Collection<Statement> slice = computeBackwardSlice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
        int i = 0;
        for (Statement st : slice) {
            if (!st.getNode().getMethod().getDeclaringClass().getClassLoader().getReference().equals(ClassLoaderReference.Application)) continue;
            ++i;
        }
        Assert.assertEquals((long)16L, (long)i);
    }

    @Test
    public void testSlice2() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        Collection<Statement> computeBackwardSlice;
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/Slice2");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMethod(cg, "baz");
        Statement s = SlicerTest.findCallTo(main, "println");
        System.err.println("Statement: " + s);
        Collection<Statement> slice = computeBackwardSlice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)9L, (long)SlicerTest.countNormals(slice));
    }

    @Test
    public void testSlice3() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/Slice3");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMethod(cg, "main");
        Statement s = SlicerTest.findCallTo(main, "doNothing");
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)1L, (long)SlicerTest.countAllocations(slice));
    }

    @Test
    public void testSlice4() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/Slice4");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findCallTo(main, "foo");
        s = PDFSlice.getReturnStatementForCall(s);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeForwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)4L, (long)slice.size());
    }

    @Test
    public void testSlice5() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/Slice5");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode n = SlicerTest.findMethod(cg, "baz");
        Statement s = SlicerTest.findCallTo(n, "foo");
        s = PDFSlice.getReturnStatementForCall(s);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeForwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)7L, (long)slice.size());
    }

    @Test
    public void testSlice7() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/Slice7");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneContainerCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findFirstAllocation(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeForwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
    }

    @Test
    public void testSlice8() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/Slice8");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeVanillaZeroOneContainerCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode process = SlicerTest.findMethod(cg, Descriptor.findOrCreateUTF8("()V"), Atom.findOrCreateUnicodeAtom("process"));
        Statement s = SlicerTest.findCallToDoNothing(process);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NO_EXCEPTIONAL_EDGES);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)4L, (long)SlicerTest.countInvokes(slice));
        slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        Assert.assertEquals((long)4L, (long)slice.size());
    }

    @Test
    public void testTestCD1() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestCD1");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findCallToDoNothing(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.NONE, Slicer.ControlDependenceOptions.FULL);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)2L, (long)SlicerTest.countConditionals(slice));
    }

    @Test
    public void testTestCD2() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestCD2");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findCallToDoNothing(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.NONE, Slicer.ControlDependenceOptions.FULL);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)1L, (long)SlicerTest.countConditionals(slice));
    }

    @Test
    public void testTestCD3() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestCD3");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findCallToDoNothing(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.NONE, Slicer.ControlDependenceOptions.FULL);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)0L, (long)SlicerTest.countConditionals(slice));
    }

    @Test
    public void testTestCD4() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestCD4");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findCallToDoNothing(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.NONE, Slicer.ControlDependenceOptions.FULL);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)0L, (long)SlicerTest.countConditionals(slice));
        slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.FULL);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)1L, (long)SlicerTest.countConditionals(slice));
    }

    @Test
    public void testTestCD5() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestCD5");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        MethodEntryStatement s = new MethodEntryStatement(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeForwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.NONE, Slicer.ControlDependenceOptions.NO_EXCEPTIONAL_EDGES);
        SlicerTest.dumpSlice(slice);
        Assert.assertTrue((slice.size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testTestCD6() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestCD6");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        MethodEntryStatement s = new MethodEntryStatement(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeForwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.NONE, Slicer.ControlDependenceOptions.NO_EXCEPTIONAL_EDGES);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)2L, (long)SlicerTest.countInvokes(slice));
    }

    @Test
    public void testTestId() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestId");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findCallToDoNothing(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)1L, (long)SlicerTest.countAllocations(slice));
    }

    @Test
    public void testTestArrays() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestArrays");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findCallToDoNothing(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)2L, (long)SlicerTest.countAllocations(slice));
        Assert.assertEquals((long)1L, (long)SlicerTest.countAloads(slice));
    }

    @Test
    public void testTestFields() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestFields");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findCallToDoNothing(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)2L, (long)SlicerTest.countAllocations(slice));
        Assert.assertEquals((long)1L, (long)SlicerTest.countPutfields(slice));
    }

    @Test
    public void testThin1() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        Collection<Statement> computeBackwardSlice;
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestThin1");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findCallToDoNothing(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)3L, (long)SlicerTest.countAllocations(slice));
        Assert.assertEquals((long)2L, (long)SlicerTest.countPutfields(slice));
        slice = computeBackwardSlice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.NO_BASE_PTRS, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)2L, (long)SlicerTest.countAllocations(slice));
        Assert.assertEquals((long)1L, (long)SlicerTest.countPutfields(slice));
    }

    @Test
    public void testTestGlobal() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestGlobal");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findCallToDoNothing(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)1L, (long)SlicerTest.countAllocations(slice));
        Assert.assertEquals((long)2L, (long)SlicerTest.countPutstatics(slice));
        Assert.assertEquals((long)2L, (long)SlicerTest.countGetstatics(slice));
    }

    @Test
    public void testTestMultiTarget() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestMultiTarget");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findCallToDoNothing(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)2L, (long)SlicerTest.countAllocations(slice));
    }

    @Test
    public void testTestRecursion() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestRecursion");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findCallToDoNothing(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)3L, (long)SlicerTest.countAllocations(slice));
        Assert.assertEquals((long)2L, (long)SlicerTest.countPutfields(slice));
    }

    @Test
    public void testPrimGetterSetter() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestPrimGetterSetter");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode test = SlicerTest.findMethod(cg, "test");
        PartialCallGraph pcg = PartialCallGraph.make(cg, Collections.singleton(test));
        Statement s = SlicerTest.findCallToDoNothing(test);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, pcg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.FULL);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)0L, (long)SlicerTest.countAllocations(slice));
        Assert.assertEquals((long)1L, (long)SlicerTest.countPutfields(slice));
    }

    @Test
    public void testTestThrowCatch() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestThrowCatch");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        Statement s = SlicerTest.findCallToDoNothing(main);
        System.err.println("Statement: " + s);
        Collection<Statement> slice = Slicer.computeBackwardSlice(s, cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        SlicerTest.dumpSlice(slice);
        Assert.assertEquals((long)1L, (long)SlicerTest.countAllocations(slice));
        Assert.assertEquals((long)1L, (long)SlicerTest.countThrows(slice));
        Assert.assertEquals((long)1L, (long)SlicerTest.countGetfields(slice));
    }

    @Test
    public void testTestMessageFormat() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestMessageFormat");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        CGNode main = SlicerTest.findMainMethod(cg);
        NormalStatement seed = new NormalStatement(main, 2);
        System.err.println("Statement: " + seed);
        ThinSlicer ts = new ThinSlicer(cg, builder.getPointerAnalysis());
        Collection<Statement> slice = ts.computeBackwardThinSlice(seed);
        SlicerTest.dumpSlice(slice);
    }

    @Test
    public void testTestInetAddr() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException, GraphIntegrity.UnsoundGraphException {
        AnalysisScope scope = SlicerTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = SlicerTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lslice/TestInetAddr");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        SDG sdg = new SDG(cg, builder.getPointerAnalysis(), Slicer.DataDependenceOptions.NO_BASE_NO_HEAP, Slicer.ControlDependenceOptions.FULL);
        GraphIntegrity.check(sdg);
    }

    public static int countAllocations(Collection<Statement> slice) {
        int count = 0;
        for (Statement s : slice) {
            NormalStatement ns;
            if (!s.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s).getInstruction() instanceof SSANewInstruction)) continue;
            ++count;
        }
        return count;
    }

    public static int countThrows(Collection<Statement> slice) {
        int count = 0;
        for (Statement s : slice) {
            NormalStatement ns;
            if (!s.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s).getInstruction() instanceof SSAAbstractThrowInstruction)) continue;
            ++count;
        }
        return count;
    }

    public static int countAloads(Collection<Statement> slice) {
        int count = 0;
        for (Statement s : slice) {
            NormalStatement ns;
            if (!s.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s).getInstruction() instanceof SSAArrayLoadInstruction)) continue;
            ++count;
        }
        return count;
    }

    public static int countNormals(Collection<Statement> slice) {
        int count = 0;
        for (Statement s : slice) {
            if (!s.getKind().equals((Object)Statement.Kind.NORMAL)) continue;
            ++count;
        }
        return count;
    }

    public static int countConditionals(Collection<Statement> slice) {
        int count = 0;
        for (Statement s : slice) {
            NormalStatement ns;
            if (!s.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s).getInstruction() instanceof SSAConditionalBranchInstruction)) continue;
            ++count;
        }
        return count;
    }

    public static int countInvokes(Collection<Statement> slice) {
        int count = 0;
        for (Statement s : slice) {
            NormalStatement ns;
            if (!s.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s).getInstruction() instanceof SSAAbstractInvokeInstruction)) continue;
            ++count;
        }
        return count;
    }

    public static int countPutfields(Collection<Statement> slice) {
        int count = 0;
        for (Statement s : slice) {
            SSAPutInstruction p;
            NormalStatement ns;
            if (!s.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s).getInstruction() instanceof SSAPutInstruction) || (p = (SSAPutInstruction)ns.getInstruction()).isStatic()) continue;
            ++count;
        }
        return count;
    }

    public static int countGetfields(Collection<Statement> slice) {
        int count = 0;
        for (Statement s : slice) {
            SSAGetInstruction p;
            NormalStatement ns;
            if (!s.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s).getInstruction() instanceof SSAGetInstruction) || (p = (SSAGetInstruction)ns.getInstruction()).isStatic()) continue;
            ++count;
        }
        return count;
    }

    public static int countPutstatics(Collection<Statement> slice) {
        int count = 0;
        for (Statement s : slice) {
            SSAPutInstruction p;
            NormalStatement ns;
            if (!s.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s).getInstruction() instanceof SSAPutInstruction) || !(p = (SSAPutInstruction)ns.getInstruction()).isStatic()) continue;
            ++count;
        }
        return count;
    }

    public static int countGetstatics(Collection<Statement> slice) {
        int count = 0;
        for (Statement s : slice) {
            SSAGetInstruction p;
            NormalStatement ns;
            if (!s.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s).getInstruction() instanceof SSAGetInstruction) || !(p = (SSAGetInstruction)ns.getInstruction()).isStatic()) continue;
            ++count;
        }
        return count;
    }

    public static void dumpSlice(Collection<Statement> slice) {
        SlicerTest.dumpSlice(slice, new PrintWriter(System.err));
    }

    public static void dumpSlice(Collection<Statement> slice, PrintWriter w) {
        w.println("SLICE:\n");
        int i = 1;
        for (Statement s : slice) {
            String line = String.valueOf(i++) + "   " + s;
            w.println(line);
            w.flush();
        }
    }

    public static void dumpSliceToFile(Collection<Statement> slice, String fileName) throws FileNotFoundException {
        File f = new File(fileName);
        FileOutputStream fo = new FileOutputStream(f);
        PrintWriter w = new PrintWriter(fo);
        SlicerTest.dumpSlice(slice, w);
    }

    public static CGNode findMainMethod(CallGraph cg) {
        Descriptor d = Descriptor.findOrCreateUTF8("([Ljava/lang/String;)V");
        Atom name = Atom.findOrCreateUnicodeAtom("main");
        return SlicerTest.findMethod(cg, d, name);
    }

    private static CGNode findMethod(CallGraph cg, Descriptor d, Atom name) {
        Iterator<CGNode> it = cg.getSuccNodes(cg.getFakeRootNode());
        while (it.hasNext()) {
            CGNode n = it.next();
            if (!n.getMethod().getName().equals(name) || !n.getMethod().getDescriptor().equals(d)) continue;
            return n;
        }
        for (CGNode n : cg) {
            if (!n.getMethod().getName().equals(name) || !n.getMethod().getDescriptor().equals(d)) continue;
            return n;
        }
        Assertions.UNREACHABLE("failed to find method " + name);
        return null;
    }

    public static CGNode findMethod(CallGraph cg, String name) {
        Atom a = Atom.findOrCreateUnicodeAtom(name);
        for (CGNode n : cg) {
            if (!n.getMethod().getName().equals(a)) continue;
            return n;
        }
        System.err.println("call graph " + cg);
        Assertions.UNREACHABLE("failed to find method " + name);
        return null;
    }

    public static Statement findCallTo(CGNode n, String methodName) {
        IR ir = n.getIR();
        Iterator<SSAInstruction> it = ir.iterateAllInstructions();
        while (it.hasNext()) {
            SSAInvokeInstruction call;
            SSAInstruction s = it.next();
            if (!(s instanceof SSAInvokeInstruction) || !(call = (SSAInvokeInstruction)s).getCallSite().getDeclaredTarget().getName().toString().equals(methodName)) continue;
            IntSet indices = ir.getCallInstructionIndices(((SSAInvokeInstruction)s).getCallSite());
            Assertions.productionAssertion(indices.size() == 1, "expected 1 but got " + indices.size());
            return new NormalStatement(n, indices.intIterator().next());
        }
        Assertions.UNREACHABLE("failed to find call to " + methodName + " in " + n);
        return null;
    }

    public static Statement findFirstAllocation(CGNode n) {
        IR ir = n.getIR();
        int i = 0;
        while (i < ir.getInstructions().length) {
            SSAInstruction s = ir.getInstructions()[i];
            if (s instanceof SSANewInstruction) {
                return new NormalStatement(n, i);
            }
            ++i;
        }
        Assertions.UNREACHABLE("failed to find allocation in " + n);
        return null;
    }

    private static Statement findCallToDoNothing(CGNode n) {
        return SlicerTest.findCallTo(n, "doNothing");
    }
}

