/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.ptrs;

import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.intset.OrdinalSet;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class ZeroLengthArrayTest {
    @Test
    public void testZeroLengthArray() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, "LarrayAlias/TestZeroLengthArray");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeVanillaZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        PointerAnalysis pa = builder.getPointerAnalysis();
        HeapModel heapModel = pa.getHeapModel();
        CGNode mainNode = cg.getNode(cha.resolveMethod(MethodReference.findOrCreate(TypeReference.findOrCreate(ClassLoaderReference.Application, "LarrayAlias/TestZeroLengthArray"), Selector.make("main([Ljava/lang/String;)V"))), Everywhere.EVERYWHERE);
        OrdinalSet<InstanceKey> pointsToSet = pa.getPointsToSet(heapModel.getPointerKeyForLocal(mainNode, 4));
        Assert.assertEquals((int)1, (int)pointsToSet.size());
        InstanceKey arrayKey = pointsToSet.iterator().next();
        OrdinalSet<InstanceKey> arrayContents = pa.getPointsToSet(heapModel.getPointerKeyForArrayContents(arrayKey));
        System.err.println(arrayContents);
        Assert.assertEquals((int)0, (int)arrayContents.size());
    }
}

