/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.ptrs;

import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.OrdinalSet;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class TypeBasedArrayAliasTest
extends WalaTestCase {
    @Test
    public void testTypeBasedArrayAlias() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, "LarrayAlias/TestArrayAlias");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraphBuilder builder = Util.makeRTABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        PointerAnalysis pa = builder.getPointerAnalysis();
        CGNode node = TypeBasedArrayAliasTest.findNode(cg, "testMayAlias1");
        PointerKey pk1 = pa.getHeapModel().getPointerKeyForLocal(node, 1);
        PointerKey pk2 = pa.getHeapModel().getPointerKeyForLocal(node, 2);
        Assert.assertTrue((boolean)TypeBasedArrayAliasTest.mayAliased(pk1, pk2, pa));
        node = TypeBasedArrayAliasTest.findNode(cg, "testMayAlias2");
        pk1 = pa.getHeapModel().getPointerKeyForLocal(node, 1);
        pk2 = pa.getHeapModel().getPointerKeyForLocal(node, 2);
        Assert.assertTrue((boolean)TypeBasedArrayAliasTest.mayAliased(pk1, pk2, pa));
        node = TypeBasedArrayAliasTest.findNode(cg, "testMayAlias3");
        pk1 = pa.getHeapModel().getPointerKeyForLocal(node, 1);
        pk2 = pa.getHeapModel().getPointerKeyForLocal(node, 2);
        Assert.assertTrue((boolean)TypeBasedArrayAliasTest.mayAliased(pk1, pk2, pa));
    }

    private static final CGNode findNode(CallGraph cg, String methodName) {
        for (CGNode n : cg) {
            if (!n.getMethod().getName().toString().equals(methodName)) continue;
            return n;
        }
        Assertions.UNREACHABLE("Unexpected: failed to find " + methodName + " node");
        return null;
    }

    private static boolean mayAliased(PointerKey pk1, PointerKey pk2, PointerAnalysis pa) {
        OrdinalSet<InstanceKey> ptsTo1 = pa.getPointsToSet(pk1);
        OrdinalSet<InstanceKey> ptsTo2 = pa.getPointsToSet(pk2);
        boolean foundIntersection = false;
        block0: for (InstanceKey i : ptsTo1) {
            for (InstanceKey j : ptsTo2) {
                if (!i.equals(j)) continue;
                foundIntersection = true;
                break block0;
            }
        }
        return foundIntersection;
    }
}

