/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.ptrs;

import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.OrdinalSet;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class MultiDimArrayTest
extends WalaTestCase {
    public static void main(String[] args) {
        MultiDimArrayTest.justThisTest(MultiDimArrayTest.class);
    }

    @Test
    public void testMultiDim() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, "LmultiDim/TestMultiDim");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeVanillaZeroOneCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        PointerAnalysis pa = builder.getPointerAnalysis();
        System.err.println(pa);
        CGNode node = MultiDimArrayTest.findDoNothingNode(cg);
        PointerKey pk = pa.getHeapModel().getPointerKeyForLocal(node, 1);
        OrdinalSet<InstanceKey> ptsTo = pa.getPointsToSet(pk);
        Assert.assertEquals((long)1L, (long)ptsTo.size());
    }

    private static final CGNode findDoNothingNode(CallGraph cg) {
        for (CGNode n : cg) {
            if (!n.getMethod().getName().toString().equals("doNothing")) continue;
            return n;
        }
        Assertions.UNREACHABLE("Unexpected: failed to find doNothing node");
        return null;
    }
}

