/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.ir;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.io.FileProvider;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class MultiNewArrayTest
extends WalaTestCase {
    private static final ClassLoader MY_CLASSLOADER = MultiNewArrayTest.class.getClassLoader();

    @Test
    public void testMultiNewArray1() throws IOException, ClassHierarchyException {
        SSAInstruction[] instructions;
        AnalysisScope scope = null;
        scope = AnalysisScopeReader.readJavaScope("wala.testdata.txt", new FileProvider().getFile("J2SEClassHierarchyExclusions.txt"), MY_CLASSLOADER);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        IClass klass = cha.lookupClass(TypeReference.findOrCreate(ClassLoaderReference.Application, "LmultiDim/TestMultiDim"));
        Assert.assertTrue((klass != null ? 1 : 0) != 0);
        IMethod m = klass.getMethod(Selector.make(Language.JAVA, "testNewMultiArray()V"));
        Assert.assertTrue((m != null ? 1 : 0) != 0);
        AnalysisCache cache = new AnalysisCache();
        IR ir = cache.getIRFactory().makeIR(m, Everywhere.EVERYWHERE, new SSAOptions());
        Assert.assertTrue((ir != null ? 1 : 0) != 0);
        SSAInstruction[] sSAInstructionArray = instructions = ir.getInstructions();
        int n = instructions.length;
        int n2 = 0;
        while (n2 < n) {
            SSAInstruction instr = sSAInstructionArray[n2];
            if (instr instanceof SSANewInstruction) {
                System.err.println(instr.toString(ir.getSymbolTable()));
                Assert.assertTrue((instr.getNumberOfUses() == 2 ? 1 : 0) != 0);
                Assert.assertTrue((ir.getSymbolTable().getIntValue(instr.getUse(0)) == 3 ? 1 : 0) != 0);
                Assert.assertTrue((ir.getSymbolTable().getIntValue(instr.getUse(1)) == 4 ? 1 : 0) != 0);
            }
            ++n2;
        }
    }
}

