/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.ir;

import com.ibm.wala.classLoader.ClassLoaderFactoryImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPiNodePolicy;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import com.ibm.wala.util.strings.UTF8Convert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LocalNamesTest
extends WalaTestCase {
    private static final ClassLoader MY_CLASSLOADER = LocalNamesTest.class.getClassLoader();
    private static AnalysisScope scope;
    private static ClassHierarchy cha;
    private static AnalysisOptions options;
    private static AnalysisCache cache;

    public static void main(String[] args) {
        LocalNamesTest.justThisTest(LocalNamesTest.class);
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        scope = AnalysisScopeReader.readJavaScope("wala.testdata.txt", new FileProvider().getFile("J2SEClassHierarchyExclusions.txt"), MY_CLASSLOADER);
        options = new AnalysisOptions(scope, null);
        cache = new AnalysisCache();
        ClassLoaderFactoryImpl factory = new ClassLoaderFactoryImpl(scope.getExclusions());
        try {
            cha = ClassHierarchy.make(scope, factory);
        }
        catch (ClassHierarchyException e) {
            throw new Exception();
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        scope = null;
        cha = null;
        options = null;
        cache = null;
    }

    @Test
    public void testAliasNames() {
        try {
            AnalysisScope scope = AnalysisScopeReader.readJavaScope("wala.testdata.txt", new FileProvider().getFile("J2SEClassHierarchyExclusions.txt"), MY_CLASSLOADER);
            ClassHierarchy cha = ClassHierarchy.make(scope);
            TypeReference t = TypeReference.findOrCreateClass(scope.getApplicationLoader(), "cornerCases", "AliasNames");
            IClass klass = cha.lookupClass(t);
            Assert.assertTrue((klass != null ? 1 : 0) != 0);
            IMethod m = klass.getMethod(new Selector(Atom.findOrCreateAsciiAtom("foo"), Descriptor.findOrCreateUTF8("([Ljava/lang/String;)V")));
            AnalysisOptions options = new AnalysisOptions();
            options.getSSAOptions().setPiNodePolicy(SSAOptions.getAllBuiltInPiNodes());
            IR ir = cache.getSSACache().findOrCreateIR(m, Everywhere.EVERYWHERE, options.getSSAOptions());
            int offsetIndex = 0;
            while (offsetIndex < ir.getInstructions().length) {
                String[] localNames;
                SSAInstruction instr = ir.getInstructions()[offsetIndex];
                if (instr != null && (localNames = ir.getLocalNames(offsetIndex, instr.getDef())) != null && localNames.length > 0 && localNames[0] == null) {
                    System.err.println(ir);
                    Assert.assertTrue((String)(" getLocalNames() returned [null,...] for the def of instruction at offset " + offsetIndex + "\n\tinstr"), (boolean)false);
                }
                ++offsetIndex;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    @Test
    public void testLocalNamesWithoutPiNodes() {
        SSAPiNodePolicy save = options.getSSAOptions().getPiNodePolicy();
        options.getSSAOptions().setPiNodePolicy(null);
        MethodReference mref = scope.findMethod(AnalysisScope.APPLICATION, "LcornerCases/Locals", Atom.findOrCreateUnicodeAtom("foo"), new ImmutableByteArray(UTF8Convert.toUTF8("([Ljava/lang/String;)V")));
        Assert.assertNotNull((String)"method not found", (Object)mref);
        IMethod imethod = cha.resolveMethod(mref);
        Assert.assertNotNull((String)"imethod not found", (Object)imethod);
        IR ir = cache.getIRFactory().makeIR(imethod, Everywhere.EVERYWHERE, options.getSSAOptions());
        options.getSSAOptions().setPiNodePolicy(save);
        String[] names = ir.getLocalNames(0, 1);
        Assert.assertTrue((String)"failed local name resolution for v1@0", (names != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("incorrect number of local names for v1@0: " + names.length), (names.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("incorrect local name resolution for v1@0: " + names[0]), (boolean)names[0].equals("a"));
        Assert.assertTrue((String)"didn't expect name for v2 at pc 2", (ir.getLocalNames(2, 2) == null ? 1 : 0) != 0);
        names = ir.getLocalNames(5, 1);
        Assert.assertTrue((String)"failed local name resolution for v1@5", (names != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("incorrect number of local names for v1@5: " + names.length), (names.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)("incorrect local name resolution #0 for v1@5: " + names[0]), (boolean)names[0].equals("a"));
        Assert.assertTrue((String)("incorrect local name resolution #1 for v1@5: " + names[1]), (boolean)names[1].equals("b"));
    }

    @Test
    public void testLocalNamesWithPiNodes() {
        SSAPiNodePolicy save = options.getSSAOptions().getPiNodePolicy();
        options.getSSAOptions().setPiNodePolicy(SSAOptions.getAllBuiltInPiNodes());
        MethodReference mref = scope.findMethod(AnalysisScope.APPLICATION, "LcornerCases/Locals", Atom.findOrCreateUnicodeAtom("foo"), new ImmutableByteArray(UTF8Convert.toUTF8("([Ljava/lang/String;)V")));
        Assert.assertNotNull((String)"method not found", (Object)mref);
        IMethod imethod = cha.resolveMethod(mref);
        Assert.assertNotNull((String)"imethod not found", (Object)imethod);
        IR ir = cache.getIRFactory().makeIR(imethod, Everywhere.EVERYWHERE, options.getSSAOptions());
        options.getSSAOptions().setPiNodePolicy(save);
        String[] names = ir.getLocalNames(0, 1);
        Assert.assertTrue((String)"failed local name resolution for v1@0", (names != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("incorrect number of local names for v1@0: " + names.length), (names.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("incorrect local name resolution for v1@0: " + names[0]), (boolean)names[0].equals("a"));
        Assert.assertTrue((String)"didn't expect name for v2 at pc 2", (ir.getLocalNames(2, 2) == null ? 1 : 0) != 0);
        names = ir.getLocalNames(5, 1);
        Assert.assertTrue((String)"failed local name resolution for v1@5", (names != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("incorrect number of local names for v1@5: " + names.length), (names.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)("incorrect local name resolution #0 for v1@5: " + names[0]), (boolean)names[0].equals("a"));
        Assert.assertTrue((String)("incorrect local name resolution #1 for v1@5: " + names[1]), (boolean)names[1].equals("b"));
    }
}

