/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.ir;

import com.ibm.wala.classLoader.ClassLoaderFactoryImpl;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.graph.GraphIntegrity;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import com.ibm.wala.util.strings.UTF8Convert;
import com.ibm.wala.util.warnings.Warnings;
import java.util.Iterator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DeterministicIRTest
extends WalaTestCase {
    private static final ClassLoader MY_CLASSLOADER = DeterministicIRTest.class.getClassLoader();
    private static AnalysisScope scope;
    private static ClassHierarchy cha;
    private static AnalysisOptions options;
    private static AnalysisCache cache;

    public static void main(String[] args) {
        DeterministicIRTest.justThisTest(DeterministicIRTest.class);
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        scope = AnalysisScopeReader.readJavaScope("wala.testdata.txt", new FileProvider().getFile("J2SEClassHierarchyExclusions.txt"), MY_CLASSLOADER);
        options = new AnalysisOptions(scope, null);
        cache = new AnalysisCache();
        ClassLoaderFactoryImpl factory = new ClassLoaderFactoryImpl(scope.getExclusions());
        try {
            cha = ClassHierarchy.make(scope, factory);
        }
        catch (ClassHierarchyException e) {
            throw new Exception();
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        Warnings.clear();
        scope = null;
        cha = null;
        options = null;
        cache = null;
    }

    private IR doMethod(MethodReference method) {
        Assert.assertNotNull((String)"method not found", (Object)method);
        IMethod imethod = cha.resolveMethod(method);
        Assert.assertNotNull((String)"imethod not found", (Object)imethod);
        IR ir1 = cache.getIRFactory().makeIR(imethod, Everywhere.EVERYWHERE, options.getSSAOptions());
        cache.getSSACache().wipe();
        DeterministicIRTest.checkNotAllNull(ir1.getInstructions());
        this.checkNoneNull(ir1.iterateAllInstructions());
        try {
            GraphIntegrity.check(ir1.getControlFlowGraph());
        }
        catch (GraphIntegrity.UnsoundGraphException e) {
            System.err.println(ir1);
            e.printStackTrace();
            Assert.assertTrue((String)"unsound CFG for ir1", (boolean)false);
        }
        IR ir2 = cache.getIRFactory().makeIR(imethod, Everywhere.EVERYWHERE, options.getSSAOptions());
        cache.getSSACache().wipe();
        try {
            GraphIntegrity.check(ir2.getControlFlowGraph());
        }
        catch (GraphIntegrity.UnsoundGraphException e1) {
            System.err.println(ir2);
            e1.printStackTrace();
            Assert.assertTrue((String)"unsound CFG for ir2", (boolean)false);
        }
        Assert.assertEquals((Object)ir1.toString(), (Object)ir2.toString());
        return ir1;
    }

    private void checkNoneNull(Iterator<?> iterator) {
        while (iterator.hasNext()) {
            Assert.assertTrue((iterator.next() != null ? 1 : 0) != 0);
        }
    }

    private static void checkNotAllNull(SSAInstruction[] instructions) {
        int i = 0;
        while (i < instructions.length) {
            if (instructions[i] != null) {
                return;
            }
            ++i;
        }
        Assert.assertTrue((String)"no instructions generated", (boolean)false);
    }

    @Test
    public void testIR1() {
        this.doMethod(scope.findMethod(AnalysisScope.APPLICATION, "Ljava/util/HashMap", Atom.findOrCreateUnicodeAtom("remove"), new ImmutableByteArray(UTF8Convert.toUTF8("(Ljava/lang/Object;)Ljava/lang/Object;"))));
    }

    @Test
    public void testIR2() {
        this.doMethod(scope.findMethod(AnalysisScope.APPLICATION, "Ljava/lang/String", Atom.findOrCreateUnicodeAtom("equals"), new ImmutableByteArray(UTF8Convert.toUTF8("(Ljava/lang/Object;)Z"))));
    }

    @Test
    public void testIR3() {
        this.doMethod(scope.findMethod(AnalysisScope.APPLICATION, "Ljava/io/ObjectInputStream", Atom.findOrCreateUnicodeAtom("resolveProxyClass"), new ImmutableByteArray(UTF8Convert.toUTF8("([Ljava/lang/String;)Ljava/lang/Class;"))));
    }

    @Test
    public void testIR4() {
        this.doMethod(scope.findMethod(AnalysisScope.APPLICATION, "LcornerCases/TryFinally", Atom.findOrCreateUnicodeAtom("test1"), new ImmutableByteArray(UTF8Convert.toUTF8("(Ljava/io/InputStream;Ljava/io/InputStream;)V"))));
    }
}

