/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.ir;

import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.strings.Atom;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class CornerCasesTest
extends WalaTestCase {
    private static final ClassLoader MY_CLASSLOADER = CornerCasesTest.class.getClassLoader();

    @Test
    public void testBug38484() throws ClassHierarchyException, IOException {
        TypeReference t;
        AnalysisScope scope = null;
        scope = AnalysisScopeReader.readJavaScope("wala.testdata.txt", new FileProvider().getFile("J2SEClassHierarchyExclusions.txt"), MY_CLASSLOADER);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        IClass klass = cha.lookupClass(t = TypeReference.findOrCreateClass(scope.getApplicationLoader(), "cornerCases", "YuckyInterface"));
        Assert.assertTrue((klass != null ? 1 : 0) != 0);
        IMethod m = klass.getMethod(new Selector(Atom.findOrCreateAsciiAtom("x"), Descriptor.findOrCreateUTF8("()V")));
        Assert.assertTrue((m == null ? 1 : 0) != 0);
    }

    @Test
    public void testBug38540() throws ClassHierarchyException, IOException {
        TypeReference t;
        AnalysisScope scope = null;
        scope = AnalysisScopeReader.readJavaScope("wala.testdata.txt", new FileProvider().getFile("J2SEClassHierarchyExclusions.txt"), MY_CLASSLOADER);
        AnalysisOptions options = new AnalysisOptions();
        ClassHierarchy cha = ClassHierarchy.make(scope);
        IClass klass = cha.lookupClass(t = TypeReference.findOrCreateClass(scope.getApplicationLoader(), "cornerCases", "Main"));
        Assert.assertTrue((klass != null ? 1 : 0) != 0);
        ShrikeCTMethod m = (ShrikeCTMethod)klass.getMethod(new Selector(Atom.findOrCreateAsciiAtom("foo"), Descriptor.findOrCreateUTF8("()Ljava/lang/Object;")));
        Assert.assertTrue((m != null ? 1 : 0) != 0);
        IR ir = new AnalysisCache().getSSACache().findOrCreateIR(m, Everywhere.EVERYWHERE, options.getSSAOptions());
        TypeInference.make(ir, false);
    }
}

