/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.ir;

import com.ibm.wala.classLoader.ClassLoaderFactoryImpl;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.GraphIntegrity;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.strings.StringStuff;
import com.ibm.wala.util.warnings.Warnings;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CFGTest
extends WalaTestCase {
    private static AnalysisScope scope;
    private static ClassHierarchy cha;

    @BeforeClass
    public static void beforeClass() throws Exception {
        scope = AnalysisScopeReader.readJavaScope("wala.testdata.txt", new FileProvider().getFile("J2SEClassHierarchyExclusions.txt"), CFGTest.class.getClassLoader());
        ClassLoaderFactoryImpl factory = new ClassLoaderFactoryImpl(scope.getExclusions());
        try {
            cha = ClassHierarchy.make(scope, factory);
        }
        catch (ClassHierarchyException e) {
            throw new Exception();
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        Warnings.clear();
        scope = null;
        cha = null;
    }

    public static void main(String[] args) {
        CFGTest.justThisTest(CFGTest.class);
    }

    private void doMethod(String methodSig) {
        try {
            MethodReference mr = StringStuff.makeMethodReference(Language.JAVA, methodSig);
            IMethod m = cha.resolveMethod(mr);
            if (m == null) {
                Assertions.UNREACHABLE("could not resolve " + mr);
            }
            AnalysisOptions options = new AnalysisOptions();
            AnalysisCache cache = new AnalysisCache();
            options.getSSAOptions().setPiNodePolicy(SSAOptions.getAllBuiltInPiNodes());
            IR ir = cache.getSSACache().findOrCreateIR(m, Everywhere.EVERYWHERE, options.getSSAOptions());
            SSACFG cfg = ir.getControlFlowGraph();
            try {
                GraphIntegrity.check(cfg);
            }
            catch (GraphIntegrity.UnsoundGraphException e) {
                e.printStackTrace();
                System.err.println(ir);
                Assert.assertTrue((String)(" failed cfg integrity check for " + methodSig), (boolean)false);
            }
            try {
                GraphIntegrity.check(cfg);
            }
            catch (GraphIntegrity.UnsoundGraphException e) {
                e.printStackTrace();
                System.err.println(ir);
                System.err.println(cfg);
                Assert.assertTrue((String)(" failed 2-exit cfg integrity check for " + methodSig), (boolean)false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    @Test
    public void testResolveProxyClass() {
        this.doMethod("java.io.ObjectInputStream.resolveProxyClass([Ljava/lang/String;)Ljava/lang/Class;");
    }

    @Test
    public void testSync1() {
        MethodReference mr = StringStuff.makeMethodReference("cfg.MonitorTest.sync1()V");
        IMethod m = cha.resolveMethod(mr);
        AnalysisCache cache = new AnalysisCache();
        IR ir = cache.getIR(m);
        System.out.println(ir);
        SSACFG controlFlowGraph = ir.getControlFlowGraph();
        Assert.assertEquals((long)1L, (long)controlFlowGraph.getSuccNodeCount(controlFlowGraph.getBlockForInstruction(21)));
    }

    @Test
    public void testSync2() {
        MethodReference mr = StringStuff.makeMethodReference("cfg.MonitorTest.sync2()V");
        IMethod m = cha.resolveMethod(mr);
        AnalysisCache cache = new AnalysisCache();
        IR ir = cache.getIR(m);
        System.out.println(ir);
        SSACFG controlFlowGraph = ir.getControlFlowGraph();
        IntSet succs = controlFlowGraph.getSuccNodeNumbers(controlFlowGraph.getBlockForInstruction(13));
        Assert.assertEquals((long)2L, (long)succs.size());
        Assert.assertTrue((boolean)succs.contains(6));
        Assert.assertTrue((boolean)succs.contains(7));
    }

    @Test
    public void testSync3() {
        MethodReference mr = StringStuff.makeMethodReference("cfg.MonitorTest.sync3()V");
        IMethod m = cha.resolveMethod(mr);
        AnalysisCache cache = new AnalysisCache();
        IR ir = cache.getIR(m);
        SSACFG controlFlowGraph = ir.getControlFlowGraph();
        Assert.assertEquals((long)1L, (long)controlFlowGraph.getSuccNodeCount(controlFlowGraph.getBlockForInstruction(33)));
    }

    public static void testCFG(SSACFG cfg, int[][] assertions) {
        int i = 0;
        while (i < assertions.length) {
            SSACFG.BasicBlock bb = cfg.getNode(i);
            Assert.assertEquals((String)("basic block " + i), (long)assertions[i].length, (long)cfg.getSuccNodeCount(bb));
            int j = 0;
            while (j < assertions[i].length) {
                Assert.assertTrue((boolean)cfg.hasEdge(bb, cfg.getNode(assertions[i][j])));
                ++j;
            }
            ++i;
        }
    }
}

