/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.ir;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.io.FileProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AnnotationTest
extends WalaTestCase {
    private static IClassHierarchy cha;

    public static void main(String[] args) {
        AnnotationTest.justThisTest(AnnotationTest.class);
    }

    @BeforeClass
    public static void before() throws IOException, ClassHierarchyException {
        AnalysisScope scope = AnalysisScopeReader.readJavaScope("wala.testdata.txt", new FileProvider().getFile(CallGraphTestUtil.REGRESSION_EXCLUSIONS), AnnotationTest.class.getClassLoader());
        cha = ClassHierarchy.make(scope);
    }

    @AfterClass
    public static void after() {
        cha = null;
    }

    @Test
    public void testClassAnnotations1() throws Exception {
        TypeReference typeUnderTest = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lannotations/AnnotatedClass1");
        HashSet<Annotation> expectedRuntimeInvisibleAnnotations = HashSetFactory.make();
        expectedRuntimeInvisibleAnnotations.add(Annotation.make(TypeReference.findOrCreate(ClassLoaderReference.Application, "Lannotations/RuntimeInvisableAnnotation")));
        expectedRuntimeInvisibleAnnotations.add(Annotation.make(TypeReference.findOrCreate(ClassLoaderReference.Application, "Lannotations/DefaultVisableAnnotation")));
        HashSet<Annotation> expectedRuntimeVisibleAnnotations = HashSetFactory.make();
        expectedRuntimeVisibleAnnotations.add(Annotation.make(TypeReference.findOrCreate(ClassLoaderReference.Application, "Lannotations/RuntimeVisableAnnotation")));
        this.testClassAnnotations(typeUnderTest, expectedRuntimeInvisibleAnnotations, expectedRuntimeVisibleAnnotations);
    }

    @Test
    public void testClassAnnotations2() throws Exception {
        TypeReference typeUnderTest = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lannotations/AnnotatedClass2");
        HashSet<Annotation> expectedRuntimeInvisibleAnnotations = HashSetFactory.make();
        expectedRuntimeInvisibleAnnotations.add(Annotation.make(TypeReference.findOrCreate(ClassLoaderReference.Application, "Lannotations/RuntimeInvisableAnnotation")));
        expectedRuntimeInvisibleAnnotations.add(Annotation.make(TypeReference.findOrCreate(ClassLoaderReference.Application, "Lannotations/RuntimeInvisableAnnotation2")));
        HashSet<Annotation> expectedRuntimeVisibleAnnotations = HashSetFactory.make();
        expectedRuntimeVisibleAnnotations.add(Annotation.make(TypeReference.findOrCreate(ClassLoaderReference.Application, "Lannotations/RuntimeVisableAnnotation")));
        expectedRuntimeVisibleAnnotations.add(Annotation.make(TypeReference.findOrCreate(ClassLoaderReference.Application, "Lannotations/RuntimeVisableAnnotation2")));
        this.testClassAnnotations(typeUnderTest, expectedRuntimeInvisibleAnnotations, expectedRuntimeVisibleAnnotations);
    }

    private void testClassAnnotations(TypeReference typeUnderTest, Collection<Annotation> expectedRuntimeInvisibleAnnotations, Collection<Annotation> expectedRuntimeVisibleAnnotations) throws IOException, ClassHierarchyException, InvalidClassFileException {
        IClass classUnderTest = cha.lookupClass(typeUnderTest);
        Assert.assertNotNull((String)(String.valueOf(typeUnderTest.toString()) + " not found"), (Object)classUnderTest);
        Assert.assertTrue((boolean)(classUnderTest instanceof ShrikeClass));
        ShrikeClass shrikeClassUnderTest = (ShrikeClass)classUnderTest;
        Collection<Annotation> runtimeInvisibleAnnotations = shrikeClassUnderTest.getRuntimeInvisibleAnnotations();
        this.assertEqualCollections(expectedRuntimeInvisibleAnnotations, runtimeInvisibleAnnotations);
        Collection<Annotation> runtimeVisibleAnnotations = shrikeClassUnderTest.getRuntimeVisibleAnnotations();
        this.assertEqualCollections(expectedRuntimeVisibleAnnotations, runtimeVisibleAnnotations);
    }

    private <T> void assertEqualCollections(Collection<T> expected, Collection<T> actual) {
        if (expected == null) {
            expected = Collections.emptySet();
        }
        if (actual == null) {
            actual = Collections.emptySet();
        }
        if (expected.size() != actual.size()) {
            Assert.assertTrue((String)("expected=" + expected + " actual=" + actual), (boolean)false);
        }
        for (T a : expected) {
            Assert.assertTrue((String)("missing " + a.toString()), (boolean)actual.contains(a));
        }
    }

    @Test
    public void testClassAnnotations3() throws Exception {
        TypeReference typeRef = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lannotations/AnnotatedClass3");
        IClass klass = cha.lookupClass(typeRef);
        Assert.assertNotNull((Object)klass);
        ShrikeClass shrikeClass = (ShrikeClass)klass;
        Collection<Annotation> classAnnotations = shrikeClass.getAnnotations(true);
        Assert.assertEquals((Object)"[Annotation type <Application,Lannotations/AnnotationWithParams> {strParam=classStrParam}]", (Object)classAnnotations.toString());
        MethodReference methodRefUnderTest = MethodReference.findOrCreate(typeRef, Selector.make("foo()V"));
        IMethod methodUnderTest = cha.resolveMethod(methodRefUnderTest);
        Assert.assertNotNull((String)(String.valueOf(methodRefUnderTest.toString()) + " not found"), (Object)methodUnderTest);
        Assert.assertTrue((boolean)(methodUnderTest instanceof ShrikeCTMethod));
        ShrikeCTMethod shrikeCTMethodUnderTest = (ShrikeCTMethod)methodUnderTest;
        Collection<Annotation> runtimeInvisibleAnnotations = shrikeCTMethodUnderTest.getAnnotations(true);
        Assert.assertEquals((Object)"[Annotation type <Application,Lannotations/AnnotationWithParams> {enumParam=EnumElementValue [type=Lannotations/AnnotationEnum;, val=VAL1], strArrParam=ArrayElementValue [vals=[biz, boz]], annotParam=AnnotationElementValue [type=Lannotations/AnnotationWithSingleParam;, elementValues={value=sdfevs}], strParam=sdfsevs, intParam=25, klassParam=Ljava/lang/Integer;}]", (Object)runtimeInvisibleAnnotations.toString());
    }
}

