/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.demandpa;

import com.ibm.wala.core.tests.demandpa.AbstractPtrTest;
import com.ibm.wala.demandpa.alg.DemandRefinementPointsTo;
import com.ibm.wala.demandpa.alg.refinepolicy.AlwaysRefineFieldsPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.NeverRefineCGPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.SinglePassRefinementPolicy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.util.CancelException;
import java.io.IOException;
import org.junit.Test;

public class RefineFieldsPtrTest
extends AbstractPtrTest {
    public RefineFieldsPtrTest() {
        super("wala.testdata.txt");
    }

    @Test
    public void testNastyPtrs() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestNastyPtrs", 10);
    }

    @Test
    public void testGlobal() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestGlobal", 1);
    }

    @Test
    public void testFields() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestFields", 1);
    }

    @Test
    public void testFieldsHarder() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestFieldsHarder", 1);
    }

    @Test
    public void testArrays() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestArrays", 2);
    }

    @Test
    public void testGetterSetter() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestGetterSetter", 1);
    }

    @Test
    public void testArraySet() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestArraySet", 2);
    }

    @Test
    public void testArraySetIter() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestArraySetIter", 2);
    }

    @Test
    public void testMultiDim() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestMultiDim", 2);
    }

    @Override
    public DemandRefinementPointsTo makeDemandPointerAnalysis(String mainClass) throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        DemandRefinementPointsTo dmp = super.makeDemandPointerAnalysis(mainClass);
        dmp.setRefinementPolicyFactory(new SinglePassRefinementPolicy.Factory(new AlwaysRefineFieldsPolicy(), new NeverRefineCGPolicy()));
        return dmp;
    }

    @Test
    public void testFlowsToFields() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doFlowsToSizeTest("Ldemandpa/FlowsToTestFields", 5);
    }

    @Test
    public void testFlowsToFieldsHarder() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doFlowsToSizeTest("Ldemandpa/FlowsToTestFieldsHarder", 5);
    }
}

