/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.demandpa;

import com.ibm.wala.core.tests.demandpa.AbstractPtrTest;
import com.ibm.wala.demandpa.alg.ContextSensitiveStateMachine;
import com.ibm.wala.demandpa.alg.DemandRefinementPointsTo;
import com.ibm.wala.demandpa.alg.refinepolicy.AlwaysRefineCGPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.AlwaysRefineFieldsPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.SinglePassRefinementPolicy;
import com.ibm.wala.demandpa.alg.statemachine.StateMachineFactory;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.strings.Atom;
import java.io.IOException;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ContextSensitiveTest
extends AbstractPtrTest {
    public ContextSensitiveTest() {
        super("wala.testdata.txt");
    }

    @Test
    public void testArraySet() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestArraySet", 1);
    }

    @Test
    public void testClone() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestClone", 1);
    }

    @Test
    public void testFooId() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestId", 1);
    }

    @Test
    public void testHashtableEnum() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestHashtableEnum", 2);
    }

    @Ignore(value="support for this combination of context sensitivity and on-the-fly call graph refinement is not yet implemented")
    @Test
    public void testOnTheFlyCS() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        String mainClass = "Ldemandpa/TestOnTheFlyCS";
        DemandRefinementPointsTo dmp = this.makeDemandPointerAnalysis(mainClass);
        CGNode testMethod = AbstractPtrTest.findInstanceMethod(dmp.getBaseCallGraph(), dmp.getClassHierarchy().lookupClass(TypeReference.findOrCreate(ClassLoaderReference.Application, "Ldemandpa/TestOnTheFlyCS$C2")), Atom.findOrCreateUnicodeAtom("doSomething"), Descriptor.findOrCreateUTF8("(Ljava/lang/Object;)V"));
        PointerKey keyToQuery = AbstractPtrTest.getParam(testMethod, "testThisVar", dmp.getHeapModel());
        Collection<InstanceKey> pointsTo = dmp.getPointsTo(keyToQuery);
        if (this.debug) {
            System.err.println("points-to for " + mainClass + ": " + pointsTo);
        }
        Assert.assertEquals((long)1L, (long)pointsTo.size());
    }

    @Test
    public void testWithinMethodCall() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        String mainClass = "Ldemandpa/TestWithinMethodCall";
        DemandRefinementPointsTo dmp = this.makeDemandPointerAnalysis(mainClass);
        CGNode testMethod = AbstractPtrTest.findStaticMethod(dmp.getBaseCallGraph(), Atom.findOrCreateUnicodeAtom("testMethod"), Descriptor.findOrCreateUTF8("(Ljava/lang/Object;)V"));
        PointerKey keyToQuery = AbstractPtrTest.getParam(testMethod, "testThisVar", dmp.getHeapModel());
        Collection<InstanceKey> pointsTo = dmp.getPointsTo(keyToQuery);
        if (this.debug) {
            System.err.println("points-to for " + mainClass + ": " + pointsTo);
        }
        Assert.assertEquals((long)1L, (long)pointsTo.size());
    }

    @Test
    public void testLinkedListIter() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestLinkedListIter", 1);
    }

    @Test
    public void testGlobal() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestGlobal", 1);
    }

    @Test
    public void testHashSet() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestHashSet", 1);
    }

    @Test
    public void testHashMapGet() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestHashMapGet", 1);
    }

    @Test
    public void testMethodRecursion() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestMethodRecursion", 2);
    }

    @Test
    public void testArraySetIter() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestArraySetIter", 1);
    }

    @Test
    public void testArrayList() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestArrayList", 1);
    }

    @Test
    public void testLinkedList() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doPointsToSizeTest("Ldemandpa/TestLinkedList", 1);
    }

    @Test
    public void testFlowsToArraySetIter() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.doFlowsToSizeTest("Ldemandpa/FlowsToTestArraySetIter", 7);
    }

    @Override
    protected StateMachineFactory<IFlowLabel> getStateMachineFactory() {
        return new ContextSensitiveStateMachine.Factory();
    }

    @Override
    protected DemandRefinementPointsTo makeDemandPointerAnalysis(String mainClass) throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        DemandRefinementPointsTo dmp = super.makeDemandPointerAnalysis(mainClass);
        dmp.setRefinementPolicyFactory(new SinglePassRefinementPolicy.Factory(new AlwaysRefineFieldsPolicy(), new AlwaysRefineCGPolicy()));
        return dmp;
    }
}

