/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.demandpa;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.demandpa.alg.DemandRefinementPointsTo;
import com.ibm.wala.demandpa.alg.statemachine.DummyStateMachine;
import com.ibm.wala.demandpa.alg.statemachine.StateMachineFactory;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.util.PABasedMemoryAccessMap;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.StringStuff;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.junit.AfterClass;
import org.junit.Assert;

public abstract class AbstractPtrTest {
    protected boolean debug = false;
    protected final String scopeFile;
    private static AnalysisScope cachedScope;
    private static IClassHierarchy cachedCHA;

    protected AbstractPtrTest(String scopeFile) {
        this.scopeFile = scopeFile;
    }

    public static CGNode findMainMethod(CallGraph cg) {
        Descriptor d = Descriptor.findOrCreateUTF8("([Ljava/lang/String;)V");
        Atom name = Atom.findOrCreateUnicodeAtom("main");
        Iterator<CGNode> it = cg.getSuccNodes(cg.getFakeRootNode());
        while (it.hasNext()) {
            CGNode n = it.next();
            if (!n.getMethod().getName().equals(name) || !n.getMethod().getDescriptor().equals(d)) continue;
            return n;
        }
        Assertions.UNREACHABLE("failed to find method");
        return null;
    }

    public static CGNode findStaticMethod(CallGraph cg, Atom name, Descriptor args) {
        for (CGNode n : cg) {
            if (!n.getMethod().getName().equals(name) || !n.getMethod().getDescriptor().equals(args)) continue;
            return n;
        }
        Assertions.UNREACHABLE("failed to find method");
        return null;
    }

    public static CGNode findInstanceMethod(CallGraph cg, IClass declaringClass, Atom name, Descriptor args) {
        for (CGNode n : cg) {
            if (!n.getMethod().getDeclaringClass().equals(declaringClass) || !n.getMethod().getName().equals(name) || !n.getMethod().getDescriptor().equals(args)) continue;
            return n;
        }
        Assertions.UNREACHABLE("failed to find method");
        return null;
    }

    public static PointerKey getParam(CGNode n, String methodName, HeapModel heapModel) {
        IR ir = n.getIR();
        Iterator<SSAInstruction> it = ir.iterateAllInstructions();
        while (it.hasNext()) {
            SSAInvokeInstruction call;
            SSAInstruction s = it.next();
            if (!(s instanceof SSAInvokeInstruction) || !(call = (SSAInvokeInstruction)s).getCallSite().getDeclaredTarget().getName().toString().equals(methodName)) continue;
            IntSet indices = ir.getCallInstructionIndices(((SSAInvokeInstruction)s).getCallSite());
            Assertions.productionAssertion(indices.size() == 1, "expected 1 but got " + indices.size());
            SSAInstruction callInstr = ir.getInstructions()[indices.intIterator().next()];
            Assertions.productionAssertion(callInstr.getNumberOfUses() == 1, "multiple uses for call");
            return heapModel.getPointerKeyForLocal(n, callInstr.getUse(0));
        }
        Assertions.UNREACHABLE("failed to find call to " + methodName + " in " + n);
        return null;
    }

    protected void doFlowsToSizeTest(String mainClass, int size) throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        Collection<PointerKey> flowsTo = this.getFlowsToSetToTest(mainClass);
        if (this.debug) {
            System.err.println("flows-to for " + mainClass + ": " + flowsTo);
        }
        Assert.assertEquals((long)size, (long)flowsTo.size());
    }

    private Collection<PointerKey> getFlowsToSetToTest(String mainClass) throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        DemandRefinementPointsTo dmp = this.makeDemandPointerAnalysis(mainClass);
        CGNode mainMethod = AbstractPtrTest.findMainMethod(dmp.getBaseCallGraph());
        InstanceKey keyToQuery = this.getFlowsToInstanceKey(mainMethod, dmp.getHeapModel());
        Collection flowsTo = (Collection)dmp.getFlowsTo((InstanceKey)keyToQuery).snd;
        return flowsTo;
    }

    private InstanceKey getFlowsToInstanceKey(CGNode mainMethod, HeapModel heapModel) {
        TypeReference flowsToTypeRef = TypeReference.findOrCreate(ClassLoaderReference.Application, StringStuff.deployment2CanonicalTypeString("demandpa.FlowsToType"));
        IR mainIR = mainMethod.getIR();
        if (this.debug) {
            System.err.println(mainIR);
        }
        for (NewSiteReference n : Iterator2Iterable.make(mainIR.iterateNewSites())) {
            if (!n.getDeclaredType().equals(flowsToTypeRef)) continue;
            return heapModel.getInstanceKeyForAllocation(mainMethod, n);
        }
        assert (false) : "could not find appropriate allocation";
        return null;
    }

    protected void doPointsToSizeTest(String mainClass, int expectedSize) throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        Collection<InstanceKey> pointsTo = this.getPointsToSetToTest(mainClass);
        if (this.debug) {
            System.err.println("points-to for " + mainClass + ": " + pointsTo);
        }
        Assert.assertEquals((long)expectedSize, (long)pointsTo.size());
    }

    private Collection<InstanceKey> getPointsToSetToTest(String mainClass) throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        DemandRefinementPointsTo dmp = this.makeDemandPointerAnalysis(mainClass);
        CGNode mainMethod = AbstractPtrTest.findMainMethod(dmp.getBaseCallGraph());
        PointerKey keyToQuery = AbstractPtrTest.getParam(mainMethod, "testThisVar", dmp.getHeapModel());
        Collection<InstanceKey> pointsTo = dmp.getPointsTo(keyToQuery);
        return pointsTo;
    }

    protected DemandRefinementPointsTo makeDemandPointerAnalysis(String mainClass) throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = this.findOrCreateAnalysisScope();
        IClassHierarchy cha = this.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, mainClass);
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        AnalysisCache analysisCache = new AnalysisCache();
        SSAPropagationCallGraphBuilder cgBuilder = Util.makeZeroCFABuilder(options, analysisCache, cha, scope);
        CallGraph cg = cgBuilder.makeCallGraph(options, null);
        PABasedMemoryAccessMap mam = new PABasedMemoryAccessMap(cg, cgBuilder.getPointerAnalysis());
        SSAPropagationCallGraphBuilder builder = Util.makeVanillaZeroOneCFABuilder(options, analysisCache, cha, scope);
        DemandRefinementPointsTo fullDemandPointsTo = DemandRefinementPointsTo.makeWithDefaultFlowGraph(cg, builder, mam, cha, options, this.getStateMachineFactory());
        return fullDemandPointsTo;
    }

    private IClassHierarchy findOrCreateCHA(AnalysisScope scope) throws ClassHierarchyException {
        if (cachedCHA == null) {
            cachedCHA = ClassHierarchy.make(scope);
        }
        return cachedCHA;
    }

    private AnalysisScope findOrCreateAnalysisScope() throws IOException {
        if (cachedScope == null) {
            cachedScope = CallGraphTestUtil.makeJ2SEAnalysisScope(this.scopeFile, CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        }
        return cachedScope;
    }

    @AfterClass
    public static void cleanup() {
        cachedScope = null;
        cachedCHA = null;
    }

    protected StateMachineFactory<IFlowLabel> getStateMachineFactory() {
        return new DummyStateMachine.Factory<IFlowLabel>();
    }
}

