/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.cha;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.config.AnalysisScopeReader;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class SourceMapTest
extends WalaTestCase {
    private static final ClassLoader MY_CLASSLOADER = SourceMapTest.class.getClassLoader();
    private static final String CLASS_IN_PRIMORDIAL_JAR = "Lcom/ibm/wala/model/SyntheticFactory";

    @Test
    public void testHello() throws ClassHierarchyException, IOException {
        AnalysisScope scope = null;
        scope = AnalysisScopeReader.readJavaScope("hello.txt", null, MY_CLASSLOADER);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        TypeReference t = TypeReference.findOrCreate(scope.getApplicationLoader(), "Lhello/Hello");
        IClass klass = cha.lookupClass(t);
        Assert.assertTrue((String)("failed to load " + t), (klass != null ? 1 : 0) != 0);
        String sourceFile = klass.getSourceFileName();
        System.err.println("Source file: " + sourceFile);
        Assert.assertTrue((sourceFile != null ? 1 : 0) != 0);
    }

    @Test
    public void testFromJar() throws ClassHierarchyException, IOException {
        TypeReference t;
        AnalysisScope scope = null;
        scope = AnalysisScopeReader.readJavaScope("hello.txt", null, MY_CLASSLOADER);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        IClass klass = cha.lookupClass(t = TypeReference.findOrCreate(scope.getPrimordialLoader(), CLASS_IN_PRIMORDIAL_JAR));
        Assert.assertTrue((klass != null ? 1 : 0) != 0);
        String sourceFile = klass.getSourceFileName();
        Assert.assertTrue((sourceFile != null ? 1 : 0) != 0);
        System.err.println("Source file: " + sourceFile);
    }
}

