/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.cha;

import com.ibm.wala.classLoader.ClassLoaderFactoryImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.io.FileProvider;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class InterfaceTest
extends WalaTestCase {
    private static final ClassLoader MY_CLASSLOADER = InterfaceTest.class.getClassLoader();
    private static AnalysisScope scope;
    private static ClassHierarchy cha;

    public static void main(String[] args) {
        InterfaceTest.justThisTest(InterfaceTest.class);
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        scope = AnalysisScopeReader.readJavaScope("wala.testdata.txt", new FileProvider().getFile("J2SEClassHierarchyExclusions.txt"), MY_CLASSLOADER);
        ClassLoaderFactoryImpl factory = new ClassLoaderFactoryImpl(scope.getExclusions());
        try {
            cha = ClassHierarchy.make(scope, factory);
        }
        catch (ClassHierarchyException e) {
            throw new Exception();
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        scope = null;
        cha = null;
    }

    @Test
    public void test1() {
        TypeReference prep_stmt_type = TypeReference.findOrCreate(ClassLoaderReference.Primordial, TypeName.string2TypeName("Ljava/sql/PreparedStatement"));
        TypeReference stmt_type = TypeReference.findOrCreate(ClassLoaderReference.Primordial, TypeName.string2TypeName("Ljava/sql/Statement"));
        IClass prep_stmt = cha.lookupClass(prep_stmt_type);
        IClass stmt = cha.lookupClass(stmt_type);
        Assert.assertTrue((String)"did not find PreparedStatement", (prep_stmt != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"did not find Statement", (stmt != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)cha.implementsInterface(prep_stmt, stmt));
        Assert.assertFalse((boolean)cha.implementsInterface(stmt, prep_stmt));
        Assert.assertTrue((boolean)cha.isAssignableFrom(stmt, prep_stmt));
        Assert.assertFalse((boolean)cha.isAssignableFrom(prep_stmt, stmt));
    }

    @Test
    public void test2() {
        IClass objArrayClass = cha.lookupClass(TypeReference.JavaLangObject.getArrayTypeForElementType());
        IClass stringArrayClass = cha.lookupClass(TypeReference.JavaLangString.getArrayTypeForElementType());
        IClass cloneableClass = cha.lookupClass(TypeReference.JavaLangCloneable);
        IClass serializableClass = cha.lookupClass(TypeReference.JavaIoSerializable);
        Assert.assertTrue((boolean)cha.implementsInterface(objArrayClass, cloneableClass));
        Assert.assertTrue((boolean)cha.implementsInterface(objArrayClass, serializableClass));
        Assert.assertTrue((boolean)cha.implementsInterface(stringArrayClass, cloneableClass));
        Assert.assertTrue((boolean)cha.implementsInterface(stringArrayClass, serializableClass));
    }
}

