/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.cha;

import com.ibm.wala.classLoader.ClassLoaderFactoryImpl;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.io.FileProvider;
import java.util.Collection;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class GetTargetsTest
extends WalaTestCase {
    private static final ClassLoader MY_CLASSLOADER = GetTargetsTest.class.getClassLoader();
    private static AnalysisScope scope;
    private static ClassHierarchy cha;

    public static void main(String[] args) {
        GetTargetsTest.justThisTest(GetTargetsTest.class);
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        scope = AnalysisScopeReader.readJavaScope("wala.testdata.txt", new FileProvider().getFile("J2SEClassHierarchyExclusions.txt"), MY_CLASSLOADER);
        ClassLoaderFactoryImpl factory = new ClassLoaderFactoryImpl(scope.getExclusions());
        try {
            cha = ClassHierarchy.make(scope, factory);
        }
        catch (ClassHierarchyException e) {
            throw new Exception();
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        scope = null;
        cha = null;
    }

    @Test
    public void testCell() {
        TypeReference t = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lcell/Cell");
        MethodReference m = MethodReference.findOrCreate(t, "<init>", "(Ljava/lang/Object;)V");
        Collection<IMethod> c = cha.getPossibleTargets(m);
        for (IMethod method : c) {
            System.err.println(method);
        }
        Assert.assertEquals((long)1L, (long)c.size());
    }

    @Test
    public void testObjInit() {
        MethodReference m = MethodReference.findOrCreate(TypeReference.JavaLangObject, MethodReference.initSelector);
        Collection<IMethod> c = cha.getPossibleTargets(m);
        for (IMethod method : c) {
            System.err.println(method);
        }
        Assert.assertEquals((long)1L, (long)c.size());
    }
}

