/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.cha;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.strings.Atom;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class DupFieldsTest
extends WalaTestCase {
    @Test
    public void testDupFieldNames() throws IOException, ClassHierarchyException {
        AnalysisScope scope = null;
        scope = AnalysisScopeReader.readJavaScope("wala.testdata.txt", new FileProvider().getFile("J2SEClassHierarchyExclusions.txt"), DupFieldsTest.class.getClassLoader());
        ClassHierarchy cha = ClassHierarchy.make(scope);
        TypeReference ref = TypeReference.findOrCreate(ClassLoaderReference.Application, "LDupFieldName");
        IClass klass = cha.lookupClass(ref);
        boolean threwException = false;
        try {
            klass.getField(Atom.findOrCreateUnicodeAtom("a"));
        }
        catch (IllegalStateException e) {
            threwException = true;
        }
        Assert.assertTrue((boolean)threwException);
        IField f = cha.resolveField(FieldReference.findOrCreate(ref, Atom.findOrCreateUnicodeAtom("a"), TypeReference.Int));
        Assert.assertEquals((Object)f.getFieldTypeReference(), (Object)TypeReference.Int);
        f = cha.resolveField(FieldReference.findOrCreate(ref, Atom.findOrCreateUnicodeAtom("a"), TypeReference.Boolean));
        Assert.assertEquals((Object)f.getFieldTypeReference(), (Object)TypeReference.Boolean);
    }
}

