/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.callGraph;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.impl.SubtypesEntrypoint;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import java.io.IOException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class SyntheticTest
extends WalaTestCase {
    @Test
    public void testMultiSubtypes() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        TypeReference t = TypeReference.findOrCreate(ClassLoaderReference.Application, "LmultiTypes/Foo");
        MethodReference mref = MethodReference.findOrCreate(t, "foo", "(LmultiTypes/Foo$A;)V");
        IMethod m = cha.resolveMethod(mref);
        assert (m != null);
        SubtypesEntrypoint e = new SubtypesEntrypoint(m, (IClassHierarchy)cha);
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, Collections.singleton(e));
        CallGraph cg = CallGraphTestUtil.buildZeroCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tA = TypeReference.findOrCreate(ClassLoaderReference.Application, "LmultiTypes/Foo$A");
        MethodReference barA = MethodReference.findOrCreate(tA, "bar", "()V");
        TypeReference tB = TypeReference.findOrCreate(ClassLoaderReference.Application, "LmultiTypes/Foo$B");
        MethodReference barB = MethodReference.findOrCreate(tB, "bar", "()V");
        Assert.assertTrue((cg.getNodes(barA).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((cg.getNodes(barB).size() == 1 ? 1 : 0) != 0);
        CGNode root = cg.getFakeRootNode();
        IR ir = root.getIR();
        Assert.assertTrue((boolean)ir.iteratePhis().hasNext());
    }
}

