/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.callGraph;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.tests.callGraph.CallGraphTest;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.ReceiverInstanceContext;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionTest
extends WalaTestCase {
    private static AnalysisScope cachedScope;
    private static IClassHierarchy cachedCHA;

    public static void main(String[] args) {
        ReflectionTest.justThisTest(ReflectionTest.class);
    }

    private static AnalysisScope findOrCreateAnalysisScope() throws IOException {
        if (cachedScope == null) {
            cachedScope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", "Java60RegressionExclusions.txt");
        }
        return cachedScope;
    }

    private static IClassHierarchy findOrCreateCHA(AnalysisScope scope) throws ClassHierarchyException {
        if (cachedCHA == null) {
            cachedCHA = ClassHierarchy.make(scope);
        }
        return cachedCHA;
    }

    @AfterClass
    public static void afterClass() {
        cachedCHA = null;
        cachedScope = null;
    }

    @Test
    public void testReflect1() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect1");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        Warnings.clear();
        CallGraphTest.doCallGraphs(options, new AnalysisCache(), cha, scope);
        Iterator<Warning> it = Warnings.iterator();
        while (it.hasNext()) {
            Warning w = it.next();
            if (w.toString().indexOf("com/ibm/jvm") > 0 || w.toString().indexOf("Integer") < 0) continue;
            Assert.assertTrue((String)w.toString(), (boolean)false);
        }
    }

    @Test
    public void testReflect2() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect2");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Ljava/lang/Integer");
        MethodReference mr = MethodReference.findOrCreate(tr, "<clinit>", "()V");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
    }

    @Test
    public void testReflect3() throws IOException, ClassHierarchyException, IllegalArgumentException, CancelException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect3");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Ljava/lang/Class");
        MethodReference mr = MethodReference.findOrCreate(tr, "newInstance", "()Ljava/lang/Object;");
        Set<CGNode> newInstanceNodes = cg.getNodes(mr);
        HashSet succNodes = HashSetFactory.make();
        for (CGNode newInstanceNode : newInstanceNodes) {
            Iterator<CGNode> succNodesIter = cg.getSuccNodes(newInstanceNode);
            while (succNodesIter.hasNext()) {
                succNodes.add(succNodesIter.next());
            }
        }
        TypeReference extraneousTR = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lreflection/Reflect3$Hash");
        IClass hashClass = cha.lookupClass(extraneousTR);
        assert (hashClass != null);
        MethodReference extraneousMR = MethodReference.findOrCreate(extraneousTR, "<init>", "()V");
        Set<CGNode> extraneousNodes = cg.getNodes(extraneousMR);
        succNodes.retainAll(extraneousNodes);
        Assert.assertTrue((boolean)succNodes.isEmpty());
    }

    @Test
    public void testReflect4() throws IOException, ClassHierarchyException, IllegalArgumentException, CancelException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect4");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Ljava/lang/Class");
        MethodReference mr = MethodReference.findOrCreate(tr, "newInstance", "()Ljava/lang/Object;");
        Set<CGNode> newInstanceNodes = cg.getNodes(mr);
        HashSet succNodes = HashSetFactory.make();
        for (CGNode newInstanceNode : newInstanceNodes) {
            Iterator<CGNode> succNodesIter = cg.getSuccNodes(newInstanceNode);
            while (succNodesIter.hasNext()) {
                succNodes.add(succNodesIter.next());
            }
        }
        TypeReference extraneousTR = TypeReference.findOrCreate(ClassLoaderReference.Application, "Ljava/io/FilePermission");
        MethodReference extraneousMR = MethodReference.findOrCreate(extraneousTR, "<init>", "(Ljava/lang/String;Ljava/lang/String;)V");
        Set<CGNode> extraneousNodes = cg.getNodes(extraneousMR);
        succNodes.retainAll(extraneousNodes);
        Assert.assertTrue((boolean)succNodes.isEmpty());
    }

    @Test
    public void testReflect5() throws IOException, ClassHierarchyException, IllegalArgumentException, CancelException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect5");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Ljava/lang/Class");
        MethodReference mr = MethodReference.findOrCreate(tr, "newInstance", "()Ljava/lang/Object;");
        Set<CGNode> newInstanceNodes = cg.getNodes(mr);
        HashSet succNodes = HashSetFactory.make();
        for (CGNode newInstanceNode : newInstanceNodes) {
            Iterator<CGNode> succNodesIter = cg.getSuccNodes(newInstanceNode);
            while (succNodesIter.hasNext()) {
                succNodes.add(succNodesIter.next());
            }
        }
        TypeReference extraneousTR = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lreflection/Reflect5$A");
        MethodReference extraneousMR = MethodReference.findOrCreate(extraneousTR, "<init>", "()V");
        Set<CGNode> extraneousNodes = cg.getNodes(extraneousMR);
        succNodes.retainAll(extraneousNodes);
        Assert.assertTrue((boolean)succNodes.isEmpty());
    }

    @Test
    public void testReflect6() throws IOException, ClassHierarchyException, IllegalArgumentException, CancelException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect6");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Ljava/lang/Class");
        MethodReference mr = MethodReference.findOrCreate(tr, "newInstance", "()Ljava/lang/Object;");
        Set<CGNode> newInstanceNodes = cg.getNodes(mr);
        HashSet succNodes = HashSetFactory.make();
        for (CGNode newInstanceNode : newInstanceNodes) {
            Iterator<CGNode> succNodesIter = cg.getSuccNodes(newInstanceNode);
            while (succNodesIter.hasNext()) {
                succNodes.add(succNodesIter.next());
            }
        }
        TypeReference extraneousTR = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lreflection/Reflect6$A");
        MethodReference extraneousMR = MethodReference.findOrCreate(extraneousTR, "<init>", "(I)V");
        Set<CGNode> extraneousNodes = cg.getNodes(extraneousMR);
        succNodes.retainAll(extraneousNodes);
        Assert.assertTrue((boolean)succNodes.isEmpty());
    }

    @Test
    public void testReflect7() throws Exception {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect7");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        String mainClass = "Lreflection/Reflect7";
        TypeReference mainTr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lreflection/Reflect7");
        MethodReference mainMr = MethodReference.findOrCreate(mainTr, "main", "([Ljava/lang/String;)V");
        TypeReference constrTr = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/reflect/Constructor");
        MethodReference newInstanceMr = MethodReference.findOrCreate(constrTr, "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;");
        String fpInitSig = "java.io.FilePermission.<init>(Ljava/lang/String;Ljava/lang/String;)V";
        String fpToStringSig = "java.security.Permission.toString()Ljava/lang/String;";
        Set<CGNode> mainNodes = cg.getNodes(mainMr);
        Collection<CGNode> mainChildren = this.getSuccNodes(cg, mainNodes);
        CGNode filePermConstrNewInstanceNode = null;
        for (CGNode node : mainChildren) {
            ReceiverInstanceContext r;
            ConstantKey c;
            IMethod ctor;
            Context context = node.getContext();
            if (!(context instanceof ReceiverInstanceContext) || !node.getMethod().getReference().equals(newInstanceMr) || !(ctor = (IMethod)(c = (ConstantKey)(r = (ReceiverInstanceContext)context).getReceiver()).getValue()).getSignature().equals(fpInitSig)) continue;
            filePermConstrNewInstanceNode = node;
            break;
        }
        Assert.assertTrue((filePermConstrNewInstanceNode != null ? 1 : 0) != 0);
        CGNode filePermInitNode = null;
        Iterator<Object> filePermConstrNewInstanceChildren = cg.getSuccNodes(filePermConstrNewInstanceNode);
        while (filePermConstrNewInstanceChildren.hasNext()) {
            CGNode node = filePermConstrNewInstanceChildren.next();
            if (!node.getMethod().getSignature().equals(fpInitSig)) continue;
            filePermInitNode = node;
            break;
        }
        Assert.assertTrue((filePermInitNode != null ? 1 : 0) != 0);
        CGNode filePermToStringNode = null;
        for (CGNode node : mainChildren) {
            if (!node.getMethod().getSignature().equals(fpToStringSig)) continue;
            filePermToStringNode = node;
            break;
        }
        Assert.assertTrue((filePermToStringNode != null ? 1 : 0) != 0);
    }

    private Collection<CGNode> getSuccNodes(CallGraph cg, Collection<CGNode> nodes) {
        HashSet<CGNode> succNodes = HashSetFactory.make();
        for (CGNode newInstanceNode : nodes) {
            Iterator<CGNode> succNodesIter = cg.getSuccNodes(newInstanceNode);
            while (succNodesIter.hasNext()) {
                succNodes.add(succNodesIter.next());
            }
        }
        return succNodes;
    }

    @Test
    public void testReflect8() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect8");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/Integer");
        MethodReference mr = MethodReference.findOrCreate(tr, "toString", "()Ljava/lang/String;");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
    }

    @Test
    public void testReflect9() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect9");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/Integer");
        MethodReference mr = MethodReference.findOrCreate(tr, "toString", "()Ljava/lang/String;");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
    }

    @Test
    public void testReflect10() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect10");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/Integer");
        MethodReference mr = MethodReference.findOrCreate(tr, "toString", "()Ljava/lang/String;");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
    }

    @Test
    public void testReflect11() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect11");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/Object");
        MethodReference mr = MethodReference.findOrCreate(tr, "wait", "()V");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
    }

    @Test
    public void testReflect12() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect12");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lreflection/Helper");
        MethodReference mr = MethodReference.findOrCreate(tr, "m", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
        mr = MethodReference.findOrCreate(tr, "n", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        nodes = cg.getNodes(mr);
        Assert.assertTrue((boolean)nodes.isEmpty());
    }

    @Test
    public void testReflect13() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect13");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lreflection/Helper");
        MethodReference mr = MethodReference.findOrCreate(tr, "m", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
        mr = MethodReference.findOrCreate(tr, "n", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
    }

    @Test
    public void testReflect14() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect14");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lreflection/Helper");
        MethodReference mr = MethodReference.findOrCreate(tr, "s", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
        mr = MethodReference.findOrCreate(tr, "n", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        nodes = cg.getNodes(mr);
        Assert.assertTrue((boolean)nodes.isEmpty());
    }

    @Test
    public void testReflect15() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect15");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lreflection/Helper");
        MethodReference mr = MethodReference.findOrCreate(tr, "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
        mr = MethodReference.findOrCreate(tr, "<init>", "(Ljava/lang/Object;)V");
        nodes = cg.getNodes(mr);
        Assert.assertTrue((boolean)nodes.isEmpty());
        mr = MethodReference.findOrCreate(tr, "<init>", "()V");
        nodes = cg.getNodes(mr);
        Assert.assertTrue((boolean)nodes.isEmpty());
        mr = MethodReference.findOrCreate(tr, "n", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
    }

    @Test
    public void testReflect16() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect16");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/Integer");
        MethodReference mr = MethodReference.findOrCreate(tr, "toString", "()Ljava/lang/String;");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
    }

    @Test
    public void testReflect17() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect17");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lreflection/Helper");
        MethodReference mr = MethodReference.findOrCreate(tr, "t", "(Ljava/lang/Integer;)V");
        CGNode node = cg.getNode(cg.getClassHierarchy().resolveMethod(mr), Everywhere.EVERYWHERE);
        Assert.assertEquals((long)0L, (long)cg.getSuccNodeCount(node));
    }

    @Test
    public void testReflect18() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect18");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lreflection/Helper");
        MethodReference mr = MethodReference.findOrCreate(tr, "t", "(Ljava/lang/Integer;)V");
        CGNode node = cg.getNode(cg.getClassHierarchy().resolveMethod(mr), Everywhere.EVERYWHERE);
        Assert.assertEquals((long)1L, (long)cg.getSuccNodeCount(node));
        CGNode succ = cg.getSuccNodes(node).next();
        Assert.assertEquals((Object)"Node: < Primordial, Ljava/lang/Integer, toString()Ljava/lang/String; > Context: Everywhere", (Object)succ.toString());
    }

    @Test
    public void testReflect19() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect19");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/Integer");
        MethodReference mr = MethodReference.findOrCreate(tr, "toString", "()Ljava/lang/String;");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
    }

    @Test
    public void testReflect20() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect20");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lreflection/Helper");
        MethodReference mr = MethodReference.findOrCreate(tr, "o", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
    }

    @Test
    public void testReflect21() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect21");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lreflection/Helper");
        MethodReference mr = MethodReference.findOrCreate(tr, "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
    }

    @Test
    public void testReflect22() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect22");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lreflection/Helper");
        MethodReference mr = MethodReference.findOrCreate(tr, "<init>", "(Ljava/lang/Integer;)V");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
    }

    @Test
    public void testReflect23() throws WalaException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = ReflectionTest.findOrCreateAnalysisScope();
        IClassHierarchy cha = ReflectionTest.findOrCreateCHA(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha, "Lreflection/Reflect23");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroOneCFA(options, new AnalysisCache(), cha, scope, false);
        TypeReference tr = TypeReference.findOrCreate(ClassLoaderReference.Application, "Lreflection/Helper");
        MethodReference mr = MethodReference.findOrCreate(tr, "u", "(Ljava/lang/Integer;)V");
        Set<CGNode> nodes = cg.getNodes(mr);
        Assert.assertFalse((boolean)nodes.isEmpty());
    }
}

