/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.callGraph;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPiNodePolicy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.junit.Test;

public class PiNodeCallGraphTest
extends WalaTestCase {
    private static final String whateverName = "Lpi/PiNodeCallGraphTestCase$Whatever";
    private static final String thisName = "Lpi/PiNodeCallGraphTestCase$This";
    private static final String thatName = "Lpi/PiNodeCallGraphTestCase$That";
    private static final ClassLoaderReference loader = ClassLoaderReference.Application;
    private static final TypeReference whateverRef = TypeReference.findOrCreate(loader, TypeName.string2TypeName("Lpi/PiNodeCallGraphTestCase$Whatever"));
    private static final TypeReference thisRef = TypeReference.findOrCreate(loader, TypeName.string2TypeName("Lpi/PiNodeCallGraphTestCase$This"));
    private static final TypeReference thatRef = TypeReference.findOrCreate(loader, TypeName.string2TypeName("Lpi/PiNodeCallGraphTestCase$That"));
    private static final MethodReference thisBinaryRef = MethodReference.findOrCreate(thisRef, Atom.findOrCreateUnicodeAtom("binary"), Descriptor.findOrCreateUTF8("(Lpi/PiNodeCallGraphTestCase$Whatever;)V"));
    private static final MethodReference thatBinaryRef = MethodReference.findOrCreate(thatRef, Atom.findOrCreateUnicodeAtom("binary"), Descriptor.findOrCreateUTF8("(Lpi/PiNodeCallGraphTestCase$Whatever;)V"));
    private static final MemberReference unary2Ref = MethodReference.findOrCreate(whateverRef, Atom.findOrCreateUnicodeAtom("unary2"), Descriptor.findOrCreateUTF8("()V"));

    public static void main(String[] args) {
        PiNodeCallGraphTest.justThisTest(PiNodeCallGraphTest.class);
    }

    private CallGraph doGraph(boolean usePiNodes) throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, "Lpi/PiNodeCallGraphTestCase");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPiNodePolicy policy = usePiNodes ? SSAOptions.getAllBuiltInPiNodes() : null;
        options.getSSAOptions().setPiNodePolicy(policy);
        return CallGraphTestUtil.buildZeroCFA(options, new AnalysisCache(), cha, scope, false);
    }

    private void checkCallAssertions(CallGraph cg, int desiredNumberOfTargets, int desiredNumberOfCalls) {
        int numberOfCalls = 0;
        HashSet<CGNode> callerNodes = HashSetFactory.make();
        callerNodes.addAll(cg.getNodes(thisBinaryRef));
        callerNodes.addAll(cg.getNodes(thatBinaryRef));
        assert (callerNodes.size() == 2);
        for (CGNode n : callerNodes) {
            Iterator<CallSiteReference> sites = n.iterateCallSites();
            while (sites.hasNext()) {
                CallSiteReference csRef = sites.next();
                if (!csRef.getDeclaredTarget().equals(unary2Ref)) continue;
                ++numberOfCalls;
                assert (cg.getNumberOfTargets(n, csRef) == desiredNumberOfTargets);
            }
        }
        assert (numberOfCalls == desiredNumberOfCalls);
    }

    @Test
    public void testNoPiNodes() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.checkCallAssertions(this.doGraph(false), 2, 2);
    }

    @Test
    public void testPiNodes() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.checkCallAssertions(this.doGraph(true), 1, 2);
    }
}

