/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.callGraph;

import com.ibm.wala.core.tests.callGraph.CallGraphTest;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.intset.BimodalMutableIntSetFactory;
import com.ibm.wala.util.intset.BitVectorIntSetFactory;
import com.ibm.wala.util.intset.DebuggingMutableIntSetFactory;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSetFactory;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.SemiSparseMutableIntSetFactory;
import java.io.IOException;
import org.junit.Test;

public class DebuggingBitsetCallGraphTest
extends WalaTestCase {
    private final CallGraphTest graphTest = new CallGraphTest();

    public static void main(String[] args) {
        DebuggingBitsetCallGraphTest.justThisTest(DebuggingBitsetCallGraphTest.class);
    }

    private void runBitsetTest(MutableIntSetFactory p, MutableIntSetFactory s) throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        MutableIntSetFactory<?> save = IntSetUtil.getDefaultIntSetFactory();
        try {
            IntSetUtil.setDefaultIntSetFactory(new DebuggingMutableIntSetFactory(p, s));
            this.graphTest.testJLex();
        }
        finally {
            IntSetUtil.setDefaultIntSetFactory(save);
        }
    }

    @Test
    public void testBimodalSparse() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.runBitsetTest(new BimodalMutableIntSetFactory(), new MutableSparseIntSetFactory());
    }

    @Test
    public void testSharedBimodal() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.runBitsetTest(new MutableSharedBitVectorIntSetFactory(), new BimodalMutableIntSetFactory());
    }

    @Test
    public void testSharedSparse() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.runBitsetTest(new MutableSharedBitVectorIntSetFactory(), new MutableSparseIntSetFactory());
    }

    @Test
    public void testSharedBitVector() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.runBitsetTest(new MutableSharedBitVectorIntSetFactory(), new BitVectorIntSetFactory());
    }

    @Test
    public void testSemiSparseShared() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        this.runBitsetTest(new SemiSparseMutableIntSetFactory(), new MutableSharedBitVectorIntSetFactory());
    }
}

