/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.callGraph;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.impl.AllApplicationEntrypoints;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class CloneTest
extends WalaTestCase {
    @Test
    public void testClone() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        AllApplicationEntrypoints entrypoints = new AllApplicationEntrypoints(scope, cha);
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildRTA(options, new AnalysisCache(), cha, scope);
        TypeReference t = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/text/MessageFormat");
        MethodReference m = MethodReference.findOrCreate(t, "clone", "()Ljava/lang/Object;");
        CGNode node = cg.getNodes(m).iterator().next();
        Iterator<CallSiteReference> i = node.iterateCallSites();
        while (i.hasNext()) {
            Set<CGNode> targets;
            CallSiteReference site = i.next();
            if (!site.isSpecial() || !site.getDeclaredTarget().getDeclaringClass().equals(TypeReference.JavaLangObject) || (targets = cg.getPossibleTargets(node, site)).size() == 1) continue;
            System.err.println(String.valueOf(targets.size()) + " targets found for " + site);
            Iterator<CGNode> k = targets.iterator();
            while (k.hasNext()) {
                System.err.println("  " + k.next());
            }
            Assert.fail((String)("found " + targets.size() + " targets for " + site + " in " + node));
        }
    }
}

