/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.callGraph;

import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import java.io.IOException;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;

public class ClassConstantTest
extends WalaTestCase {
    @Test
    public void testClassConstants() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        TypeReference mainClassRef;
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Assert.assertTrue((cha.lookupClass(mainClassRef = TypeReference.findOrCreate(ClassLoaderReference.Application, "LclassConstant/ClassConstant")) != null ? 1 : 0) != 0);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, "LclassConstant/ClassConstant");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroCFA(options, new AnalysisCache(), cha, scope, false);
        MethodReference mainMethodRef = MethodReference.findOrCreate(mainClassRef, "main", "([Ljava/lang/String;)V");
        Set<CGNode> mainMethodNodes = cg.getNodes(mainMethodRef);
        Assert.assertFalse((boolean)mainMethodNodes.isEmpty());
        CGNode mainMethodNode = mainMethodNodes.iterator().next();
        TypeReference classRef = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/Class");
        MethodReference hashCodeRef = MethodReference.findOrCreate(classRef, "hashCode", "()I");
        Set<CGNode> hashCodeNodes = cg.getNodes(hashCodeRef);
        Assert.assertFalse((boolean)hashCodeNodes.isEmpty());
        Assert.assertTrue((boolean)cg.hasEdge(mainMethodNode, hashCodeNodes.iterator().next()));
    }
}

