/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.callGraph;

import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.io.FileProvider;
import java.io.IOException;

public class CallGraphTestUtil {
    private static final ClassLoader MY_CLASSLOADER = CallGraphTestUtil.class.getClassLoader();
    public static String REGRESSION_EXCLUSIONS = "Java60RegressionExclusions.txt";
    private static final boolean CHECK_FOOTPRINT = false;

    public static AnalysisOptions makeAnalysisOptions(AnalysisScope scope, Iterable<Entrypoint> entrypoints) {
        AnalysisOptions options = new AnalysisOptions(scope, entrypoints);
        return options;
    }

    public static AnalysisScope makeJ2SEAnalysisScope(String scopeFile, String exclusionsFile) throws IOException {
        AnalysisScope scope = AnalysisScopeReader.readJavaScope(scopeFile, new FileProvider().getFile(exclusionsFile), MY_CLASSLOADER);
        return scope;
    }

    public static CallGraph buildRTA(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) throws IllegalArgumentException, CancelException {
        Object S = null;
        CallGraphBuilder builder = Util.makeRTABuilder(options, cache, cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        return cg;
    }

    public static CallGraph buildZeroCFA(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope, boolean testPAtoString) throws IllegalArgumentException, CancelException {
        Object S = null;
        SSAPropagationCallGraphBuilder builder = Util.makeZeroCFABuilder(options, cache, cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        if (testPAtoString) {
            builder.getPointerAnalysis().toString();
        }
        return cg;
    }

    public static CallGraph buildVanillaZeroOneCFA(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) throws IllegalArgumentException, CancelException {
        Object S = null;
        SSAPropagationCallGraphBuilder builder = Util.makeVanillaZeroOneCFABuilder(options, cache, cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        return cg;
    }

    public static CallGraph buildZeroOneCFA(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope, boolean testPAtoString) throws IllegalArgumentException, CancelException {
        Object S = null;
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(options, cache, cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        if (testPAtoString) {
            builder.getPointerAnalysis().toString();
        }
        return cg;
    }

    public static CallGraph buildZeroContainerCFA(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) throws IllegalArgumentException, CancelException {
        Object S = null;
        SSAPropagationCallGraphBuilder builder = Util.makeZeroContainerCFABuilder(options, cache, cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        return cg;
    }

    public static CallGraph buildZeroOneContainerCFA(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) throws IllegalArgumentException, CancelException {
        Object S = null;
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneContainerCFABuilder(options, cache, cha, scope);
        CallGraph cg = builder.makeCallGraph(options, null);
        return cg;
    }
}

