/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.callGraph;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphStats;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.AllApplicationEntrypoints;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cfg.InterproceduralCFG;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphIntegrity;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.warnings.Warnings;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class CallGraphTest
extends WalaTestCase {
    public static void main(String[] args) {
        CallGraphTest.justThisTest(CallGraphTest.class);
    }

    @Test
    public void testJava_cup() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("java_cup.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, "Ljava_cup/Main");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraphTest.doCallGraphs(options, new AnalysisCache(), cha, scope, CallGraphTest.useShortProfile());
    }

    @Test
    public void testBcelVerifier() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("bcel.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, "Lorg/apache/bcel/verifier/Verifier");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraphTest.doCallGraphs(options, new AnalysisCache(), cha, scope);
    }

    @Test
    public void testJLex() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("JLex.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, "LJLex/Main");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraphTest.doCallGraphs(options, new AnalysisCache(), cha, scope);
    }

    @Test
    public void testCornerCases() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        AllApplicationEntrypoints entrypoints = new AllApplicationEntrypoints(scope, cha);
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraphTest.doCallGraphs(options, new AnalysisCache(), cha, scope);
        String ws = Warnings.asString();
        Assert.assertTrue((String)"failed to report a warning about Abstract1", (ws.indexOf("cornerCases/Abstract1") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"reported a warning about Abstract2", (ws.indexOf("cornerCases/Abstract2") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testHello() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("hello.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, "Lhello/Hello");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraphTest.doCallGraphs(options, new AnalysisCache(), cha, scope);
    }

    @Test
    public void testStaticInit() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, "LstaticInit/TestStaticInit");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraph cg = CallGraphTestUtil.buildZeroCFA(options, new AnalysisCache(), cha, scope, false);
        boolean foundDoNothing = false;
        for (CGNode n : cg) {
            if (!n.toString().contains("doNothing")) continue;
            foundDoNothing = true;
            break;
        }
        Assert.assertTrue((boolean)foundDoNothing);
        options.setHandleStaticInit(false);
        cg = CallGraphTestUtil.buildZeroCFA(options, new AnalysisCache(), cha, scope, false);
        for (CGNode n : cg) {
            Assert.assertTrue((!n.toString().contains("doNothing") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSystemProperties() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, "LstaticInit/TestSystemProperties");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        SSAPropagationCallGraphBuilder builder = Util.makeZeroCFABuilder(options, new AnalysisCache(), cha, scope);
        CallGraph cg = builder.makeCallGraph(options);
        for (CGNode n : cg) {
            if (!n.toString().equals("Node: < Application, LstaticInit/TestSystemProperties, main([Ljava/lang/String;)V > Context: Everywhere")) continue;
            boolean foundToCharArray = false;
            for (CGNode callee : Iterator2Iterable.make(cg.getSuccNodes(n))) {
                if (!callee.getMethod().getName().toString().equals("toCharArray")) continue;
                foundToCharArray = true;
                break;
            }
            Assert.assertTrue((boolean)foundToCharArray);
            break;
        }
    }

    @Test
    public void testRecursion() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("wala.testdata.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, "Lrecurse/NList");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraphTest.doCallGraphs(options, new AnalysisCache(), cha, scope);
    }

    @Test
    public void testHelloAllEntrypoints() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("hello.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        AllApplicationEntrypoints entrypoints = new AllApplicationEntrypoints(scope, cha);
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraphTest.doCallGraphs(options, new AnalysisCache(), cha, scope);
    }

    @Test
    public void testIO() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("primordial.txt", CallGraphTestUtil.REGRESSION_EXCLUSIONS);
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Iterable<Entrypoint> entrypoints = CallGraphTest.makePrimordialPublicEntrypoints(scope, cha, "java/io");
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraphTestUtil.buildZeroCFA(options, new AnalysisCache(), cha, scope, false);
    }

    public static Iterable<Entrypoint> makePrimordialPublicEntrypoints(AnalysisScope scope, ClassHierarchy cha, String pkg) {
        final HashSet result = HashSetFactory.make();
        for (IClass clazz : cha) {
            if (clazz.getName().toString().indexOf(pkg) == -1 || clazz.isInterface() || clazz.isAbstract()) continue;
            for (IMethod method : clazz.getDeclaredMethods()) {
                if (!method.isPublic() || method.isAbstract()) continue;
                System.out.println("Entry:" + method.getReference());
                result.add(new DefaultEntrypoint(method, (IClassHierarchy)cha));
            }
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                return result.iterator();
            }
        };
    }

    @Test
    public void testPrimordial() throws ClassHierarchyException, IllegalArgumentException, CancelException, IOException {
        if (CallGraphTest.useShortProfile()) {
            return;
        }
        AnalysisScope scope = CallGraphTestUtil.makeJ2SEAnalysisScope("primordial.txt", System.getProperty("os.name").equals("Mac OS X") ? "Java60RegressionExclusions.txt" : "GUIExclusions.txt");
        ClassHierarchy cha = ClassHierarchy.make(scope);
        Iterable<Entrypoint> entrypoints = CallGraphTest.makePrimordialMainEntrypoints(scope, cha);
        AnalysisOptions options = CallGraphTestUtil.makeAnalysisOptions(scope, entrypoints);
        CallGraphTestUtil.buildZeroCFA(options, new AnalysisCache(), cha, scope, false);
    }

    public static Iterable<Entrypoint> makePrimordialMainEntrypoints(AnalysisScope scope, ClassHierarchy cha) {
        Atom mainMethod = Atom.findOrCreateAsciiAtom("main");
        final HashSet result = HashSetFactory.make();
        for (IClass klass : cha) {
            MethodReference mainRef;
            IMethod m = klass.getMethod((mainRef = MethodReference.findOrCreate(klass.getReference(), mainMethod, Descriptor.findOrCreateUTF8("([Ljava/lang/String;)V"))).getSelector());
            if (m == null) continue;
            result.add(new DefaultEntrypoint(m, (IClassHierarchy)cha));
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                return result.iterator();
            }
        };
    }

    public static void doCallGraphs(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) throws IllegalArgumentException, CancelException {
        CallGraphTest.doCallGraphs(options, cache, cha, scope, false);
    }

    public static void doCallGraphs(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope, boolean testPAToString) throws IllegalArgumentException, CancelException {
        CallGraph cg = CallGraphTestUtil.buildRTA(options, cache, cha, scope);
        try {
            GraphIntegrity.check(cg);
        }
        catch (GraphIntegrity.UnsoundGraphException e1) {
            e1.printStackTrace();
            Assert.assertTrue((String)e1.getMessage(), (boolean)false);
        }
        Set<MethodReference> rtaMethods = CallGraphStats.collectMethods(cg);
        System.err.println("RTA methods reached: " + rtaMethods.size());
        System.err.println(CallGraphStats.getStats(cg));
        System.err.println("RTA warnings:\n");
        cg = CallGraphTestUtil.buildZeroCFA(options, cache, cha, scope, testPAToString);
        Graph<MethodReference> squashZero = CallGraphTest.checkCallGraph(cg, null, rtaMethods, "0-CFA");
        cg = CallGraphTestUtil.buildZeroOneCFA(options, cache, cha, scope, testPAToString);
        Graph<MethodReference> squashZeroOne = CallGraphTest.checkCallGraph(cg, squashZero, null, "0-1-CFA");
        cg = CallGraphTestUtil.buildZeroContainerCFA(options, cache, cha, scope);
        Graph<MethodReference> squashZeroContainer = CallGraphTest.checkCallGraph(cg, squashZero, null, "0-Container-CFA");
        cg = CallGraphTestUtil.buildZeroOneContainerCFA(options, cache, cha, scope);
        CallGraphTest.checkCallGraph(cg, squashZeroContainer, null, "0-1-Container-CFA");
        CallGraphTest.checkCallGraph(cg, squashZeroOne, null, "0-1-Container-CFA");
        CallGraphTest.checkICFG(cg);
    }

    private static void checkICFG(CallGraph cg) {
        InterproceduralCFG icfg = new InterproceduralCFG(cg);
        try {
            GraphIntegrity.check(icfg);
        }
        catch (GraphIntegrity.UnsoundGraphException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
        int count = 0;
        for (BasicBlockInContext bb : icfg) {
            if (!icfg.hasCall(bb)) continue;
            ++count;
        }
    }

    private static Graph<MethodReference> checkCallGraph(CallGraph cg, Graph<MethodReference> superCG, Set<MethodReference> superMethods, String thisAlgorithm) {
        try {
            GraphIntegrity.check(cg);
        }
        catch (GraphIntegrity.UnsoundGraphException e1) {
            Assert.assertTrue((String)e1.getMessage(), (boolean)false);
        }
        Set<MethodReference> callGraphMethods = CallGraphStats.collectMethods(cg);
        System.err.println(String.valueOf(thisAlgorithm) + " methods reached: " + callGraphMethods.size());
        System.err.println(CallGraphStats.getStats(cg));
        Graph<MethodReference> thisCG = CallGraphTest.squashCallGraph(thisAlgorithm, cg);
        if (superCG != null) {
            Util.checkGraphSubset(superCG, thisCG);
        }
        return thisCG;
    }

    public static Graph<MethodReference> squashCallGraph(final String name, final CallGraph cg) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        final HashSet nodes = HashSetFactory.make();
        Iterator nodesI = cg.iterator();
        while (nodesI.hasNext()) {
            nodes.add(((CGNode)nodesI.next()).getMethod().getReference());
        }
        return new Graph<MethodReference>(){

            public String toString() {
                StringBuffer result = new StringBuffer();
                result.append("squashed " + name + " call graph\n");
                result.append("Original graph:");
                result.append(cg.toString());
                return result.toString();
            }

            @Override
            public Iterator<MethodReference> iterator() {
                return nodes.iterator();
            }

            @Override
            public boolean containsNode(MethodReference N) {
                return nodes.contains(N);
            }

            @Override
            public int getNumberOfNodes() {
                return nodes.size();
            }

            @Override
            public Iterator<MethodReference> getPredNodes(MethodReference N) {
                HashSet pred = HashSetFactory.make(10);
                MethodReference methodReference = N;
                Iterator<CGNode> i = cg.getNodes(methodReference).iterator();
                while (i.hasNext()) {
                    Iterator<CGNode> ps = cg.getPredNodes(i.next());
                    while (ps.hasNext()) {
                        pred.add(ps.next().getMethod().getReference());
                    }
                }
                return pred.iterator();
            }

            @Override
            public int getPredNodeCount(MethodReference N) {
                int count = 0;
                Iterator<MethodReference> ps = this.getPredNodes(N);
                while (ps.hasNext()) {
                    ++count;
                    ps.next();
                }
                return count;
            }

            @Override
            public Iterator<MethodReference> getSuccNodes(MethodReference N) {
                HashSet succ = HashSetFactory.make(10);
                MethodReference methodReference = N;
                Iterator<CGNode> i = cg.getNodes(methodReference).iterator();
                while (i.hasNext()) {
                    Iterator<CGNode> ps = cg.getSuccNodes(i.next());
                    while (ps.hasNext()) {
                        succ.add(ps.next().getMethod().getReference());
                    }
                }
                return succ.iterator();
            }

            @Override
            public int getSuccNodeCount(MethodReference N) {
                int count = 0;
                Iterator<MethodReference> ps = this.getSuccNodes(N);
                while (ps.hasNext()) {
                    ++count;
                    ps.next();
                }
                return count;
            }

            @Override
            public void addNode(MethodReference n) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeNode(MethodReference n) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void addEdge(MethodReference src, MethodReference dst) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeEdge(MethodReference src, MethodReference dst) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeAllIncidentEdges(MethodReference node) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeNodeAndEdges(MethodReference N) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeIncomingEdges(MethodReference node) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeOutgoingEdges(MethodReference node) {
                Assertions.UNREACHABLE();
            }

            @Override
            public boolean hasEdge(MethodReference src, MethodReference dst) {
                Iterator<MethodReference> succNodes = this.getSuccNodes(src);
                while (succNodes.hasNext()) {
                    if (!dst.equals(succNodes.next())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

