/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.basic;

import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.graph.traverse.WelshPowell;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class WelshPowellTest {
    private <T> void assertColoring(Graph<T> G, Map<T, Integer> colors) {
        for (Object n : G) {
            Iterator ss = G.getSuccNodes(n);
            while (ss.hasNext()) {
                Assert.assertTrue((colors.get(n).intValue() != colors.get(ss.next()).intValue() ? 1 : 0) != 0);
            }
            Iterator ps = G.getPredNodes(n);
            while (ps.hasNext()) {
                Assert.assertTrue((colors.get(n).intValue() != colors.get(ps.next()).intValue() ? 1 : 0) != 0);
            }
        }
    }

    private <T> Graph<T> buildGraph(T[][] data) {
        SlowSparseNumberedGraph<T> G = SlowSparseNumberedGraph.make();
        int i = 0;
        while (i < data.length) {
            G.addNode(data[i][0]);
            ++i;
        }
        i = 0;
        while (i < data.length) {
            int j = 1;
            while (j < data[i].length) {
                G.addEdge(data[i][0], data[i][j]);
                ++j;
            }
            ++i;
        }
        return G;
    }

    @Test
    public void testOne() {
        Graph<Integer> G = this.buildGraph(new Integer[][]{{1, 6, 7, 8}, {2, 5, 7, 8}, {3, 5, 6, 8}, {4, 7, 6, 5}, {5, 2, 4, 3}, {6, 3, 1, 4}, {7, 1, 2, 4}, {8, 1, 2, 3}});
        Pair<Map<Integer, Integer>, Integer> colors = new WelshPowell<Integer>().color(G);
        System.err.println(colors);
        this.assertColoring(G, (Map)colors.fst);
        Assert.assertTrue(((Integer)colors.snd <= 4 ? 1 : 0) != 0);
    }

    @Test
    public void testTwo() {
        Graph<String> G = this.buildGraph(new String[][]{{"poly1", "poly2", "star1", "poly5"}, {"poly2", "poly1", "star2", "poly3"}, {"poly3", "poly2", "star3", "poly4"}, {"poly4", "poly3", "star4", "poly5"}, {"poly5", "poly4", "star5", "poly1"}, {"star1", "poly1", "star3", "star4"}, {"star2", "poly2", "star4", "star5"}, {"star3", "poly3", "star1", "star5"}, {"star4", "poly4", "star1", "star2"}, {"star5", "poly5", "star2", "star3"}});
        Pair<Map<String, Integer>, Integer> colors = new WelshPowell<String>().color(G);
        System.err.println(colors);
        this.assertColoring(G, (Map)colors.fst);
        Assert.assertTrue(((Integer)colors.snd == 3 ? 1 : 0) != 0);
    }
}

